/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptonstallman.jsonlibjava.process.parser;

import io.github.uptonstallman.jsonlibjava.process.log.ConsoleLog;
import io.github.uptonstallman.jsonlibjava.process.log.Log;
import java.util.regex.Matcher;

public class Constants {
    static int quotes = 34;
    static int backSlash = 92;
    static int leftBrace = 123;
    static int rightBrace = 125;
    static int leftBracket = 91;
    static int rightBracket = 93;
    static int colon = 58;
    static int comma = 44;
    static int minus = 45;
    static int zero = 48;
    static int one = 49;
    static int two = 50;
    static int three = 51;
    static int four = 52;
    static int five = 53;
    static int six = 54;
    static int seven = 55;
    static int eight = 56;
    static int nine = 57;
    static int point = 46;
    static int t = 116;
    static int r = 114;
    static int u = 117;
    static int e = 101;
    static int f = 102;
    static int a = 97;
    static int l = 108;
    static int s = 115;
    static int n = 110;
    int SPACE = 32;
    int TAB = 9;
    int CR = 13;
    int LF = 10;
    final Log log = new ConsoleLog();

    void debugMatcher(Matcher matcher, boolean isValue) {
        this.log.debug("\t" + matcher);
        this.log.debug("\tStart index: " + matcher.start());
        this.log.debug("\tEnd index: " + matcher.end());
        this.log.debug("\tFound: " + matcher.group());
        for (int i = 0; i < matcher.groupCount(); ++i) {
            this.log.debug("group " + i + " :" + matcher.start(i));
        }
        if (isValue) {
            this.log.debug("quotes " + matcher.start("quotes"));
            this.log.debug("brackets " + matcher.start("brackets"));
            this.log.debug("braces " + matcher.start("braces"));
            this.log.debug("number " + matcher.start("number"));
            this.log.debug("tr " + matcher.start("tr"));
            this.log.debug("fa " + matcher.start("fa"));
            this.log.debug("nu " + matcher.start("nu"));
        }
    }

    public static void clearBetweenQuotes(char[] charArray) {
        int containerStart = -1;
        int containerEnd = -1;
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != quotes) continue;
            boolean jump = false;
            try {
                if (charArray[i - 1] == backSlash && charArray[i - 2] != backSlash) {
                    jump = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jump) continue;
            if (containerStart == -1) {
                containerStart = i;
                continue;
            }
            containerEnd = i;
            for (int ii = containerStart + 1; ii <= containerEnd - 1; ++ii) {
                charArray[ii] = '\u0000';
            }
            containerStart = -1;
            containerEnd = -1;
        }
    }

    public static void clearBetweenBracesAndBrackets(char[] charArray) {
        int containerStart = -1;
        int containerEnd = -1;
        int nivel = 0;
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == leftBrace || charArray[i] == leftBracket) {
                if (nivel == 1) {
                    containerStart = i;
                }
                ++nivel;
                continue;
            }
            if (charArray[i] != rightBrace && charArray[i] != rightBracket) continue;
            if (nivel == 2) {
                containerEnd = i;
                for (int ii = containerStart + 1; ii <= containerEnd - 1; ++ii) {
                    charArray[ii] = '\u0000';
                }
                containerStart = -1;
                containerEnd = -1;
                nivel = 1;
                continue;
            }
            --nivel;
        }
    }
}

