/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptonstallman.jsonlibjava.process.parser;

import io.github.uptonstallman.jsonlibjava.input.parser.JsonArrayTextInput;
import io.github.uptonstallman.jsonlibjava.output.parser.JsonArrayListOutput;
import io.github.uptonstallman.jsonlibjava.process.JsonParseException;
import io.github.uptonstallman.jsonlibjava.process.parser.Constants;
import io.github.uptonstallman.jsonlibjava.process.util.ChunksFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonArrayParser
extends Constants {
    List<String> jsonArrayItems = new ArrayList<String>();
    JsonArrayTextInput jsonArrayTextInput;
    private char[] json;
    private char[] copy;
    private char[] points;
    private int[] pointsPositions;

    public static JsonArrayListOutput parse(JsonArrayTextInput jsonArrayTextInput) throws JsonParseException {
        JsonArrayParser jsonArrayParser = new JsonArrayParser(jsonArrayTextInput);
        return jsonArrayParser.parse();
    }

    private JsonArrayParser(JsonArrayTextInput jsonArrayTextInput) {
        this.jsonArrayTextInput = jsonArrayTextInput;
    }

    private JsonArrayListOutput parse() throws JsonParseException {
        Matcher matcher;
        int i;
        long startTime = new Date().getTime();
        this.json = this.jsonArrayTextInput.getJsonText().toCharArray();
        this.copy = new char[this.json.length];
        for (int i2 = 0; i2 < this.json.length; ++i2) {
            this.copy[i2] = this.json[i2];
        }
        this.points = new char[this.json.length];
        this.pointsPositions = new int[this.json.length];
        JsonArrayParser.clearBetweenQuotes(this.copy);
        this.log.debug("#1 " + new String(this.copy));
        JsonArrayParser.clearBetweenBracesAndBrackets(this.copy);
        this.log.debug("#2 " + new String(this.copy));
        int ii = 0;
        for (int i3 = 0; i3 < this.copy.length; ++i3) {
            char asciiCode = this.copy[i3];
            if (asciiCode != quotes && asciiCode != backSlash && asciiCode != leftBrace && asciiCode != rightBrace && asciiCode != leftBracket && asciiCode != rightBracket && asciiCode != colon && asciiCode != comma && asciiCode != minus && asciiCode != zero && asciiCode != one && asciiCode != two && asciiCode != three && asciiCode != four && asciiCode != five && asciiCode != six && asciiCode != seven && asciiCode != eight && asciiCode != nine && asciiCode != point && asciiCode != t && asciiCode != r && asciiCode != u && asciiCode != e && asciiCode != f && asciiCode != a && asciiCode != l && asciiCode != s && asciiCode != n) continue;
            this.points[ii] = asciiCode;
            this.pointsPositions[ii] = i3;
            ++ii;
        }
        this.log.debug("#3 " + new String(this.points));
        if (this.points[0] != leftBracket) {
            this.throwException(0);
        }
        this.copy[this.pointsPositions[0]] = 32;
        int pointsSize = 0;
        for (i = 0; i < this.points.length && this.points[i] != '\u0000'; ++i) {
            ++pointsSize;
        }
        if (this.points[pointsSize - 1] != rightBracket) {
            this.throwException(pointsSize - 1);
        }
        this.copy[this.pointsPositions[pointsSize - 1]] = 32;
        if (this.points[0] == leftBracket && this.points[1] == rightBracket) {
            for (i = 2; i < this.points.length; ++i) {
                if (this.points[i] == '\u0000') continue;
                this.throwException(1);
            }
            return new JsonArrayListOutput(Collections.emptyList());
        }
        int start = 1;
        int counterValues = 0;
        String pointsS = new String(this.points);
        do {
            this.log.debug(++counterValues + " Value ===================");
        } while ((start = (matcher = this.findValueAndClear(start, pointsS, pointsSize)).end()) != pointsSize - 1);
        this.log.debug("#4 " + new String(this.copy));
        for (int i4 = 0; i4 < this.copy.length; ++i4) {
            if (this.copy[i4] == this.SPACE || this.copy[i4] == this.TAB || this.copy[i4] == this.CR || this.copy[i4] == this.LF) continue;
            throw new JsonParseException("Validation failed");
        }
        long endTime = new Date().getTime();
        this.log.debug("#5 " + (endTime - startTime) + "ms");
        return new JsonArrayListOutput(this.jsonArrayItems);
    }

    private Matcher findValueAndClear(int start, String literal, int pointsSize) throws JsonParseException {
        int i;
        String patternQuotesS = "(?!\"\"\")(?<quotes>\"\",?)";
        String patternBracketsS = "(?<brackets>\\[],?)";
        String patternBracesS = "(?<braces>\\{},?)";
        String patternNumbersS = "(?<number>-?\\d*(\\.{1})?\\d+,?)";
        String p = "(" + patternQuotesS + "|" + patternBracketsS + "|" + patternBracesS + "|" + patternNumbersS + "|(?<tr>true,?)|(?<fa>false,?)|(?<nu>null,?))";
        this.log.debug(p);
        Pattern pattern = Pattern.compile(p);
        Matcher matcher = pattern.matcher(literal);
        if (!matcher.find(start)) {
            this.throwException(start);
        }
        this.debugMatcher(matcher, true);
        if (matcher.start() != start) {
            this.throwException(start);
        }
        int matcherStart = matcher.start();
        int matcherEnd = matcher.end() - 1;
        int valueStart = this.pointsPositions[matcherStart];
        int valueEnd = this.pointsPositions[matcherEnd];
        char[] value = new char[valueEnd - valueStart + 1];
        int ii = 0;
        for (i = valueStart; i <= valueEnd; ++i) {
            value[ii] = this.json[i];
            ++ii;
        }
        if (matcher.end() == pointsSize - 1) {
            String lastPatternQuotesS = "(?!\"\"\")(?<lastQuotes>^\"\"$)";
            String lastPatternBracketsS = "(?<lastBrackets>^\\[]$)";
            String lastPatternBracesS = "(?<lastBraces>^\\{}$)";
            String lastPatternNumberS = "(?<lastNumber>^-?\\d*(\\.{1})?\\d+$)";
            String lastP = "(" + lastPatternQuotesS + "|" + lastPatternBracketsS + "|" + lastPatternBracesS + "|" + lastPatternNumberS + "|(?<lastTr>^true$)|(?<lastFa>^false$)|(?<lastNu>^null$))";
            Pattern lastPattern = Pattern.compile(lastP);
            Matcher lastMatcher = lastPattern.matcher(matcher.group());
            if (!lastMatcher.matches()) {
                this.throwException(matcher.end() - 1);
            }
            if (lastMatcher.start("lastQuotes") == 0) {
                this.jsonArrayItems.add(ChunksFormatter.quotes(new String(value), true));
            } else if (lastMatcher.start("lastBrackets") == 0) {
                this.jsonArrayItems.add(ChunksFormatter.brackets(new String(value), true));
            } else if (lastMatcher.start("lastBraces") == 0) {
                this.jsonArrayItems.add(ChunksFormatter.braces(new String(value), true));
            } else if (lastMatcher.start("lastNumber") == 0) {
                this.jsonArrayItems.add(ChunksFormatter.number(new String(value), true));
            } else if (lastMatcher.start("lastTr") == 0) {
                this.jsonArrayItems.add(ChunksFormatter.bool(new String(value), true));
            } else if (lastMatcher.start("lastFa") == 0) {
                this.jsonArrayItems.add(ChunksFormatter.bool(new String(value), true));
            } else if (lastMatcher.start("lastNu") == 0) {
                this.jsonArrayItems.add(ChunksFormatter.nulll(new String(value), true));
            } else {
                this.throwException(-1);
            }
            for (int i2 = valueStart; i2 <= valueEnd; ++i2) {
                this.copy[i2] = 32;
            }
            return matcher;
        }
        if (matcher.start("quotes") == start) {
            this.jsonArrayItems.add(ChunksFormatter.quotes(new String(value), false));
        } else if (matcher.start("brackets") == start) {
            this.jsonArrayItems.add(ChunksFormatter.brackets(new String(value), false));
        } else if (matcher.start("braces") == start) {
            this.jsonArrayItems.add(ChunksFormatter.braces(new String(value), false));
        } else if (matcher.start("number") == start) {
            this.jsonArrayItems.add(ChunksFormatter.number(new String(value), false));
        } else if (matcher.start("tr") == start) {
            this.jsonArrayItems.add(ChunksFormatter.bool(new String(value), false));
        } else if (matcher.start("fa") == start) {
            this.jsonArrayItems.add(ChunksFormatter.bool(new String(value), false));
        } else if (matcher.start("nu") == start) {
            this.jsonArrayItems.add(ChunksFormatter.nulll(new String(value), false));
        } else {
            this.throwException(-1);
        }
        for (i = valueStart; i <= valueEnd; ++i) {
            this.copy[i] = 32;
        }
        return matcher;
    }

    private void throwException(int where) throws JsonParseException {
        if (where < 0) {
            throw new JsonParseException("Format error near col [undefined]");
        }
        throw new JsonParseException("Format error near col [" + this.pointsPositions[where] + "]  " + this.json[this.pointsPositions[where]]);
    }
}

