/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptonstallman.jsonlibjava.process.parser;

import io.github.uptonstallman.jsonlibjava.input.parser.JsonObjectTextInput;
import io.github.uptonstallman.jsonlibjava.output.parser.JsonObjectMapOutput;
import io.github.uptonstallman.jsonlibjava.process.JsonParseException;
import io.github.uptonstallman.jsonlibjava.process.log.Level;
import io.github.uptonstallman.jsonlibjava.process.parser.Constants;
import io.github.uptonstallman.jsonlibjava.process.util.ChunksFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonObjectParser
extends Constants {
    private final JsonObjectTextInput jsonObjectTextInput;
    private final Map<String, String> jsonKeysAndValues = new LinkedHashMap<String, String>();
    private char[] json;
    private char[] copy;
    private char[] points;
    private int[] pointsPositions;
    List<String> keys = new ArrayList<String>();
    List<String> values = new ArrayList<String>();

    public static JsonObjectMapOutput parse(JsonObjectTextInput jsonObjectTextInput) throws JsonParseException {
        JsonObjectParser jsonObjectParser = new JsonObjectParser(jsonObjectTextInput);
        return jsonObjectParser.parse();
    }

    private JsonObjectParser(JsonObjectTextInput jsonObjectTextInput) {
        this.jsonObjectTextInput = jsonObjectTextInput;
    }

    private JsonObjectMapOutput parse() throws JsonParseException {
        int i;
        int i2;
        long startTime = new Date().getTime();
        this.json = this.jsonObjectTextInput.getJsonText().toCharArray();
        this.copy = new char[this.json.length];
        for (int i3 = 0; i3 < this.json.length; ++i3) {
            this.copy[i3] = this.json[i3];
        }
        this.points = new char[this.json.length];
        this.pointsPositions = new int[this.json.length];
        JsonObjectParser.clearBetweenQuotes(this.copy);
        this.log.debug("\n\n#1 " + new String(this.copy));
        JsonObjectParser.clearBetweenBracesAndBrackets(this.copy);
        this.log.debug("#2 " + new String(this.copy));
        int ii = 0;
        for (int i4 = 0; i4 < this.copy.length; ++i4) {
            char asciiCode = this.copy[i4];
            if (asciiCode != quotes && asciiCode != backSlash && asciiCode != leftBrace && asciiCode != rightBrace && asciiCode != leftBracket && asciiCode != rightBracket && asciiCode != colon && asciiCode != comma && asciiCode != minus && asciiCode != zero && asciiCode != one && asciiCode != two && asciiCode != three && asciiCode != four && asciiCode != five && asciiCode != six && asciiCode != seven && asciiCode != eight && asciiCode != nine && asciiCode != point && asciiCode != t && asciiCode != r && asciiCode != u && asciiCode != e && asciiCode != f && asciiCode != a && asciiCode != l && asciiCode != s && asciiCode != n) continue;
            this.points[ii] = asciiCode;
            this.pointsPositions[ii] = i4;
            ++ii;
        }
        this.log.debug("#3 " + new String(this.points));
        if (this.points[0] != leftBrace) {
            this.throwException(0);
        }
        this.copy[this.pointsPositions[0]] = 32;
        int pointsSize = 0;
        for (i2 = 0; i2 < this.points.length && this.points[i2] != '\u0000'; ++i2) {
            ++pointsSize;
        }
        if (this.points[pointsSize - 1] != rightBrace) {
            this.throwException(pointsSize - 1);
        }
        this.copy[this.pointsPositions[pointsSize - 1]] = 32;
        if (this.points[0] == leftBrace && this.points[1] == rightBrace) {
            for (i2 = 2; i2 < this.points.length; ++i2) {
                if (this.points[i2] == '\u0000') continue;
                this.throwException(1);
            }
            return new JsonObjectMapOutput(Collections.emptyMap());
        }
        int mode = 1;
        int start = 1;
        int counterKeys = 0;
        int counterValues = 0;
        String pointsS = new String(this.points);
        while (true) {
            Matcher matcher;
            if (mode == 1) {
                this.log.debug(++counterKeys + " Key ============================================");
                matcher = this.findKeyAndClear(start, pointsS);
                start = matcher.end();
                mode = 2;
                continue;
            }
            if (mode != 2) continue;
            this.log.debug(++counterValues + " Value ===================");
            matcher = this.findValueAndClear(start, pointsS, pointsSize);
            start = matcher.end();
            mode = 1;
            if (start == pointsSize - 1) break;
        }
        this.log.debug("#4 " + new String(this.copy));
        for (i = 0; i < this.copy.length; ++i) {
            if (this.copy[i] == this.SPACE || this.copy[i] == this.TAB || this.copy[i] == this.CR || this.copy[i] == this.LF) continue;
            throw new JsonParseException("Validation failed");
        }
        if (this.keys.size() != this.values.size()) {
            this.throwException(-1);
        }
        for (i = 0; i < this.keys.size(); ++i) {
            if (this.jsonObjectTextInput.getRenameKeys() != null && this.jsonObjectTextInput.getRenameKeys().get(this.keys.get(i)) != null) {
                this.log.debug("renaming key " + this.keys.get(i) + " to " + this.jsonObjectTextInput.getRenameKeys().get(this.keys.get(i)));
                this.jsonKeysAndValues.put(this.jsonObjectTextInput.getRenameKeys().get(this.keys.get(i)), this.values.get(i));
            } else {
                this.jsonKeysAndValues.put(this.keys.get(i), this.values.get(i));
            }
            this.log.debug("#5 k: " + this.keys.get(i) + ", v: " + this.values.get(i));
        }
        long endTime = new Date().getTime();
        this.log.debug("#6 " + (endTime - startTime) + "ms");
        return new JsonObjectMapOutput(this.jsonKeysAndValues);
    }

    private Matcher findKeyAndClear(int start, String literal) throws JsonParseException {
        int i;
        String p = "(?!\"\"\")(\"\":)";
        Pattern pattern = Pattern.compile(p);
        Matcher matcher = pattern.matcher(literal);
        if (!matcher.find(start)) {
            this.throwException(start);
        }
        if (this.log.getLevel().equals((Object)Level.DEBUG)) {
            this.debugMatcher(matcher, false);
        }
        if (matcher.start() != start) {
            this.throwException(start);
        }
        int matcherStart = matcher.start();
        int matcherEnd = matcher.end() - 1;
        int valueStart = this.pointsPositions[matcherStart];
        int valueEnd = this.pointsPositions[matcherEnd];
        char[] key = new char[valueEnd - valueStart + 1];
        int ii = 0;
        for (i = valueStart; i <= valueEnd; ++i) {
            key[ii] = this.json[i];
            ++ii;
        }
        this.keys.add(ChunksFormatter.key(new String(key), false));
        for (i = valueStart; i <= valueEnd; ++i) {
            this.copy[i] = 32;
        }
        if (valueEnd == 0) {
            this.copy[valueStart] = 32;
        }
        return matcher;
    }

    private Matcher findValueAndClear(int start, String literal, int pointsSize) throws JsonParseException {
        int i;
        String patternQuotesS = "(?!\"\"\")(?<quotes>\"\",?)";
        String patternBracketsS = "(?<brackets>\\[],?)";
        String patternBracesS = "(?<braces>\\{},?)";
        String patternNumberS = "(?<number>-?\\d*(\\.{1})?\\d+,?)";
        String p = "(" + patternQuotesS + "|" + patternBracketsS + "|" + patternBracesS + "|" + patternNumberS + "|(?<tr>true,?)|(?<fa>false,?)|(?<nu>null,?))";
        this.log.debug(p);
        Pattern pattern = Pattern.compile(p);
        Matcher matcher = pattern.matcher(literal);
        if (!matcher.find(start)) {
            this.throwException(start);
        }
        if (this.log.getLevel().equals((Object)Level.DEBUG)) {
            this.debugMatcher(matcher, true);
        }
        if (matcher.start() != start) {
            this.throwException(start);
        }
        int matcherStart = matcher.start();
        int matcherEnd = matcher.end() - 1;
        int valueStart = this.pointsPositions[matcherStart];
        int valueEnd = this.pointsPositions[matcherEnd];
        char[] value = new char[valueEnd - valueStart + 1];
        int ii = 0;
        for (i = valueStart; i <= valueEnd; ++i) {
            value[ii] = this.json[i];
            ++ii;
        }
        if (matcher.end() == pointsSize - 1) {
            String lastPatternQuotesS = "(?!\"\"\")(?<lastQuotes>^\"\"$)";
            String lastPatternBracketsS = "(?<lastBrackets>^\\[]$)";
            String lastPatternBracesS = "(?<lastBraces>^\\{}$)";
            String lastPatternNumberS = "(?<lastNumber>^-?\\d*(\\.{1})?\\d+$)";
            String lastP = "(" + lastPatternQuotesS + "|" + lastPatternBracketsS + "|" + lastPatternBracesS + "|" + lastPatternNumberS + "|(?<lastTr>^true$)|(?<lastFa>^false$)|(?<lastNu>^null$))";
            Pattern lastPattern = Pattern.compile(lastP);
            Matcher lastMatcher = lastPattern.matcher(matcher.group());
            if (!lastMatcher.matches()) {
                this.throwException(matcher.end() - 1);
            }
            if (lastMatcher.start("lastQuotes") == 0) {
                this.values.add(ChunksFormatter.quotes(new String(value), true));
            } else if (lastMatcher.start("lastBrackets") == 0) {
                this.values.add(ChunksFormatter.brackets(new String(value), true));
            } else if (lastMatcher.start("lastBraces") == 0) {
                this.values.add(ChunksFormatter.braces(new String(value), true));
            } else if (lastMatcher.start("lastNumber") == 0) {
                this.values.add(ChunksFormatter.number(new String(value), true));
            } else if (lastMatcher.start("lastTr") == 0) {
                this.values.add(ChunksFormatter.bool(new String(value), true));
            } else if (lastMatcher.start("lastFa") == 0) {
                this.values.add(ChunksFormatter.bool(new String(value), true));
            } else if (lastMatcher.start("lastNu") == 0) {
                this.values.add(ChunksFormatter.nulll(new String(value), true));
            } else {
                this.throwException(-1);
            }
            for (int i2 = valueStart; i2 <= valueEnd; ++i2) {
                this.copy[i2] = 32;
            }
            return matcher;
        }
        if (matcher.start("quotes") == start) {
            this.values.add(ChunksFormatter.quotes(new String(value), false));
        } else if (matcher.start("brackets") == start) {
            this.values.add(ChunksFormatter.brackets(new String(value), false));
        } else if (matcher.start("braces") == start) {
            this.values.add(ChunksFormatter.braces(new String(value), false));
        } else if (matcher.start("number") == start) {
            this.values.add(ChunksFormatter.number(new String(value), false));
        } else if (matcher.start("tr") == start) {
            this.values.add(ChunksFormatter.bool(new String(value), false));
        } else if (matcher.start("fa") == start) {
            this.values.add(ChunksFormatter.bool(new String(value), false));
        } else if (matcher.start("nu") == start) {
            this.values.add(ChunksFormatter.nulll(new String(value), false));
        } else {
            this.throwException(-1);
        }
        for (i = valueStart; i <= valueEnd; ++i) {
            this.copy[i] = 32;
        }
        return matcher;
    }

    private void throwException(int where) throws JsonParseException {
        if (where < 0) {
            throw new JsonParseException("Format error near col [undefined]");
        }
        throw new JsonParseException("Format error near col [" + this.pointsPositions[where] + "]  " + this.json[this.pointsPositions[where]]);
    }
}

