/*
 * Decompiled with CFR 0.152.
 */
package io.github.uptonstallman.jsonlibjava.process.util;

import io.github.uptonstallman.jsonlibjava.process.JsonParseException;

public class ChunksFormatter {
    public static String key(String v, boolean isLast) throws JsonParseException {
        StringBuilder value = new StringBuilder(v);
        if (!isLast) {
            while (value.length() > 0 && value.charAt(value.length() - 1) != '\"') {
                value.deleteCharAt(value.length() - 1);
            }
        }
        if (!value.toString().startsWith("\"") && !value.toString().endsWith("\"")) {
            throw new JsonParseException("key error: " + value.toString());
        }
        return value.toString().replaceAll("^\"|\"$", "");
    }

    public static String quotes(String v, boolean isLast) throws JsonParseException {
        StringBuilder value = new StringBuilder(v);
        if (!isLast) {
            while (value.length() > 0 && value.charAt(value.length() - 1) != '\"') {
                value.deleteCharAt(value.length() - 1);
            }
        }
        if (!value.toString().startsWith("\"") && !value.toString().endsWith("\"")) {
            throw new JsonParseException("value error: " + value.toString());
        }
        return value.toString();
    }

    public static String brackets(String v, boolean isLast) throws JsonParseException {
        StringBuilder value = new StringBuilder(v);
        if (!isLast) {
            while (value.length() > 0 && value.charAt(value.length() - 1) != ']') {
                value.deleteCharAt(value.length() - 1);
            }
        }
        if (!value.toString().startsWith("[") && !value.toString().endsWith("]")) {
            throw new JsonParseException("value error: " + value.toString());
        }
        return value.toString();
    }

    public static String braces(String v, boolean isLast) throws JsonParseException {
        StringBuilder value = new StringBuilder(v);
        if (!isLast) {
            while (value.length() > 0 && value.charAt(value.length() - 1) != '}') {
                value.deleteCharAt(value.length() - 1);
            }
        }
        if (!value.toString().startsWith("{") && !value.toString().endsWith("}")) {
            throw new JsonParseException("value error: " + value.toString());
        }
        return value.toString();
    }

    public static String number(String v, boolean isLast) throws JsonParseException {
        StringBuilder value = new StringBuilder(v);
        if (!isLast) {
            while (value.length() > 0 && (value.charAt(value.length() - 1) < '0' || value.charAt(value.length() - 1) > '9')) {
                value.deleteCharAt(value.length() - 1);
            }
        }
        try {
            Float.parseFloat(value.toString());
        }
        catch (Exception e) {
            throw new JsonParseException("value error: " + value.toString());
        }
        return value.toString();
    }

    public static String bool(String v, boolean isLast) throws JsonParseException {
        StringBuilder value = new StringBuilder(v);
        if (!isLast) {
            while (value.length() > 0 && value.charAt(value.length() - 1) != 'e') {
                value.deleteCharAt(value.length() - 1);
            }
        }
        if (!value.toString().equals("true") && !value.toString().equals("false")) {
            throw new JsonParseException("value error: " + value.toString());
        }
        return value.toString();
    }

    public static String nulll(String v, boolean isLast) throws JsonParseException {
        StringBuilder value = new StringBuilder(v);
        if (!isLast) {
            while (value.length() > 0 && value.charAt(value.length() - 1) != 'l') {
                value.deleteCharAt(value.length() - 1);
            }
        }
        if (!value.toString().equals("null")) {
            throw new JsonParseException("value error: " + value.toString());
        }
        return value.toString();
    }
}

