/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.market.request;

import com.bybit.api.client.domain.ProductType;

public class MarketOrderBookRequest {
    private final ProductType category;
    private final String symbol;
    private final Integer limit;

    MarketOrderBookRequest(ProductType category, String symbol, Integer limit) {
        this.category = category;
        this.symbol = symbol;
        this.limit = limit;
    }

    public static MarketOrderBookRequestBuilder builder() {
        return new MarketOrderBookRequestBuilder();
    }

    public ProductType getCategory() {
        return this.category;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String toString() {
        return "MarketOrderBookRequest(category=" + this.getCategory() + ", symbol=" + this.getSymbol() + ", limit=" + this.getLimit() + ")";
    }

    public static class MarketOrderBookRequestBuilder {
        private ProductType category;
        private String symbol;
        private Integer limit;

        MarketOrderBookRequestBuilder() {
        }

        public MarketOrderBookRequestBuilder category(ProductType category) {
            this.category = category;
            return this;
        }

        public MarketOrderBookRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public MarketOrderBookRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public MarketOrderBookRequest build() {
            return new MarketOrderBookRequest(this.category, this.symbol, this.limit);
        }

        public String toString() {
            return "MarketOrderBookRequest.MarketOrderBookRequestBuilder(category=" + this.category + ", symbol=" + this.symbol + ", limit=" + this.limit + ")";
        }
    }
}

