/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.BybitApiCallback;
import com.bybit.api.client.exception.BybitApiError;
import com.bybit.api.client.exception.BybitApiException;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class BybitApiCallbackAdapter<T>
implements Callback<T> {
    private final BybitApiCallback<T> callback;

    public BybitApiCallbackAdapter(BybitApiCallback<T> callback) {
        this.callback = callback;
    }

    public void onResponse(@NotNull Call<T> call, Response<T> response) {
        if (response.isSuccessful()) {
            this.callback.onResponse(response.body());
        } else {
            if (response.code() == 504) {
                return;
            }
            try {
                BybitApiError apiError = BybitApiServiceGenerator.getBybitApiError(response);
                this.onFailure(call, new BybitApiException(apiError));
            }
            catch (IOException e) {
                this.onFailure(call, new BybitApiException(e));
            }
        }
    }

    public void onFailure(@NotNull Call<T> call, @NotNull Throwable throwable) {
        if (throwable instanceof BybitApiException) {
            this.callback.onFailure(throwable);
        } else {
            this.callback.onFailure(new BybitApiException(throwable));
        }
    }
}

