/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.BybitApiService;
import com.bybit.api.client.BybitApiTradeRestClient;
import com.bybit.api.client.domain.trade.BatchOrderRequest;
import com.bybit.api.client.domain.trade.TradeOrderRequest;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.JsonConverter;
import java.io.IOException;
import java.util.Map;

public class BybitTradeRestClientImpl
implements BybitApiTradeRestClient {
    private final BybitApiService bybitApiService;
    private final JsonConverter converter = new JsonConverter();

    public BybitTradeRestClientImpl(String apiKey, String secret) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret);
    }

    @Override
    public Object setDisconnectCancelAllTime(Integer timeWindow) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setDisconnectCancelAllTime(timeWindow));
    }

    @Override
    public Object getBorrowQuota(TradeOrderRequest borrowQuotaRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getBorrowQuota(borrowQuotaRequest.getCategory().getProductTypeId(), borrowQuotaRequest.getSymbol(), borrowQuotaRequest.getSide() == null ? null : borrowQuotaRequest.getSide().getTransactionSide()));
    }

    @Override
    public Object getHistoryOrderResult(TradeOrderRequest orderHistoryRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getHistoryOrderResult(orderHistoryRequest.getCategory().getProductTypeId(), orderHistoryRequest.getSymbol(), orderHistoryRequest.getBaseCoin(), orderHistoryRequest.getSettleCoin(), orderHistoryRequest.getOrderId(), orderHistoryRequest.getOrderLinkId(), orderHistoryRequest.getOrderFilter(), orderHistoryRequest.getOrderStatus(), orderHistoryRequest.getStartTime(), orderHistoryRequest.getEndTime(), orderHistoryRequest.getLimit(), orderHistoryRequest.getCursor()));
    }

    @Override
    public Object createOrder(TradeOrderRequest order) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createOrder(order));
    }

    @Override
    public Object createOrder(Map<String, Object> payload) {
        TradeOrderRequest singleOrderRequest = this.converter.convertMapToSingleOrderRequest(payload);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createOrder(singleOrderRequest));
    }

    @Override
    public Object createOrder(String json) throws IOException {
        TradeOrderRequest singleOrderRequest = this.converter.convertJsonToSingleOrderRequest(json);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createOrder(singleOrderRequest));
    }

    @Override
    public Object createBatchOrder(BatchOrderRequest batchOrderRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createBatchOrder(batchOrderRequest));
    }

    @Override
    public Object createBathOrder(Map<String, Object> payload) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createBatchOrder(batchOrderRequest));
    }

    @Override
    public Object createBathOrder(String jsonRequest) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(jsonRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createBatchOrder(batchOrderRequest));
    }

    @Override
    public Object amendBatchOrder(BatchOrderRequest batchOrderRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.amendBatchOrder(batchOrderRequest));
    }

    @Override
    public Object amendBatchOrder(Map<String, Object> payload) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.amendBatchOrder(batchOrderRequest));
    }

    @Override
    public Object amendBatchOrder(String jsonRequest) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(jsonRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.amendBatchOrder(batchOrderRequest));
    }

    @Override
    public Object amendOrder(TradeOrderRequest order) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.amendOrder(order.getCategory().getProductTypeId(), order.getSymbol(), order.getOrderId(), order.getOrderLinkId(), order.getOrderIv(), order.getTriggerPrice(), order.getQty(), order.getPrice(), order.getTakeProfit(), order.getStopLoss(), order.getTpTriggerBy(), order.getSlTriggerBy(), order.getTriggerBy(), order.getTpLimitPrice(), order.getSlLimitPrice()));
    }

    @Override
    public Object cancelOrder(TradeOrderRequest order) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelOrder(order.getCategory().getProductTypeId(), order.getSymbol(), order.getOrderId(), order.getOrderLinkId(), order.getOrderFilter()));
    }

    @Override
    public Object cancelBatchOrder(BatchOrderRequest batchOrderRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelBatchOrder(batchOrderRequest));
    }

    @Override
    public Object cancelBatchOrder(Map<String, Object> payload) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelBatchOrder(batchOrderRequest));
    }

    @Override
    public Object cancelBatchOrder(String json) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelBatchOrder(batchOrderRequest));
    }

    @Override
    public Object cancelAllOrder(TradeOrderRequest order) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelAllOrder(order.getCategory().getProductTypeId(), order.getSymbol(), order.getBaseCoin(), order.getSettleCoin(), order.getOrderFilter(), order.getStopOrderType() == null ? null : order.getStopOrderType().getDescription()));
    }

    @Override
    public Object getOpenOrders(TradeOrderRequest order) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getOpenOrders(order.getCategory().getProductTypeId(), order.getSymbol(), order.getBaseCoin(), order.getSettleCoin(), order.getOrderId(), order.getOrderLinkId(), order.getOpenOnly(), order.getOrderFilter(), order.getLimit(), order.getCursor()));
    }
}

