/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.market.request;

import com.bybit.api.client.domain.ProductType;

public class DeliveryPriceRequest {
    private final ProductType category;
    private final String symbol;
    private final String baseCoin;
    private final Integer limit;
    private final String cursor;

    DeliveryPriceRequest(ProductType category, String symbol, String baseCoin, Integer limit, String cursor) {
        this.category = category;
        this.symbol = symbol;
        this.baseCoin = baseCoin;
        this.limit = limit;
        this.cursor = cursor;
    }

    public static DeliveryPriceRequestBuilder builder() {
        return new DeliveryPriceRequestBuilder();
    }

    public ProductType getCategory() {
        return this.category;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getBaseCoin() {
        return this.baseCoin;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String toString() {
        return "DeliveryPriceRequest(category=" + this.getCategory() + ", symbol=" + this.getSymbol() + ", baseCoin=" + this.getBaseCoin() + ", limit=" + this.getLimit() + ", cursor=" + this.getCursor() + ")";
    }

    public static class DeliveryPriceRequestBuilder {
        private ProductType category;
        private String symbol;
        private String baseCoin;
        private Integer limit;
        private String cursor;

        DeliveryPriceRequestBuilder() {
        }

        public DeliveryPriceRequestBuilder category(ProductType category) {
            this.category = category;
            return this;
        }

        public DeliveryPriceRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public DeliveryPriceRequestBuilder baseCoin(String baseCoin) {
            this.baseCoin = baseCoin;
            return this;
        }

        public DeliveryPriceRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public DeliveryPriceRequestBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public DeliveryPriceRequest build() {
            return new DeliveryPriceRequest(this.category, this.symbol, this.baseCoin, this.limit, this.cursor);
        }

        public String toString() {
            return "DeliveryPriceRequest.DeliveryPriceRequestBuilder(category=" + this.category + ", symbol=" + this.symbol + ", baseCoin=" + this.baseCoin + ", limit=" + this.limit + ", cursor=" + this.cursor + ")";
        }
    }
}

