/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.security;

import com.bybit.api.client.constant.Util;
import com.bybit.api.client.security.HmacSHA256Signer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AuthenticationInterceptor
implements Interceptor {
    private final String apiKey;
    private final String secret;

    public AuthenticationInterceptor(String apiKey, String secret) {
        this.apiKey = apiKey;
        this.secret = secret;
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original = chain.request();
        Request.Builder newRequestBuilder = original.newBuilder();
        boolean isApiKeyRequired = original.header("X-BAPI-API-KEY") != null;
        boolean isSignatureRequired = original.header("X-BAPI-SIGN") != null;
        newRequestBuilder.removeHeader("X-BAPI-API-KEY").removeHeader("X-BAPI-SIGN");
        String payload = "";
        if ("GET".equals(original.method())) {
            payload = original.url().query();
            newRequestBuilder.get();
        } else if ("POST".equals(original.method()) && original.body() != null) {
            Buffer buffer = new Buffer();
            original.body().writeTo((BufferedSink)buffer);
            payload = buffer.readUtf8();
            if (StringUtils.isEmpty((CharSequence)payload)) {
                payload = original.url().query();
                Map<String, Object> paramsMap = Util.convertQueryToMap(payload);
                ObjectMapper objectMapper = new ObjectMapper();
                payload = objectMapper.writeValueAsString(paramsMap);
            }
            HttpUrl newUrl = original.url().newBuilder().query(null).build();
            newRequestBuilder.url(newUrl);
            MediaType mediaType = MediaType.parse((String)"application/json");
            newRequestBuilder.post(RequestBody.create((MediaType)mediaType, (String)payload));
        }
        if (isApiKeyRequired || isSignatureRequired) {
            long timestamp = Util.generateTimestamp();
            String signature = HmacSHA256Signer.sign(this.apiKey, this.secret, StringUtils.isEmpty((CharSequence)payload) ? "" : payload, timestamp, 50000L);
            newRequestBuilder.addHeader("X-BAPI-API-KEY", this.apiKey);
            newRequestBuilder.addHeader("X-BAPI-SIGN", signature);
            newRequestBuilder.addHeader("X-BAPI-SIGN-TYPE", "2");
            newRequestBuilder.addHeader("X-BAPI-TIMESTAMP", String.valueOf(timestamp));
            newRequestBuilder.addHeader("X-BAPI-RECV-WINDOW", String.valueOf(50000L));
            newRequestBuilder.addHeader("Content-Type", "application/json");
        }
        Request newRequest = newRequestBuilder.build();
        return chain.proceed(newRequest);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationInterceptor that = (AuthenticationInterceptor)o;
        return Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.secret, that.secret);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.secret);
    }
}

