/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.service;

import com.bybit.api.client.BybitAnnouncementRestClient;
import com.bybit.api.client.BybitApiAsyncRestClient;
import com.bybit.api.client.BybitApiAsyncTradeRestClient;
import com.bybit.api.client.BybitApiInsLendingRestClient;
import com.bybit.api.client.BybitApiRestClient;
import com.bybit.api.client.BybitApiTradeRestClient;
import com.bybit.api.client.config.BybitApiConfig;
import com.bybit.api.client.impl.BybitAnnouncementRestClientImpl;
import com.bybit.api.client.impl.BybitApiAsyncRestClientImpl;
import com.bybit.api.client.impl.BybitApiRestClientImpl;
import com.bybit.api.client.impl.BybitInsLendingRestClientImpl;
import com.bybit.api.client.impl.BybitTradeAsyncRestClientImpl;
import com.bybit.api.client.impl.BybitTradeRestClientImpl;
import com.bybit.api.client.websocket.WebsocketClient;
import com.bybit.api.client.websocket.WebsocketClientImpl;
import com.bybit.api.client.websocket.WebsocketMessageHandler;

public class BybitApiClientFactory {
    private final String apiKey;
    private final String secret;

    private BybitApiClientFactory(String apiKey, String secret) {
        this.apiKey = apiKey;
        this.secret = secret;
        BybitApiConfig.useTestnet = true;
    }

    private BybitApiClientFactory(String apiKey, String secret, boolean useTestnet) {
        this(apiKey, secret);
        if (useTestnet) {
            BybitApiConfig.useTestnet = true;
        }
    }

    public static BybitApiClientFactory newInstance(String apiKey, String secret) {
        return new BybitApiClientFactory(apiKey, secret);
    }

    public static BybitApiClientFactory newInstance(String apiKey, String secret, boolean useTestnet) {
        return new BybitApiClientFactory(apiKey, secret, useTestnet);
    }

    public static BybitApiClientFactory newInstance() {
        return new BybitApiClientFactory(null, null);
    }

    public static BybitApiClientFactory newInstance(boolean useTestnet) {
        return new BybitApiClientFactory(null, null, useTestnet);
    }

    public BybitApiRestClient newRestClient() {
        return new BybitApiRestClientImpl(this.apiKey, this.secret);
    }

    public BybitAnnouncementRestClient newAnnouncementRestClient() {
        return new BybitAnnouncementRestClientImpl();
    }

    public BybitApiAsyncRestClient newAsyncRestClient() {
        return new BybitApiAsyncRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiInsLendingRestClient newInsLendingRestClient() {
        return new BybitInsLendingRestClientImpl();
    }

    public BybitApiTradeRestClient newTradeRestClient() {
        return new BybitTradeRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAsyncTradeRestClient newAsyncTradeRestClient() {
        return new BybitTradeAsyncRestClientImpl(this.apiKey, this.secret);
    }

    public WebsocketClient newWebsocketClient(WebsocketMessageHandler messageHandler) {
        return new WebsocketClientImpl(this.apiKey, this.secret, BybitApiConfig.useTestnet ? "wss://stream-testnet.bybit.com" : "wss://stream.bybit.com", messageHandler);
    }
}

