/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.BybitApiAsyncRestClient;
import com.bybit.api.client.BybitApiCallback;
import com.bybit.api.client.BybitApiService;
import com.bybit.api.client.constant.Util;
import com.bybit.api.client.domain.account.AccountDataRequest;
import com.bybit.api.client.domain.account.request.ResetMMPRequest;
import com.bybit.api.client.domain.account.request.SetCollateralCoinRequest;
import com.bybit.api.client.domain.account.request.SetMMPRequest;
import com.bybit.api.client.domain.account.request.SetMarginModeRequest;
import com.bybit.api.client.domain.asset.AssetDataRequest;
import com.bybit.api.client.domain.asset.request.AssetCancelWithdrawRequest;
import com.bybit.api.client.domain.asset.request.AssetInternalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetUniversalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetWithdrawRequest;
import com.bybit.api.client.domain.asset.request.SetAssetDepositAccountRequest;
import com.bybit.api.client.domain.market.MarketDataRequest;
import com.bybit.api.client.domain.position.PositionDataRequest;
import com.bybit.api.client.domain.position.request.ModifyMarginRequest;
import com.bybit.api.client.domain.position.request.SetAutoAddMarginRequest;
import com.bybit.api.client.domain.position.request.SetLeverageRequest;
import com.bybit.api.client.domain.position.request.SetRiskLimitRequest;
import com.bybit.api.client.domain.position.request.SetTpSlModeRequest;
import com.bybit.api.client.domain.position.request.SwitchMarginRequest;
import com.bybit.api.client.domain.position.request.SwitchPositionModeRequest;
import com.bybit.api.client.domain.position.request.TradingStopRequest;
import com.bybit.api.client.domain.preupgrade.PreUpgradeDataRequest;
import com.bybit.api.client.domain.user.UserDataRequest;
import com.bybit.api.client.domain.user.request.CreateApiKeyRequest;
import com.bybit.api.client.domain.user.request.FreezeSubUIDRquest;
import com.bybit.api.client.domain.user.request.ModifyApiKeyRequest;
import com.bybit.api.client.domain.user.request.UserSubMemberRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAsyncRestClientImpl
implements BybitApiAsyncRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAsyncRestClientImpl(String apiKey, String secret) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret);
    }

    @Override
    public void getServerTime(BybitApiCallback<Object> callback) {
        this.bybitApiService.getServerTime().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketPriceLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketPriceLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getIndexPriceLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getIndexPriceLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPremiumIndexPriceLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPremiumIndexPriceLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInstrumentsInfo(MarketDataRequest instrumentInfoRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInstrumentsInfo(instrumentInfoRequest.getCategory().getProductTypeId(), instrumentInfoRequest.getSymbol(), instrumentInfoRequest.getInstrumentStatus() == null ? null : instrumentInfoRequest.getInstrumentStatus().getStatus(), instrumentInfoRequest.getBaseCoin(), instrumentInfoRequest.getLimit(), instrumentInfoRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketOrderBook(MarketDataRequest marketOrderBookRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketOrderBook(marketOrderBookRequest.getCategory().getProductTypeId(), marketOrderBookRequest.getSymbol(), marketOrderBookRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketTickers(MarketDataRequest marketDataTickerRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketTickers(marketDataTickerRequest.getCategory().getProductTypeId(), marketDataTickerRequest.getSymbol(), marketDataTickerRequest.getBaseCoin(), marketDataTickerRequest.getExpDate()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getFundingHistory(MarketDataRequest fundingHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getFundingHistory(fundingHistoryRequest.getCategory().getProductTypeId(), fundingHistoryRequest.getSymbol(), fundingHistoryRequest.getStartTime(), fundingHistoryRequest.getEndTime(), fundingHistoryRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getRecentTradeData(MarketDataRequest recentTradeRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getRecentTradeData(recentTradeRequest.getCategory().getProductTypeId(), recentTradeRequest.getBaseCoin(), recentTradeRequest.getOptionType() == null ? null : recentTradeRequest.getOptionType().getOpType(), recentTradeRequest.getSymbol(), recentTradeRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getOpenInterest(MarketDataRequest openInterestRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getOpenInterest(openInterestRequest.getCategory().getProductTypeId(), openInterestRequest.getSymbol(), openInterestRequest.getMarketInterval() == null ? null : openInterestRequest.getMarketInterval().getIntervalId(), openInterestRequest.getStartTime(), openInterestRequest.getEndTime(), openInterestRequest.getLimit(), openInterestRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getHistoricalVolatility(MarketDataRequest historicalVolatilityRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getHistoricalVolatility(historicalVolatilityRequest.getCategory().getProductTypeId(), historicalVolatilityRequest.getBaseCoin(), historicalVolatilityRequest.getOptionPeriod(), historicalVolatilityRequest.getStartTime(), historicalVolatilityRequest.getEndTime()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsurance(String coin, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsurance(coin).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsurance(BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsurance().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getRiskLimit(MarketDataRequest marketRiskLimitRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getRiskLimit(marketRiskLimitRequest.getCategory().getProductTypeId(), marketRiskLimitRequest.getSymbol()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getDeliveryPrice(MarketDataRequest deliveryPriceRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getDeliveryPrice(deliveryPriceRequest.getCategory().getProductTypeId(), deliveryPriceRequest.getSymbol(), deliveryPriceRequest.getBaseCoin(), deliveryPriceRequest.getLimit(), deliveryPriceRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketAccountRatio(MarketDataRequest marketAccountRatioRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketAccountRatio(marketAccountRatioRequest.getCategory().getProductTypeId(), marketAccountRatioRequest.getSymbol(), marketAccountRatioRequest.getDataRecordingPeriod() == null ? null : marketAccountRatioRequest.getDataRecordingPeriod().getPeriod(), marketAccountRatioRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPositionInfo(PositionDataRequest positionListRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPositionInfo(positionListRequest.getCategory().getProductTypeId(), positionListRequest.getSymbol(), positionListRequest.getBaseCoin(), positionListRequest.getSettleCoin(), positionListRequest.getLimit(), positionListRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setPositionLeverage(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SetLeverageRequest setLeverageRequest = this.converter.mapToSetLeverageRequest(positionDataRequest);
        this.bybitApiService.setPositionLeverage(setLeverageRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void swithMarginRequest(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SwitchMarginRequest switchMarginRequest = this.converter.mapToSwitchMarginRequest(positionDataRequest);
        this.bybitApiService.swithMarginRequest(switchMarginRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void switchPositionMode(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SwitchPositionModeRequest switchPositionModeRequest = this.converter.mapToSwitchPositionModeRequest(positionDataRequest);
        this.bybitApiService.switchPositionMode(switchPositionModeRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setTpslMode(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SetTpSlModeRequest setTpSlModeRequest = this.converter.mapToSetTpSlModeRequest(positionDataRequest);
        this.bybitApiService.setTpslMode(setTpSlModeRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setRiskLimit(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SetRiskLimitRequest setRiskLimitRequest = this.converter.mapToSetRiskLimitRequest(positionDataRequest);
        this.bybitApiService.setRiskLimit(setRiskLimitRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setTradingStop(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        TradingStopRequest tradingStopRequest = this.converter.mapToTradingStopRequest(positionDataRequest);
        this.bybitApiService.setTradingStop(tradingStopRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAutoAddMargin(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        SetAutoAddMarginRequest setAutoAddMarginRequest = this.converter.mapToSetAutoAddMarginRequest(positionDataRequest);
        this.bybitApiService.setAutoAddMargin(setAutoAddMarginRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void modifyPositionMargin(PositionDataRequest positionDataRequest, BybitApiCallback<Object> callback) {
        ModifyMarginRequest modifyMarginRequest = this.converter.mapToModifyMarginRequest(positionDataRequest);
        this.bybitApiService.modifyPositionMargin(modifyMarginRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getExecutionList(PositionDataRequest executionHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getExecutionList(executionHistoryRequest.getCategory().getProductTypeId(), executionHistoryRequest.getSymbol(), executionHistoryRequest.getOrderId(), executionHistoryRequest.getOrderLinkId(), executionHistoryRequest.getBaseCoin(), executionHistoryRequest.getStartTime(), executionHistoryRequest.getEndTime(), executionHistoryRequest.getExecType() == null ? null : executionHistoryRequest.getExecType().getExecTypeId(), executionHistoryRequest.getLimit(), executionHistoryRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getClosePnlList(PositionDataRequest closePnlHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getClosePnlList(closePnlHistoryRequest.getCategory().getProductTypeId(), closePnlHistoryRequest.getSymbol(), closePnlHistoryRequest.getStartTime(), closePnlHistoryRequest.getEndTime(), closePnlHistoryRequest.getLimit(), closePnlHistoryRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeOrderHistory(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeOrderHistory(request.getCategory().getProductTypeId(), request.getSymbol(), request.getBaseCoin(), request.getOrderId(), request.getOrderLinkId(), request.getOrderFilter(), request.getOrderStatus() == null ? null : request.getOrderStatus().getDescription(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeTradeHistory(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeTradeHistory(request.getCategory().getProductTypeId(), request.getSymbol(), request.getOrderId(), request.getOrderLinkId(), request.getBaseCoin(), request.getStartTime(), request.getEndTime(), request.getExecType() == null ? null : request.getExecType().getExecTypeId(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeClosePnl(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeClosePnl(request.getCategory().getProductTypeId(), request.getSymbol(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeTransaction(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeTransaction(request.getCategory().getProductTypeId(), request.getBaseCoin(), request.getTransactionType() == null ? null : request.getTransactionType().getTransactionTypeId(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeOptionDelivery(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeOptionDelivery(request.getCategory().getProductTypeId(), request.getSymbol(), request.getExpDate(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeUsdcSettlement(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeUsdcSettlement(request.getCategory().getProductTypeId(), request.getSymbol(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getWalletBalance(AccountDataRequest walletBalanceRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getWalletBalance(walletBalanceRequest.getAccountType().getAccountTypeValue(), walletBalanceRequest.getCoins()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void upgradeAccountToUTA(BybitApiCallback<Object> callback) {
        this.bybitApiService.upgradeAccountToUTA().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountBorrowHistory(AccountDataRequest borrowHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountBorrowHistory(borrowHistoryRequest.getCurrency(), borrowHistoryRequest.getStartTime(), borrowHistoryRequest.getEndTime(), borrowHistoryRequest.getLimit(), borrowHistoryRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAccountCollateralCoin(AccountDataRequest setCollateralCoinRequest, BybitApiCallback<Object> callback) {
        SetCollateralCoinRequest request = this.converter.mapToSetCollateralCoinRequest(setCollateralCoinRequest);
        this.bybitApiService.setAccountCollateralCoin(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountCollateralInfo(AccountDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountCollateralInfo(request.getCurrency()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountCoinGeeks(AccountDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountCoinGeeks(request.getBaseCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountFreeRate(AccountDataRequest getFeeRateRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountFreeRate(getFeeRateRequest.getCategory().getProductTypeId(), getFeeRateRequest.getSymbol(), getFeeRateRequest.getBaseCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountInfo(BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountInfo().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getTransactionLog(AccountDataRequest getTransactionLogRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getTransactionLog(getTransactionLogRequest.getAccountType() == null ? null : getTransactionLogRequest.getAccountType().getAccountTypeValue(), getTransactionLogRequest.getCategory() == null ? null : getTransactionLogRequest.getCategory().getProductTypeId(), getTransactionLogRequest.getCurrency(), getTransactionLogRequest.getBaseCoin(), getTransactionLogRequest.getTransactionType() == null ? null : getTransactionLogRequest.getTransactionType().getTransactionTypeId(), getTransactionLogRequest.getStartTime(), getTransactionLogRequest.getEndTime(), getTransactionLogRequest.getLimit(), getTransactionLogRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAccountMarginMode(AccountDataRequest request, BybitApiCallback<Object> callback) {
        SetMarginModeRequest setMarginMode = this.converter.mapToSetMarginModeRequest(request);
        this.bybitApiService.setAccountMarginMode(setMarginMode).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void modifyAccountMMP(AccountDataRequest setMMPRequest, BybitApiCallback<Object> callback) {
        SetMMPRequest request = this.converter.mapToSetMMPRequest(setMMPRequest);
        this.bybitApiService.modifyAccountMMP(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void resetAccountMMP(AccountDataRequest request, BybitApiCallback<Object> callback) {
        ResetMMPRequest resetMMPRequest = this.converter.mapToResetMarginModeRequest(request);
        this.bybitApiService.resetAccountMMP(resetMMPRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAccountMMPState(AccountDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAccountMMPState(request.getBaseCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetCoinExchangeRecords(AssetDataRequest coinExchangeRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetCoinExchangeRecords(coinExchangeRecordsRequest.getFromCoin(), coinExchangeRecordsRequest.getToCoin(), coinExchangeRecordsRequest.getLimit(), coinExchangeRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetDeliveryRecords(AssetDataRequest deliveryRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetDeliveryRecords(deliveryRecordsRequest.getCategory() == null ? null : deliveryRecordsRequest.getCategory().getProductTypeId(), deliveryRecordsRequest.getSymbol(), deliveryRecordsRequest.getExpDate(), deliveryRecordsRequest.getLimit(), deliveryRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetUSDCSettlementRecords(AssetDataRequest usdcSettlementRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetUSDCSettlementRecords(usdcSettlementRequest.getCategory() == null ? null : usdcSettlementRequest.getCategory().getProductTypeId(), usdcSettlementRequest.getSymbol(), usdcSettlementRequest.getLimit(), usdcSettlementRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetInfo(AssetDataRequest assetInfoRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetInfo(assetInfoRequest.getAccountType() == null ? null : assetInfoRequest.getAccountType().getAccountTypeValue(), assetInfoRequest.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetAllCoinsBalance(AssetDataRequest allCoinsBalanceRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetAllCoinsBalance(allCoinsBalanceRequest.getAccountType() == null ? null : allCoinsBalanceRequest.getAccountType().getAccountTypeValue(), allCoinsBalanceRequest.getMemberId(), allCoinsBalanceRequest.getCoin(), allCoinsBalanceRequest.getWithBonus() == null ? null : String.valueOf(allCoinsBalanceRequest.getWithBonus().getValue())).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetTransferableCoins(AssetDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetTransferableCoins(request.getFromAccountType() == null ? null : request.getFromAccountType().getAccountTypeValue(), request.getToAccountType() == null ? null : request.getToAccountType().getAccountTypeValue()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetSingleCoinBalance(AssetDataRequest singleCoinBalanceRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetSingleCoinBalance(singleCoinBalanceRequest.getAccountType() == null ? null : singleCoinBalanceRequest.getAccountType().getAccountTypeValue(), singleCoinBalanceRequest.getToAccountType() == null ? null : singleCoinBalanceRequest.getToAccountType().getAccountTypeValue(), singleCoinBalanceRequest.getMemberId(), singleCoinBalanceRequest.getToMemberId() == null ? null : singleCoinBalanceRequest.getToMemberId().toString(), singleCoinBalanceRequest.getCoin(), singleCoinBalanceRequest.getWithBonus() == null ? null : Integer.valueOf(singleCoinBalanceRequest.getWithBonus().getValue()), singleCoinBalanceRequest.getWithTransferSafeAmount() == null ? null : Integer.valueOf(singleCoinBalanceRequest.getWithTransferSafeAmount().getValue()), singleCoinBalanceRequest.getWithLtvTransferSafeAmount() == null ? null : Integer.valueOf(singleCoinBalanceRequest.getWithLtvTransferSafeAmount().getValue())).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createAssetInternalTransfer(AssetDataRequest assetInternalTransferRequest, BybitApiCallback<Object> callback) {
        AssetInternalTransferRequest request = this.converter.mapToAssetInternalTransferRequest(assetInternalTransferRequest);
        this.bybitApiService.createAssetInternalTransfer(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetTransferSubUidList(BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetTransferSubUidList().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createAssetUniversalTransfer(AssetDataRequest assetUniversalTransferRequest, BybitApiCallback<Object> callback) {
        AssetUniversalTransferRequest request = this.converter.mapToAssetUniversalTransferRequest(assetUniversalTransferRequest);
        this.bybitApiService.createAssetUniversalTransfer(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetInternalTransferRecords(AssetDataRequest internalTransferRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetInternalTransferRecords(internalTransferRequest.getTransferId(), internalTransferRequest.getCoin(), internalTransferRequest.getTransferStatus() == null ? null : internalTransferRequest.getTransferStatus().getStatus(), internalTransferRequest.getStartTime(), internalTransferRequest.getEndTime(), internalTransferRequest.getLimit(), internalTransferRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetUniversalTransferRecords(AssetDataRequest universalTransferRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetUniversalTransferRecords(universalTransferRequest.getTransferId(), universalTransferRequest.getCoin(), universalTransferRequest.getTransferStatus() == null ? null : universalTransferRequest.getTransferStatus().getStatus(), universalTransferRequest.getStartTime(), universalTransferRequest.getEndTime(), universalTransferRequest.getLimit(), universalTransferRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetAllowedDepositCoinInfo(AssetDataRequest allowedDepositCoinRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetAllowedDepositCoinInfo(allowedDepositCoinRequest.getCoin(), allowedDepositCoinRequest.getChain(), allowedDepositCoinRequest.getLimit(), allowedDepositCoinRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAssetDepositAccount(AssetDataRequest request, BybitApiCallback<Object> callback) {
        SetAssetDepositAccountRequest setAssetDepositAccountRequest = this.converter.mapToSetDepositAccountRequest(request);
        this.bybitApiService.setAssetDepositAccount(setAssetDepositAccountRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetDepositRecords(AssetDataRequest assetDepositRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetSubMembersDepositRecords(AssetDataRequest assetDepositRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetSubMembersDepositRecords(assetDepositRecordsRequest.getSubMemberId(), assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetInternalDepositRecords(AssetDataRequest assetDepositRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetInternalDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetMasterDepositAddress(AssetDataRequest masterDepositRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetMasterDepositAddress(masterDepositRequest.getCoin(), masterDepositRequest.getChainType()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetSubMemberDepositAddress(AssetDataRequest subDepositRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetSubMemberDepositAddress(subDepositRequest.getCoin(), subDepositRequest.getChainType(), subDepositRequest.getSubMemberId()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetCoinInfo(AssetDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetCoinInfo(request.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetWithdrawalAmount(AssetDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetWithdrawalAmount(request.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetWithdrawalRecords(AssetDataRequest assetWithdrawRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetWithdrawalRecords(assetWithdrawRecordsRequest.getWithdrawID(), assetWithdrawRecordsRequest.getCoin(), assetWithdrawRecordsRequest.getWithdrawType() == null ? null : Integer.valueOf(assetWithdrawRecordsRequest.getWithdrawType().getValue()), assetWithdrawRecordsRequest.getStartTime(), assetWithdrawRecordsRequest.getEndTime(), assetWithdrawRecordsRequest.getLimit(), assetWithdrawRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelAssetWithdraw(AssetDataRequest request, BybitApiCallback<Object> callback) {
        AssetCancelWithdrawRequest assetCancelWithdrawRequest = this.converter.mapToAssetCancelWithdrawRequest(request);
        this.bybitApiService.cancelAssetWithdraw(assetCancelWithdrawRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createAssetWithdraw(AssetDataRequest assetWithdrawRequest, BybitApiCallback<Object> callback) {
        AssetWithdrawRequest request = this.converter.mapToAssetWithdrawRequest(assetWithdrawRequest);
        this.bybitApiService.createAssetWithdraw(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createSubMember(UserDataRequest request, BybitApiCallback<Object> callback) {
        UserSubMemberRequest subUserRequest = this.converter.mapToCreateSubMemberRequest(request);
        this.bybitApiService.createSubMember(subUserRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createSubAPI(UserDataRequest request, BybitApiCallback<Object> callback) {
        CreateApiKeyRequest createApiKeyRequest = this.converter.mapToCreateSubApiRequest(request);
        this.bybitApiService.createSubAPI(createApiKeyRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getSubUIDList(BybitApiCallback<Object> callback) {
        this.bybitApiService.getSubUIDList().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void freezeSubMember(UserDataRequest request, BybitApiCallback<Object> callback) {
        FreezeSubUIDRquest freezeSubUIDRquest = this.converter.mapToFreezeSubApiRequest(request);
        this.bybitApiService.freezeSubMember(freezeSubUIDRquest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getCurrentAPIKeyInfo(BybitApiCallback<Object> callback) {
        this.bybitApiService.getCurrentAPIKeyInfo().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getUIDWalletType(UserDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getUIDWalletType(request.getMemberIds() == null ? null : Util.listToString(request.getMemberIds())).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void modifyMasterApiKey(UserDataRequest userDataRequest, BybitApiCallback<Object> callback) {
        ModifyApiKeyRequest modifyMasterApiKeyRequest = this.converter.mapToModifyApiKeyRequest(userDataRequest);
        this.bybitApiService.modifyMasterApiKey(modifyMasterApiKeyRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void modifySubApiKey(UserDataRequest userDataRequest, BybitApiCallback<Object> callback) {
        ModifyApiKeyRequest modifySubApiKeyRequest = this.converter.mapToModifyApiKeyRequest(userDataRequest);
        this.bybitApiService.modifySubApiKey(modifySubApiKeyRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void deleteMasterApiKey(BybitApiCallback<Object> callback) {
        this.bybitApiService.deleteMasterApiKey().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void deleteSubApiKey(UserDataRequest userDataRequest, BybitApiCallback<Object> callback) {
        ModifyApiKeyRequest deleteSubApiKeyRequest = this.converter.mapToDeleteSubApiKeyRequest(userDataRequest);
        this.bybitApiService.deleteSubApiKey(deleteSubApiKeyRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAffiliateUserInfo(UserDataRequest userDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAffiliateUserInfo(userDataRequest.getUid()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

