/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.BybitApiRestClient;
import com.bybit.api.client.BybitApiService;
import com.bybit.api.client.constant.Util;
import com.bybit.api.client.domain.account.AccountDataRequest;
import com.bybit.api.client.domain.account.request.ResetMMPRequest;
import com.bybit.api.client.domain.account.request.SetCollateralCoinRequest;
import com.bybit.api.client.domain.account.request.SetMMPRequest;
import com.bybit.api.client.domain.account.request.SetMarginModeRequest;
import com.bybit.api.client.domain.asset.AssetDataRequest;
import com.bybit.api.client.domain.asset.request.AssetCancelWithdrawRequest;
import com.bybit.api.client.domain.asset.request.AssetInternalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetUniversalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetWithdrawRequest;
import com.bybit.api.client.domain.asset.request.SetAssetDepositAccountRequest;
import com.bybit.api.client.domain.broker.request.BrokerEarningRequest;
import com.bybit.api.client.domain.c2c.ClientLendingFundsRequest;
import com.bybit.api.client.domain.c2c.ClientLendingOrderRecordsRequest;
import com.bybit.api.client.domain.market.MarketDataRequest;
import com.bybit.api.client.domain.position.PositionDataRequest;
import com.bybit.api.client.domain.position.request.ModifyMarginRequest;
import com.bybit.api.client.domain.position.request.SetAutoAddMarginRequest;
import com.bybit.api.client.domain.position.request.SetLeverageRequest;
import com.bybit.api.client.domain.position.request.SetRiskLimitRequest;
import com.bybit.api.client.domain.position.request.SetTpSlModeRequest;
import com.bybit.api.client.domain.position.request.SwitchMarginRequest;
import com.bybit.api.client.domain.position.request.SwitchPositionModeRequest;
import com.bybit.api.client.domain.position.request.TradingStopRequest;
import com.bybit.api.client.domain.preupgrade.PreUpgradeDataRequest;
import com.bybit.api.client.domain.spot.leverageToken.SpotLeverageOrdersRecordRequest;
import com.bybit.api.client.domain.spot.leverageToken.SpotLeverageTokenRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeBorrowOrdersRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeBorrowRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeRePayRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeRepayOrdersRequest;
import com.bybit.api.client.domain.spot.marginTrade.VIPMarginDataRequest;
import com.bybit.api.client.domain.user.UserDataRequest;
import com.bybit.api.client.domain.user.request.CreateApiKeyRequest;
import com.bybit.api.client.domain.user.request.FreezeSubUIDRquest;
import com.bybit.api.client.domain.user.request.ModifyApiKeyRequest;
import com.bybit.api.client.domain.user.request.UserSubMemberRequest;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiRestClientImpl
implements BybitApiRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiRestClientImpl(String apiKey, String secret) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret);
    }

    @Override
    public Object getServerTime() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getServerTime());
    }

    @Override
    public Object getMarketLinesData(MarketDataRequest marketKlineRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getMarketLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()));
    }

    @Override
    public Object getMarketPriceLinesData(MarketDataRequest marketKlineRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getMarketPriceLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()));
    }

    @Override
    public Object getIndexPriceLinesData(MarketDataRequest marketKlineRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getIndexPriceLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()));
    }

    @Override
    public Object getPremiumIndexPriceLinesData(MarketDataRequest marketKlineRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPremiumIndexPriceLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()));
    }

    @Override
    public Object getInstrumentsInfo(MarketDataRequest instrumentInfoRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInstrumentsInfo(instrumentInfoRequest.getCategory().getProductTypeId(), instrumentInfoRequest.getSymbol(), instrumentInfoRequest.getInstrumentStatus() == null ? null : instrumentInfoRequest.getInstrumentStatus().getStatus(), instrumentInfoRequest.getBaseCoin(), instrumentInfoRequest.getLimit(), instrumentInfoRequest.getCursor()));
    }

    @Override
    public Object getMarketOrderBook(MarketDataRequest marketOrderBookRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getMarketOrderBook(marketOrderBookRequest.getCategory().getProductTypeId(), marketOrderBookRequest.getSymbol(), marketOrderBookRequest.getLimit()));
    }

    @Override
    public Object getMarketTickers(MarketDataRequest marketDataTickerRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getMarketTickers(marketDataTickerRequest.getCategory().getProductTypeId(), marketDataTickerRequest.getSymbol(), marketDataTickerRequest.getBaseCoin(), marketDataTickerRequest.getExpDate()));
    }

    @Override
    public Object getFundingHistory(MarketDataRequest fundingHistoryRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getFundingHistory(fundingHistoryRequest.getCategory().getProductTypeId(), fundingHistoryRequest.getSymbol(), fundingHistoryRequest.getStartTime(), fundingHistoryRequest.getEndTime(), fundingHistoryRequest.getLimit()));
    }

    @Override
    public Object getRecentTradeData(MarketDataRequest recentTradeRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getRecentTradeData(recentTradeRequest.getCategory().getProductTypeId(), recentTradeRequest.getBaseCoin(), recentTradeRequest.getOptionType() == null ? null : recentTradeRequest.getOptionType().getOpType(), recentTradeRequest.getSymbol(), recentTradeRequest.getLimit()));
    }

    @Override
    public Object getOpenInterest(MarketDataRequest openInterestRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getOpenInterest(openInterestRequest.getCategory().getProductTypeId(), openInterestRequest.getSymbol(), openInterestRequest.getMarketIntervalTime() == null ? null : openInterestRequest.getMarketIntervalTime().getInterval(), openInterestRequest.getStartTime(), openInterestRequest.getEndTime(), openInterestRequest.getLimit(), openInterestRequest.getCursor()));
    }

    @Override
    public Object getHistoricalVolatility(MarketDataRequest historicalVolatilityRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getHistoricalVolatility(historicalVolatilityRequest.getCategory().getProductTypeId(), historicalVolatilityRequest.getBaseCoin(), historicalVolatilityRequest.getOptionPeriod(), historicalVolatilityRequest.getStartTime(), historicalVolatilityRequest.getEndTime()));
    }

    @Override
    public Object getRiskLimit(MarketDataRequest marketRiskLimitRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getRiskLimit(marketRiskLimitRequest.getCategory().getProductTypeId(), marketRiskLimitRequest.getSymbol()));
    }

    @Override
    public Object getInsurance(String coin) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsurance(coin));
    }

    @Override
    public Object getInsurance() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsurance());
    }

    @Override
    public Object getDeliveryPrice(MarketDataRequest deliveryPriceRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getDeliveryPrice(deliveryPriceRequest.getCategory().getProductTypeId(), deliveryPriceRequest.getSymbol(), deliveryPriceRequest.getBaseCoin(), deliveryPriceRequest.getLimit(), deliveryPriceRequest.getCursor()));
    }

    @Override
    public Object getMarketAccountRatio(MarketDataRequest marketAccountRatioRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getMarketAccountRatio(marketAccountRatioRequest.getCategory().getProductTypeId(), marketAccountRatioRequest.getSymbol(), marketAccountRatioRequest.getDataRecordingPeriod() == null ? null : marketAccountRatioRequest.getDataRecordingPeriod().getPeriod(), marketAccountRatioRequest.getLimit()));
    }

    @Override
    public Object getCurrentAPIKeyInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getCurrentAPIKeyInfo());
    }

    @Override
    public Object getSubUIDList() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSubUIDList());
    }

    @Override
    public Object createSubMember(UserDataRequest request) {
        UserSubMemberRequest subUserRequest = this.converter.mapToCreateSubMemberRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createSubMember(subUserRequest));
    }

    @Override
    public Object createSubAPI(UserDataRequest request) {
        CreateApiKeyRequest createApiKeyRequest = this.converter.mapToCreateSubApiRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createSubAPI(createApiKeyRequest));
    }

    @Override
    public Object freezeSubMember(UserDataRequest request) {
        FreezeSubUIDRquest freezeSubUIDRquest = this.converter.mapToFreezeSubApiRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.freezeSubMember(freezeSubUIDRquest));
    }

    @Override
    public Object getUIDWalletType(UserDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getUIDWalletType(request.getMemberIds() == null ? null : Util.listToString(request.getMemberIds())));
    }

    @Override
    public Object modifyMasterApiKey(UserDataRequest userDataRequest) {
        ModifyApiKeyRequest modifyMasterApiKeyRequest = this.converter.mapToModifyApiKeyRequest(userDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.modifyMasterApiKey(modifyMasterApiKeyRequest));
    }

    @Override
    public Object modifySubApiKey(UserDataRequest userDataRequest) {
        ModifyApiKeyRequest modifySubApiKeyRequest = this.converter.mapToModifyApiKeyRequest(userDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.modifySubApiKey(modifySubApiKeyRequest));
    }

    @Override
    public Object deleteMasterApiKey() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.deleteMasterApiKey());
    }

    @Override
    public Object deleteSubApiKey(UserDataRequest userDataRequest) {
        ModifyApiKeyRequest deleteSubApiKeyRequest = this.converter.mapToDeleteSubApiKeyRequest(userDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.deleteSubApiKey(deleteSubApiKeyRequest));
    }

    @Override
    public Object getAffiliateUserInfo(UserDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAffiliateUserInfo(request.getUid()));
    }

    @Override
    public Object getPositionInfo(PositionDataRequest positionListRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPositionInfo(positionListRequest.getCategory().getProductTypeId(), positionListRequest.getSymbol(), positionListRequest.getBaseCoin(), positionListRequest.getSettleCoin(), positionListRequest.getLimit(), positionListRequest.getCursor()));
    }

    @Override
    public Object setPositionLeverage(PositionDataRequest positionDataRequest) {
        SetLeverageRequest setLeverageRequest = this.converter.mapToSetLeverageRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setPositionLeverage(setLeverageRequest));
    }

    @Override
    public Object swithMarginRequest(PositionDataRequest positionDataRequest) {
        SwitchMarginRequest switchMarginRequest = this.converter.mapToSwitchMarginRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.swithMarginRequest(switchMarginRequest));
    }

    @Override
    public Object switchPositionMode(PositionDataRequest positionDataRequest) {
        SwitchPositionModeRequest switchPositionModeRequest = this.converter.mapToSwitchPositionModeRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.switchPositionMode(switchPositionModeRequest));
    }

    @Override
    public Object setTpslMode(PositionDataRequest positionDataRequest) {
        SetTpSlModeRequest setTpSlModeRequest = this.converter.mapToSetTpSlModeRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setTpslMode(setTpSlModeRequest));
    }

    @Override
    public Object setRiskLimit(PositionDataRequest positionDataRequest) {
        SetRiskLimitRequest setRiskLimitRequest = this.converter.mapToSetRiskLimitRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setRiskLimit(setRiskLimitRequest));
    }

    @Override
    public Object setTradingStop(PositionDataRequest positionDataRequest) {
        TradingStopRequest tradingStopRequest = this.converter.mapToTradingStopRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setTradingStop(tradingStopRequest));
    }

    @Override
    public Object setAutoAddMargin(PositionDataRequest positionDataRequest) {
        SetAutoAddMarginRequest setAutoAddMarginRequest = this.converter.mapToSetAutoAddMarginRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setAutoAddMargin(setAutoAddMarginRequest));
    }

    @Override
    public Object modifyPositionMargin(PositionDataRequest positionDataRequest) {
        ModifyMarginRequest modifyMarginRequest = this.converter.mapToModifyMarginRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.modifyPositionMargin(modifyMarginRequest));
    }

    @Override
    public Object getExecutionList(PositionDataRequest executionHistoryRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getExecutionList(executionHistoryRequest.getCategory().getProductTypeId(), executionHistoryRequest.getSymbol(), executionHistoryRequest.getOrderId(), executionHistoryRequest.getOrderLinkId(), executionHistoryRequest.getBaseCoin(), executionHistoryRequest.getStartTime(), executionHistoryRequest.getEndTime(), executionHistoryRequest.getExecType() == null ? null : executionHistoryRequest.getExecType().getExecTypeId(), executionHistoryRequest.getLimit(), executionHistoryRequest.getCursor()));
    }

    @Override
    public Object getClosePnlList(PositionDataRequest closePnlHistoryRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getClosePnlList(closePnlHistoryRequest.getCategory().getProductTypeId(), closePnlHistoryRequest.getSymbol(), closePnlHistoryRequest.getStartTime(), closePnlHistoryRequest.getEndTime(), closePnlHistoryRequest.getLimit(), closePnlHistoryRequest.getCursor()));
    }

    @Override
    public Object getPreUpgradeClosePnl(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeClosePnl(request.getCategory().getProductTypeId(), request.getSymbol(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeOrderHistory(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeOrderHistory(request.getCategory().getProductTypeId(), request.getSymbol(), request.getBaseCoin(), request.getOrderId(), request.getOrderLinkId(), request.getOrderFilter(), request.getOrderStatus() == null ? null : request.getOrderStatus().getDescription(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeTradeHistory(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeTradeHistory(request.getCategory().getProductTypeId(), request.getSymbol(), request.getOrderId(), request.getOrderLinkId(), request.getBaseCoin(), request.getStartTime(), request.getEndTime(), request.getExecType() == null ? null : request.getExecType().getExecTypeId(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeTransaction(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeTransaction(request.getCategory().getProductTypeId(), request.getBaseCoin(), request.getTransactionType() == null ? null : request.getTransactionType().getTransactionTypeId(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeOptionDelivery(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeOptionDelivery(request.getCategory().getProductTypeId(), request.getSymbol(), request.getExpDate(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeUsdcSettlement(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeUsdcSettlement(request.getCategory().getProductTypeId(), request.getSymbol(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getWalletBalance(AccountDataRequest walletBalanceRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getWalletBalance(walletBalanceRequest.getAccountType().getAccountTypeValue(), walletBalanceRequest.getCoins()));
    }

    @Override
    public Object upgradeAccountToUTA() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.upgradeAccountToUTA());
    }

    @Override
    public Object getAccountBorrowHistory(AccountDataRequest borrowHistoryRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountBorrowHistory(borrowHistoryRequest.getCurrency(), borrowHistoryRequest.getStartTime(), borrowHistoryRequest.getEndTime(), borrowHistoryRequest.getLimit(), borrowHistoryRequest.getCursor()));
    }

    @Override
    public Object setAccountCollateralCoin(AccountDataRequest setCollateralCoinRequest) {
        SetCollateralCoinRequest request = this.converter.mapToSetCollateralCoinRequest(setCollateralCoinRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setAccountCollateralCoin(request));
    }

    @Override
    public Object getAccountCollateralInfo(AccountDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountCollateralInfo(request.getCurrency()));
    }

    @Override
    public Object getAccountCoinGeeks(AccountDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountCoinGeeks(request.getBaseCoin()));
    }

    @Override
    public Object getAccountFreeRate(AccountDataRequest getFeeRateRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountFreeRate(getFeeRateRequest.getCategory().getProductTypeId(), getFeeRateRequest.getSymbol(), getFeeRateRequest.getBaseCoin()));
    }

    @Override
    public Object getAccountInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountInfo());
    }

    @Override
    public Object getTransactionLog(AccountDataRequest getTransactionLogRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getTransactionLog(getTransactionLogRequest.getAccountType() == null ? null : getTransactionLogRequest.getAccountType().getAccountTypeValue(), getTransactionLogRequest.getCategory() == null ? null : getTransactionLogRequest.getCategory().getProductTypeId(), getTransactionLogRequest.getCurrency(), getTransactionLogRequest.getBaseCoin(), getTransactionLogRequest.getTransactionType() == null ? null : getTransactionLogRequest.getTransactionType().getTransactionTypeId(), getTransactionLogRequest.getStartTime(), getTransactionLogRequest.getEndTime(), getTransactionLogRequest.getLimit(), getTransactionLogRequest.getCursor()));
    }

    @Override
    public Object setAccountMarginMode(AccountDataRequest setMarginMode) {
        SetMarginModeRequest request = this.converter.mapToSetMarginModeRequest(setMarginMode);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setAccountMarginMode(request));
    }

    @Override
    public Object modifyAccountMMP(AccountDataRequest setMMPRequest) {
        SetMMPRequest request = this.converter.mapToSetMMPRequest(setMMPRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.modifyAccountMMP(request));
    }

    @Override
    public Object resetAccountMMP(AccountDataRequest request) {
        ResetMMPRequest resetMMPRequest = this.converter.mapToResetMarginModeRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.resetAccountMMP(resetMMPRequest));
    }

    @Override
    public Object getAccountMMPState(AccountDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountMMPState(request.getBaseCoin()));
    }

    @Override
    public Object getSpotLeverageTokenInfo(String ltCoin) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSpotLeverageTokenInfo(ltCoin));
    }

    @Override
    public Object getSpotLeverageTokenInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSpotLeverageTokenInfo());
    }

    @Override
    public Object getSpotLeverageTokenMarket(String ltCoin) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSpotLeverageTokenMarket(ltCoin));
    }

    @Override
    public Object getSpotLeverageTokenMarket() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSpotLeverageTokenMarket());
    }

    @Override
    public Object purchaseSpotLeverageToken(SpotLeverageTokenRequest spotLeverageTokenRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.purchaseSpotLeverageToken(spotLeverageTokenRequest));
    }

    @Override
    public Object redeemSpotLeverageToken(SpotLeverageTokenRequest spotLeverageTokenRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.redeemSpotLeverageToken(spotLeverageTokenRequest));
    }

    @Override
    public Object getSpotLeverageRecords(SpotLeverageOrdersRecordRequest spotLeverageOrdersRecordRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSpotLeverageRecords(spotLeverageOrdersRecordRequest.getLtCoin(), spotLeverageOrdersRecordRequest.getOrderId(), spotLeverageOrdersRecordRequest.getStartTime(), spotLeverageOrdersRecordRequest.getEndTime(), spotLeverageOrdersRecordRequest.getLimit(), spotLeverageOrdersRecordRequest.getLtOrderType(), spotLeverageOrdersRecordRequest.getSerialNo()));
    }

    @Override
    public Object getUtaVipSpotMarginTradeData(VIPMarginDataRequest utaMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getUtaVipSpotMarginTradeData(utaMarginDataRequest.getVipLevel() == null ? null : utaMarginDataRequest.getVipLevel().getLevel(), utaMarginDataRequest.getCurrency()));
    }

    @Override
    public Object setUTASpotMarginTrade(String spotMarginMode) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setUTASpotMarginTrade(spotMarginMode));
    }

    @Override
    public Object setUTASpotMarginTradeLeverage(String leverage) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setUTASpotMarginTradeLeverage(leverage));
    }

    @Override
    public Object getUTASpotMarginTradeLeverageState() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getUTASpotMarginTradeLeverageState());
    }

    @Override
    public Object getNormalVipSpotMarginTradeData(VIPMarginDataRequest normalMarginDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalVipSpotMarginTradeData(normalMarginDataRequest.getVipLevel() == null ? null : normalMarginDataRequest.getVipLevel().getLevel(), normalMarginDataRequest.getCurrency()));
    }

    @Override
    public Object getNormalSpotMarginTradeCoinInfo(String coin) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeCoinInfo(coin));
    }

    @Override
    public Object getNormalSpotMarginTradeCoinInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeCoinInfo());
    }

    @Override
    public Object getNormalSpotMarginTradeBorrowCoinInfo(String coin) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeBorrowCoinInfo(coin));
    }

    @Override
    public Object getNormalSpotMarginTradeBorrowCoinInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeBorrowCoinInfo());
    }

    @Override
    public Object getNormalSpotMarginTradeInterestQuota(String coin) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeInterestQuota(coin));
    }

    @Override
    public Object getNormalSpotMarginTradeAccountInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotMarginTradeAccountInfo());
    }

    @Override
    public Object getNormalSpotToggleMarginTrade(int switchStatus) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalSpotToggleMarginTrade(switchStatus));
    }

    @Override
    public Object loanNormalSpotMarginTrade(SpotMarginTradeBorrowRequest spotMarginTradeBorrowRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.loanNormalSpotMarginTrade(spotMarginTradeBorrowRequest));
    }

    @Override
    public Object repayNormalSpotMarginTrade(SpotMarginTradeRePayRequest spotMarginTradeRePayRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.repayNormalSpotMarginTrade(spotMarginTradeRePayRequest));
    }

    @Override
    public Object getNormalSpotMarginTradeBorrowOrders(SpotMarginTradeBorrowOrdersRequest spotMarginTradeBorrowOrdersRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalMarginTradeBorrowOrders(spotMarginTradeBorrowOrdersRequest.getStartTime(), spotMarginTradeBorrowOrdersRequest.getEndTime(), spotMarginTradeBorrowOrdersRequest.getCoin(), spotMarginTradeBorrowOrdersRequest.getStatus(), spotMarginTradeBorrowOrdersRequest.getLimit()));
    }

    @Override
    public Object getNormalSpotMarginTradeRepayOrders(SpotMarginTradeRepayOrdersRequest spotMarginTradeRepayOrdersRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getNormalMarginTradeRepayOrders(spotMarginTradeRepayOrdersRequest.getStartTime(), spotMarginTradeRepayOrdersRequest.getEndTime(), spotMarginTradeRepayOrdersRequest.getCoin(), spotMarginTradeRepayOrdersRequest.getLimit()));
    }

    @Override
    public Object getBrokerEarningData(BrokerEarningRequest brokerEarningRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getBrokerEarningData(brokerEarningRequest.getBizType() == null ? null : brokerEarningRequest.getBizType().getType(), brokerEarningRequest.getStartTime(), brokerEarningRequest.getEndTime(), brokerEarningRequest.getLimit(), brokerEarningRequest.getCursor()));
    }

    @Override
    public Object getC2CLendingCoinInfo(String coin) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getC2CLendingCoinInfo(coin));
    }

    @Override
    public Object getC2CLendingCoinInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getC2CLendingCoinInfo());
    }

    @Override
    public Object C2cLendingDepositFunds(ClientLendingFundsRequest depsoitFundRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.C2cLendingDepositFunds(depsoitFundRequest));
    }

    @Override
    public Object C2cLendingRedeemFunds(ClientLendingFundsRequest depsoitFundRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.C2cLendingRedeemFunds(depsoitFundRequest));
    }

    @Override
    public Object getC2cOrdersRecords(ClientLendingOrderRecordsRequest c2cOrdersRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getC2cOrdersRecords(c2cOrdersRecordsRequest.getCoin(), c2cOrdersRecordsRequest.getOrderId(), c2cOrdersRecordsRequest.getStartTime(), c2cOrdersRecordsRequest.getEndTime(), c2cOrdersRecordsRequest.getLimit(), c2cOrdersRecordsRequest.getOrderType()));
    }

    @Override
    public Object getC2CLendingAccountInfo(String coin) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getC2CLendingAccountInfo(coin));
    }

    @Override
    public Object getAssetCoinExchangeRecords(AssetDataRequest coinExchangeRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetCoinExchangeRecords(coinExchangeRecordsRequest.getFromCoin(), coinExchangeRecordsRequest.getToCoin(), coinExchangeRecordsRequest.getLimit(), coinExchangeRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetDeliveryRecords(AssetDataRequest deliveryRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetDeliveryRecords(deliveryRecordsRequest.getCategory() == null ? null : deliveryRecordsRequest.getCategory().getProductTypeId(), deliveryRecordsRequest.getSymbol(), deliveryRecordsRequest.getExpDate(), deliveryRecordsRequest.getLimit(), deliveryRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetUSDCSettlementRecords(AssetDataRequest usdcSettlementRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetUSDCSettlementRecords(usdcSettlementRequest.getCategory() == null ? null : usdcSettlementRequest.getCategory().getProductTypeId(), usdcSettlementRequest.getSymbol(), usdcSettlementRequest.getLimit(), usdcSettlementRequest.getCursor()));
    }

    @Override
    public Object getAssetInfo(AssetDataRequest assetInfoRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetInfo(assetInfoRequest.getAccountType() == null ? null : assetInfoRequest.getAccountType().getAccountTypeValue(), assetInfoRequest.getCoin()));
    }

    @Override
    public Object getAssetAllCoinsBalance(AssetDataRequest allCoinsBalanceRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetAllCoinsBalance(allCoinsBalanceRequest.getAccountType() == null ? null : allCoinsBalanceRequest.getAccountType().getAccountTypeValue(), allCoinsBalanceRequest.getMemberId(), allCoinsBalanceRequest.getCoin(), allCoinsBalanceRequest.getWithBonus() == null ? null : String.valueOf(allCoinsBalanceRequest.getWithBonus().getValue())));
    }

    @Override
    public Object getAssetTransferableCoins(AssetDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetTransferableCoins(request.getFromAccountType() == null ? null : request.getFromAccountType().getAccountTypeValue(), request.getToAccountType() == null ? null : request.getToAccountType().getAccountTypeValue()));
    }

    @Override
    public Object getAssetSingleCoinBalance(AssetDataRequest singleCoinBalanceRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetSingleCoinBalance(singleCoinBalanceRequest.getAccountType() == null ? null : singleCoinBalanceRequest.getAccountType().getAccountTypeValue(), singleCoinBalanceRequest.getToAccountType() == null ? null : singleCoinBalanceRequest.getToAccountType().getAccountTypeValue(), singleCoinBalanceRequest.getMemberId(), singleCoinBalanceRequest.getToMemberId() == null ? null : singleCoinBalanceRequest.getToMemberId().toString(), singleCoinBalanceRequest.getCoin(), singleCoinBalanceRequest.getWithBonus() == null ? null : Integer.valueOf(singleCoinBalanceRequest.getWithBonus().getValue()), singleCoinBalanceRequest.getWithTransferSafeAmount() == null ? null : Integer.valueOf(singleCoinBalanceRequest.getWithTransferSafeAmount().getValue()), singleCoinBalanceRequest.getWithLtvTransferSafeAmount() == null ? null : Integer.valueOf(singleCoinBalanceRequest.getWithLtvTransferSafeAmount().getValue())));
    }

    @Override
    public Object createAssetInternalTransfer(AssetDataRequest assetInternalTransferRequest) {
        AssetInternalTransferRequest request = this.converter.mapToAssetInternalTransferRequest(assetInternalTransferRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createAssetInternalTransfer(request));
    }

    @Override
    public Object getAssetTransferSubUidList() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetTransferSubUidList());
    }

    @Override
    public Object createAssetUniversalTransfer(AssetDataRequest assetUniversalTransferRequest) {
        AssetUniversalTransferRequest request = this.converter.mapToAssetUniversalTransferRequest(assetUniversalTransferRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createAssetUniversalTransfer(request));
    }

    @Override
    public Object getAssetInternalTransferRecords(AssetDataRequest internalTransferRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetInternalTransferRecords(internalTransferRequest.getTransferId(), internalTransferRequest.getCoin(), internalTransferRequest.getTransferStatus() == null ? null : internalTransferRequest.getTransferStatus().getStatus(), internalTransferRequest.getStartTime(), internalTransferRequest.getEndTime(), internalTransferRequest.getLimit(), internalTransferRequest.getCursor()));
    }

    @Override
    public Object getAssetUniversalTransferRecords(AssetDataRequest universalTransferRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetUniversalTransferRecords(universalTransferRequest.getTransferId(), universalTransferRequest.getCoin(), universalTransferRequest.getTransferStatus() == null ? null : universalTransferRequest.getTransferStatus().getStatus(), universalTransferRequest.getStartTime(), universalTransferRequest.getEndTime(), universalTransferRequest.getLimit(), universalTransferRequest.getCursor()));
    }

    @Override
    public Object getAssetAllowedDepositCoinInfo(AssetDataRequest allowedDepositCoinRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetAllowedDepositCoinInfo(allowedDepositCoinRequest.getCoin(), allowedDepositCoinRequest.getChain(), allowedDepositCoinRequest.getLimit(), allowedDepositCoinRequest.getCursor()));
    }

    @Override
    public Object setAssetDepositAccount(AssetDataRequest request) {
        SetAssetDepositAccountRequest setAssetDepositAccountRequest = this.converter.mapToSetDepositAccountRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setAssetDepositAccount(setAssetDepositAccountRequest));
    }

    @Override
    public Object getAssetDepositRecords(AssetDataRequest assetDepositRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetSubMembersDepositRecords(AssetDataRequest assetDepositRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetSubMembersDepositRecords(assetDepositRecordsRequest.getSubMemberId(), assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetInternalDepositRecords(AssetDataRequest assetDepositRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetInternalDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()));
    }

    @Override
    public Object getAssetMasterDepositAddress(AssetDataRequest masterDepositRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetMasterDepositAddress(masterDepositRequest.getCoin(), masterDepositRequest.getChainType()));
    }

    @Override
    public Object getAssetSubMemberDepositAddress(AssetDataRequest subDepositRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetSubMemberDepositAddress(subDepositRequest.getCoin(), subDepositRequest.getChainType(), subDepositRequest.getSubMemberId()));
    }

    @Override
    public Object getAssetCoinInfo(AssetDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetCoinInfo(request.getCoin()));
    }

    @Override
    public Object getAssetWithdrawalAmount(AssetDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetWithdrawalAmount(request.getCoin()));
    }

    @Override
    public Object getAssetWithdrawalRecords(AssetDataRequest assetWithdrawRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAssetWithdrawalRecords(assetWithdrawRecordsRequest.getWithdrawID(), assetWithdrawRecordsRequest.getCoin(), assetWithdrawRecordsRequest.getWithdrawType() == null ? null : Integer.valueOf(assetWithdrawRecordsRequest.getWithdrawType().getValue()), assetWithdrawRecordsRequest.getStartTime(), assetWithdrawRecordsRequest.getEndTime(), assetWithdrawRecordsRequest.getLimit(), assetWithdrawRecordsRequest.getCursor()));
    }

    @Override
    public Object cancelAssetWithdraw(AssetDataRequest request) {
        AssetCancelWithdrawRequest assetCancelWithdrawRequest = this.converter.mapToAssetCancelWithdrawRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelAssetWithdraw(assetCancelWithdrawRequest));
    }

    @Override
    public Object createAssetWithdraw(AssetDataRequest assetWithdrawRequest) {
        AssetWithdrawRequest request = this.converter.mapToAssetWithdrawRequest(assetWithdrawRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createAssetWithdraw(request));
    }
}

