/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.BybitApiAsyncAssetRestClient;
import com.bybit.api.client.BybitApiCallback;
import com.bybit.api.client.BybitApiService;
import com.bybit.api.client.domain.asset.AssetDataRequest;
import com.bybit.api.client.domain.asset.request.AssetCancelWithdrawRequest;
import com.bybit.api.client.domain.asset.request.AssetInternalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetUniversalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetWithdrawRequest;
import com.bybit.api.client.domain.asset.request.SetAssetDepositAccountRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAsyncAssetRestClientImpl
implements BybitApiAsyncAssetRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAsyncAssetRestClientImpl(String apiKey, String secret) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret);
    }

    @Override
    public void getAssetCoinExchangeRecords(AssetDataRequest coinExchangeRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetCoinExchangeRecords(coinExchangeRecordsRequest.getFromCoin(), coinExchangeRecordsRequest.getToCoin(), coinExchangeRecordsRequest.getLimit(), coinExchangeRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetDeliveryRecords(AssetDataRequest deliveryRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetDeliveryRecords(deliveryRecordsRequest.getCategory() == null ? null : deliveryRecordsRequest.getCategory().getProductTypeId(), deliveryRecordsRequest.getSymbol(), deliveryRecordsRequest.getExpDate(), deliveryRecordsRequest.getLimit(), deliveryRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetUSDCSettlementRecords(AssetDataRequest usdcSettlementRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetUSDCSettlementRecords(usdcSettlementRequest.getCategory() == null ? null : usdcSettlementRequest.getCategory().getProductTypeId(), usdcSettlementRequest.getSymbol(), usdcSettlementRequest.getLimit(), usdcSettlementRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetInfo(AssetDataRequest assetInfoRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetInfo(assetInfoRequest.getAccountType() == null ? null : assetInfoRequest.getAccountType().getAccountTypeValue(), assetInfoRequest.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetAllCoinsBalance(AssetDataRequest allCoinsBalanceRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetAllCoinsBalance(allCoinsBalanceRequest.getAccountType() == null ? null : allCoinsBalanceRequest.getAccountType().getAccountTypeValue(), allCoinsBalanceRequest.getMemberId(), allCoinsBalanceRequest.getCoin(), allCoinsBalanceRequest.getWithBonus() == null ? null : String.valueOf(allCoinsBalanceRequest.getWithBonus().getValue())).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetTransferableCoins(AssetDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetTransferableCoins(request.getFromAccountType() == null ? null : request.getFromAccountType().getAccountTypeValue(), request.getToAccountType() == null ? null : request.getToAccountType().getAccountTypeValue()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetSingleCoinBalance(AssetDataRequest singleCoinBalanceRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetSingleCoinBalance(singleCoinBalanceRequest.getAccountType() == null ? null : singleCoinBalanceRequest.getAccountType().getAccountTypeValue(), singleCoinBalanceRequest.getToAccountType() == null ? null : singleCoinBalanceRequest.getToAccountType().getAccountTypeValue(), singleCoinBalanceRequest.getMemberId(), singleCoinBalanceRequest.getToMemberId() == null ? null : singleCoinBalanceRequest.getToMemberId().toString(), singleCoinBalanceRequest.getCoin(), singleCoinBalanceRequest.getWithBonus() == null ? null : Integer.valueOf(singleCoinBalanceRequest.getWithBonus().getValue()), singleCoinBalanceRequest.getWithTransferSafeAmount() == null ? null : Integer.valueOf(singleCoinBalanceRequest.getWithTransferSafeAmount().getValue()), singleCoinBalanceRequest.getWithLtvTransferSafeAmount() == null ? null : Integer.valueOf(singleCoinBalanceRequest.getWithLtvTransferSafeAmount().getValue())).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createAssetInternalTransfer(AssetDataRequest assetInternalTransferRequest, BybitApiCallback<Object> callback) {
        AssetInternalTransferRequest request = this.converter.mapToAssetInternalTransferRequest(assetInternalTransferRequest);
        this.bybitApiService.createAssetInternalTransfer(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetTransferSubUidList(BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetTransferSubUidList().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createAssetUniversalTransfer(AssetDataRequest assetUniversalTransferRequest, BybitApiCallback<Object> callback) {
        AssetUniversalTransferRequest request = this.converter.mapToAssetUniversalTransferRequest(assetUniversalTransferRequest);
        this.bybitApiService.createAssetUniversalTransfer(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetInternalTransferRecords(AssetDataRequest internalTransferRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetInternalTransferRecords(internalTransferRequest.getTransferId(), internalTransferRequest.getCoin(), internalTransferRequest.getTransferStatus() == null ? null : internalTransferRequest.getTransferStatus().getStatus(), internalTransferRequest.getStartTime(), internalTransferRequest.getEndTime(), internalTransferRequest.getLimit(), internalTransferRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetUniversalTransferRecords(AssetDataRequest universalTransferRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetUniversalTransferRecords(universalTransferRequest.getTransferId(), universalTransferRequest.getCoin(), universalTransferRequest.getTransferStatus() == null ? null : universalTransferRequest.getTransferStatus().getStatus(), universalTransferRequest.getStartTime(), universalTransferRequest.getEndTime(), universalTransferRequest.getLimit(), universalTransferRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetAllowedDepositCoinInfo(AssetDataRequest allowedDepositCoinRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetAllowedDepositCoinInfo(allowedDepositCoinRequest.getCoin(), allowedDepositCoinRequest.getChain(), allowedDepositCoinRequest.getLimit(), allowedDepositCoinRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setAssetDepositAccount(AssetDataRequest request, BybitApiCallback<Object> callback) {
        SetAssetDepositAccountRequest setAssetDepositAccountRequest = this.converter.mapToSetDepositAccountRequest(request);
        this.bybitApiService.setAssetDepositAccount(setAssetDepositAccountRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetDepositRecords(AssetDataRequest assetDepositRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetSubMembersDepositRecords(AssetDataRequest assetDepositRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetSubMembersDepositRecords(assetDepositRecordsRequest.getSubMemberId(), assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetInternalDepositRecords(AssetDataRequest assetDepositRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetInternalDepositRecords(assetDepositRecordsRequest.getCoin(), assetDepositRecordsRequest.getStartTime(), assetDepositRecordsRequest.getEndTime(), assetDepositRecordsRequest.getLimit(), assetDepositRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetMasterDepositAddress(AssetDataRequest masterDepositRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetMasterDepositAddress(masterDepositRequest.getCoin(), masterDepositRequest.getChainType()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetSubMemberDepositAddress(AssetDataRequest subDepositRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetSubMemberDepositAddress(subDepositRequest.getCoin(), subDepositRequest.getChainType(), subDepositRequest.getSubMemberId()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetCoinInfo(AssetDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetCoinInfo(request.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetWithdrawalAmount(AssetDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetWithdrawalAmount(request.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAssetWithdrawalRecords(AssetDataRequest assetWithdrawRecordsRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAssetWithdrawalRecords(assetWithdrawRecordsRequest.getWithdrawID(), assetWithdrawRecordsRequest.getCoin(), assetWithdrawRecordsRequest.getWithdrawType() == null ? null : Integer.valueOf(assetWithdrawRecordsRequest.getWithdrawType().getValue()), assetWithdrawRecordsRequest.getStartTime(), assetWithdrawRecordsRequest.getEndTime(), assetWithdrawRecordsRequest.getLimit(), assetWithdrawRecordsRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelAssetWithdraw(AssetDataRequest request, BybitApiCallback<Object> callback) {
        AssetCancelWithdrawRequest assetCancelWithdrawRequest = this.converter.mapToAssetCancelWithdrawRequest(request);
        this.bybitApiService.cancelAssetWithdraw(assetCancelWithdrawRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createAssetWithdraw(AssetDataRequest assetWithdrawRequest, BybitApiCallback<Object> callback) {
        AssetWithdrawRequest request = this.converter.mapToAssetWithdrawRequest(assetWithdrawRequest);
        this.bybitApiService.createAssetWithdraw(request).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

