/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.BybitApiAsyncUserRestClient;
import com.bybit.api.client.BybitApiCallback;
import com.bybit.api.client.BybitApiService;
import com.bybit.api.client.constant.Util;
import com.bybit.api.client.domain.preupgrade.PreUpgradeDataRequest;
import com.bybit.api.client.domain.user.UserDataRequest;
import com.bybit.api.client.domain.user.request.CreateApiKeyRequest;
import com.bybit.api.client.domain.user.request.FreezeSubUIDRquest;
import com.bybit.api.client.domain.user.request.ModifyApiKeyRequest;
import com.bybit.api.client.domain.user.request.UserSubMemberRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAsyncUserRestClientImpl
implements BybitApiAsyncUserRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAsyncUserRestClientImpl(String apiKey, String secret) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret);
    }

    @Override
    public void getPreUpgradeOrderHistory(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeOrderHistory(request.getCategory().getProductTypeId(), request.getSymbol(), request.getBaseCoin(), request.getOrderId(), request.getOrderLinkId(), request.getOrderFilter(), request.getOrderStatus() == null ? null : request.getOrderStatus().getDescription(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeTradeHistory(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeTradeHistory(request.getCategory().getProductTypeId(), request.getSymbol(), request.getOrderId(), request.getOrderLinkId(), request.getBaseCoin(), request.getStartTime(), request.getEndTime(), request.getExecType() == null ? null : request.getExecType().getExecTypeId(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeClosePnl(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeClosePnl(request.getCategory().getProductTypeId(), request.getSymbol(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeTransaction(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeTransaction(request.getCategory().getProductTypeId(), request.getBaseCoin(), request.getTransactionType() == null ? null : request.getTransactionType().getTransactionTypeId(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeOptionDelivery(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeOptionDelivery(request.getCategory().getProductTypeId(), request.getSymbol(), request.getExpDate(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPreUpgradeUsdcSettlement(PreUpgradeDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPreUpgradeUsdcSettlement(request.getCategory().getProductTypeId(), request.getSymbol(), request.getLimit(), request.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createSubMember(UserDataRequest request, BybitApiCallback<Object> callback) {
        UserSubMemberRequest subUserRequest = this.converter.mapToCreateSubMemberRequest(request);
        this.bybitApiService.createSubMember(subUserRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createSubAPI(UserDataRequest request, BybitApiCallback<Object> callback) {
        CreateApiKeyRequest createApiKeyRequest = this.converter.mapToCreateSubApiRequest(request);
        this.bybitApiService.createSubAPI(createApiKeyRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getSubUIDList(BybitApiCallback<Object> callback) {
        this.bybitApiService.getSubUIDList().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void freezeSubMember(UserDataRequest request, BybitApiCallback<Object> callback) {
        FreezeSubUIDRquest freezeSubUIDRquest = this.converter.mapToFreezeSubApiRequest(request);
        this.bybitApiService.freezeSubMember(freezeSubUIDRquest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getCurrentAPIKeyInfo(BybitApiCallback<Object> callback) {
        this.bybitApiService.getCurrentAPIKeyInfo().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getUIDWalletType(UserDataRequest request, BybitApiCallback<Object> callback) {
        this.bybitApiService.getUIDWalletType(request.getMemberIds() == null ? null : Util.listToString(request.getMemberIds())).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void modifyMasterApiKey(UserDataRequest userDataRequest, BybitApiCallback<Object> callback) {
        ModifyApiKeyRequest modifyMasterApiKeyRequest = this.converter.mapToModifyApiKeyRequest(userDataRequest);
        this.bybitApiService.modifyMasterApiKey(modifyMasterApiKeyRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void modifySubApiKey(UserDataRequest userDataRequest, BybitApiCallback<Object> callback) {
        ModifyApiKeyRequest modifySubApiKeyRequest = this.converter.mapToModifyApiKeyRequest(userDataRequest);
        this.bybitApiService.modifySubApiKey(modifySubApiKeyRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void deleteMasterApiKey(BybitApiCallback<Object> callback) {
        this.bybitApiService.deleteMasterApiKey().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void deleteSubApiKey(UserDataRequest userDataRequest, BybitApiCallback<Object> callback) {
        ModifyApiKeyRequest deleteSubApiKeyRequest = this.converter.mapToDeleteSubApiKeyRequest(userDataRequest);
        this.bybitApiService.deleteSubApiKey(deleteSubApiKeyRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAffiliateUserInfo(UserDataRequest userDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAffiliateUserInfo(userDataRequest.getUid()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

