/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.BybitApiLendingRestClient;
import com.bybit.api.client.BybitApiService;
import com.bybit.api.client.domain.institution.LendingDataRequest;
import com.bybit.api.client.domain.institution.clientLending.ClientLendingFundsRequest;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiLendingRestClientImpl
implements BybitApiLendingRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiLendingRestClientImpl(String apiKey, String secret) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret);
    }

    @Override
    public Object getInsProductInfo(LendingDataRequest lendingDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsProductInfo(lendingDataRequest.getProductId()));
    }

    @Override
    public Object getInsMarginCoinInfo(LendingDataRequest lendingDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsMarginCoinInfo(lendingDataRequest.getProductId()));
    }

    @Override
    public Object getInsLoanOrders(LendingDataRequest institutionLoanOrdersRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsLoanOrders(institutionLoanOrdersRequest.getOrderId(), institutionLoanOrdersRequest.getStartTime(), institutionLoanOrdersRequest.getEndTime(), institutionLoanOrdersRequest.getLimit()));
    }

    @Override
    public Object getInsRepayOrders(LendingDataRequest institutionRepayOrdersRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsRepayOrders(institutionRepayOrdersRequest.getStartTime(), institutionRepayOrdersRequest.getEndTime(), institutionRepayOrdersRequest.getLimit()));
    }

    @Override
    public Object getInsLoanToValue() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getInsLoanToValue());
    }

    @Override
    public Object getC2CLendingCoinInfo(LendingDataRequest lendingDataRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getC2CLendingCoinInfo(lendingDataRequest.getCoin()));
    }

    @Override
    public Object C2cLendingDepositFunds(LendingDataRequest lendingDataRequest) {
        ClientLendingFundsRequest depsoitFundRequest = this.converter.mapToC2CLendingFundRequest(lendingDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.C2cLendingDepositFunds(depsoitFundRequest));
    }

    @Override
    public Object C2cLendingRedeemFunds(LendingDataRequest lendingDataRequest) {
        ClientLendingFundsRequest redeemFundRequest = this.converter.mapToC2CLendingFundRequest(lendingDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.C2cLendingRedeemFunds(redeemFundRequest));
    }

    @Override
    public Object C2cLendingRedeemCancel(LendingDataRequest lendingDataRequest) {
        ClientLendingFundsRequest redeemFundCancelRequest = this.converter.mapToC2CLendingFundRequest(lendingDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.C2cLendingRedeemFunds(redeemFundCancelRequest));
    }

    @Override
    public Object getC2cOrdersRecords(LendingDataRequest c2cOrdersRecordsRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getC2cOrdersRecords(c2cOrdersRecordsRequest.getCoin(), c2cOrdersRecordsRequest.getOrderId(), c2cOrdersRecordsRequest.getStartTime(), c2cOrdersRecordsRequest.getEndTime(), c2cOrdersRecordsRequest.getLimit(), c2cOrdersRecordsRequest.getLendingOrderType() == null ? null : c2cOrdersRecordsRequest.getLendingOrderType().getType()));
    }

    @Override
    public Object getC2CLendingAccountInfo(LendingDataRequest lendingDataRequest) {
        String coin = lendingDataRequest.getCoin();
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getC2CLendingAccountInfo(coin));
    }
}

