/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.BybitApiAsyncMarketDataRestClient;
import com.bybit.api.client.BybitApiCallback;
import com.bybit.api.client.BybitApiService;
import com.bybit.api.client.domain.announcement.request.AnnouncementInfoRequest;
import com.bybit.api.client.domain.market.MarketDataRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiMarketAsyncRestClientImpl
implements BybitApiAsyncMarketDataRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiMarketAsyncRestClientImpl() {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class);
    }

    @Override
    public void getServerTime(BybitApiCallback<Object> callback) {
        this.bybitApiService.getServerTime().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketPriceLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketPriceLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getIndexPriceLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getIndexPriceLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPremiumIndexPriceLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPremiumIndexPriceLinesData(marketKlineRequest.getCategory().getProductTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInstrumentsInfo(MarketDataRequest instrumentInfoRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInstrumentsInfo(instrumentInfoRequest.getCategory().getProductTypeId(), instrumentInfoRequest.getSymbol(), instrumentInfoRequest.getInstrumentStatus() == null ? null : instrumentInfoRequest.getInstrumentStatus().getStatus(), instrumentInfoRequest.getBaseCoin(), instrumentInfoRequest.getLimit(), instrumentInfoRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketOrderBook(MarketDataRequest marketOrderBookRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketOrderBook(marketOrderBookRequest.getCategory().getProductTypeId(), marketOrderBookRequest.getSymbol(), marketOrderBookRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketTickers(MarketDataRequest marketDataTickerRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketTickers(marketDataTickerRequest.getCategory().getProductTypeId(), marketDataTickerRequest.getSymbol(), marketDataTickerRequest.getBaseCoin(), marketDataTickerRequest.getExpDate()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getFundingHistory(MarketDataRequest fundingHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getFundingHistory(fundingHistoryRequest.getCategory().getProductTypeId(), fundingHistoryRequest.getSymbol(), fundingHistoryRequest.getStartTime(), fundingHistoryRequest.getEndTime(), fundingHistoryRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getRecentTradeData(MarketDataRequest recentTradeRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getRecentTradeData(recentTradeRequest.getCategory().getProductTypeId(), recentTradeRequest.getBaseCoin(), recentTradeRequest.getOptionType() == null ? null : recentTradeRequest.getOptionType().getOpType(), recentTradeRequest.getSymbol(), recentTradeRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getOpenInterest(MarketDataRequest openInterestRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getOpenInterest(openInterestRequest.getCategory().getProductTypeId(), openInterestRequest.getSymbol(), openInterestRequest.getMarketInterval() == null ? null : openInterestRequest.getMarketInterval().getIntervalId(), openInterestRequest.getStartTime(), openInterestRequest.getEndTime(), openInterestRequest.getLimit(), openInterestRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getHistoricalVolatility(MarketDataRequest historicalVolatilityRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getHistoricalVolatility(historicalVolatilityRequest.getCategory().getProductTypeId(), historicalVolatilityRequest.getBaseCoin(), historicalVolatilityRequest.getOptionPeriod(), historicalVolatilityRequest.getStartTime(), historicalVolatilityRequest.getEndTime()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsurance(String coin, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsurance(coin).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsurance(BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsurance().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getRiskLimit(MarketDataRequest marketRiskLimitRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getRiskLimit(marketRiskLimitRequest.getCategory().getProductTypeId(), marketRiskLimitRequest.getSymbol()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getDeliveryPrice(MarketDataRequest deliveryPriceRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getDeliveryPrice(deliveryPriceRequest.getCategory().getProductTypeId(), deliveryPriceRequest.getSymbol(), deliveryPriceRequest.getBaseCoin(), deliveryPriceRequest.getLimit(), deliveryPriceRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketAccountRatio(MarketDataRequest marketAccountRatioRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketAccountRatio(marketAccountRatioRequest.getCategory().getProductTypeId(), marketAccountRatioRequest.getSymbol(), marketAccountRatioRequest.getDataRecordingPeriod() == null ? null : marketAccountRatioRequest.getDataRecordingPeriod().getPeriod(), marketAccountRatioRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAnnouncementInfo(AnnouncementInfoRequest announcementInfoRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAnouncementInfo(announcementInfoRequest.getLocale() == null ? null : announcementInfoRequest.getLocale().getLanguageSymbol(), announcementInfoRequest.getType() == null ? null : announcementInfoRequest.getType().getAnnouncementType(), announcementInfoRequest.getTag() == null ? null : announcementInfoRequest.getTag().getEnglishTranslation(), announcementInfoRequest.getPage(), announcementInfoRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

