/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.BybitApiAsyncTradeRestClient;
import com.bybit.api.client.BybitApiCallback;
import com.bybit.api.client.BybitApiService;
import com.bybit.api.client.domain.trade.BatchOrderRequest;
import com.bybit.api.client.domain.trade.TradeOrderRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;
import java.io.IOException;
import java.util.Map;

public class BybitApiTradeAsyncRestClientImpl
implements BybitApiAsyncTradeRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiTradeAsyncRestClientImpl(String apiKey, String secret) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret);
    }

    @Override
    public void getHistoryOrderResult(TradeOrderRequest orderHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getHistoryOrderResult(orderHistoryRequest.getCategory().getProductTypeId(), orderHistoryRequest.getSymbol(), orderHistoryRequest.getBaseCoin(), orderHistoryRequest.getSettleCoin(), orderHistoryRequest.getOrderId(), orderHistoryRequest.getOrderLinkId(), orderHistoryRequest.getOrderFilter(), orderHistoryRequest.getOrderStatus(), orderHistoryRequest.getStartTime(), orderHistoryRequest.getEndTime(), orderHistoryRequest.getLimit(), orderHistoryRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setDisconnectCancelAllTime(Integer timeWindow, BybitApiCallback<Object> callback) {
        this.bybitApiService.setDisconnectCancelAllTime(timeWindow).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getBorrowQuota(TradeOrderRequest borrowQuotaRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getBorrowQuota(borrowQuotaRequest.getCategory().getProductTypeId(), borrowQuotaRequest.getSymbol(), borrowQuotaRequest.getSide() == null ? null : borrowQuotaRequest.getSide().getTransactionSide()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getOpenOrders(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        this.bybitApiService.getOpenOrders(order.getCategory().getProductTypeId(), order.getSymbol(), order.getBaseCoin(), order.getSettleCoin(), order.getOrderId(), order.getOrderLinkId(), order.getOpenOnly(), order.getOrderFilter(), order.getLimit(), order.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createOrder(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        this.bybitApiService.createOrder(order).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createOrder(Map<String, Object> order, BybitApiCallback<Object> callback) {
        TradeOrderRequest singleOrderRequest = this.converter.convertMapToSingleOrderRequest(order);
        this.bybitApiService.createOrder(singleOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createOrder(String order, BybitApiCallback<Object> callback) throws IOException {
        TradeOrderRequest singleOrderRequest = this.converter.convertJsonToSingleOrderRequest(order);
        this.bybitApiService.createOrder(singleOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createBatchOrder(BatchOrderRequest batchOrderRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.createBatchOrder(batchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createBathOrder(Map<String, Object> payload, BybitApiCallback<Object> callback) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        this.bybitApiService.createBatchOrder(batchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createBathOrder(String json, BybitApiCallback<Object> callback) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        this.bybitApiService.createBatchOrder(batchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendBatchOrder(BatchOrderRequest batchOrderRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.amendBatchOrder(batchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendBatchOrder(Map<String, Object> payload, BybitApiCallback<Object> callback) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        this.bybitApiService.amendBatchOrder(batchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendBatchOrder(String json, BybitApiCallback<Object> callback) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        this.bybitApiService.amendBatchOrder(batchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelBatchOrder(BatchOrderRequest batchOrderRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.cancelBatchOrder(batchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelBatchOrder(Map<String, Object> payload, BybitApiCallback<Object> callback) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        this.bybitApiService.cancelBatchOrder(batchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelBatchOrder(String json, BybitApiCallback<Object> callback) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        this.bybitApiService.cancelBatchOrder(batchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelOrder(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        this.bybitApiService.cancelOrder(order.getCategory().getProductTypeId(), order.getSymbol(), order.getOrderId(), order.getOrderLinkId(), order.getOrderFilter()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelAllOrder(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        this.bybitApiService.cancelAllOrder(order.getCategory().getProductTypeId(), order.getSymbol(), order.getBaseCoin(), order.getSettleCoin(), order.getOrderFilter(), order.getStopOrderType() == null ? null : order.getStopOrderType().getDescription()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendOrder(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        this.bybitApiService.amendOrder(order.getCategory().getProductTypeId(), order.getSymbol(), order.getOrderId(), order.getOrderLinkId(), order.getOrderIv(), order.getTriggerPrice(), order.getQty(), order.getPrice(), order.getTakeProfit(), order.getStopLoss(), order.getTpTriggerBy(), order.getSlTriggerBy(), order.getTriggerBy(), order.getTpLimitPrice(), order.getSlLimitPrice()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

