/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.position.PositionDataRequest;
import com.bybit.api.client.domain.position.request.ModifyMarginRequest;
import com.bybit.api.client.domain.position.request.SetAutoAddMarginRequest;
import com.bybit.api.client.domain.position.request.SetLeverageRequest;
import com.bybit.api.client.domain.position.request.SetRiskLimitRequest;
import com.bybit.api.client.domain.position.request.SetTpSlModeRequest;
import com.bybit.api.client.domain.position.request.SwitchMarginRequest;
import com.bybit.api.client.domain.position.request.SwitchPositionModeRequest;
import com.bybit.api.client.domain.position.request.TradingStopRequest;
import com.bybit.api.client.restApi.BybitApiPositionRestClient;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiPositionRestClientImpl
implements BybitApiPositionRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiPositionRestClientImpl(String apiKey, String secret) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret);
    }

    @Override
    public Object getPositionInfo(PositionDataRequest positionListRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPositionInfo(positionListRequest.getCategory().getProductTypeId(), positionListRequest.getSymbol(), positionListRequest.getBaseCoin(), positionListRequest.getSettleCoin(), positionListRequest.getLimit(), positionListRequest.getCursor()));
    }

    @Override
    public Object setPositionLeverage(PositionDataRequest positionDataRequest) {
        SetLeverageRequest setLeverageRequest = this.converter.mapToSetLeverageRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setPositionLeverage(setLeverageRequest));
    }

    @Override
    public Object swithMarginRequest(PositionDataRequest positionDataRequest) {
        SwitchMarginRequest switchMarginRequest = this.converter.mapToSwitchMarginRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.swithMarginRequest(switchMarginRequest));
    }

    @Override
    public Object switchPositionMode(PositionDataRequest positionDataRequest) {
        SwitchPositionModeRequest switchPositionModeRequest = this.converter.mapToSwitchPositionModeRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.switchPositionMode(switchPositionModeRequest));
    }

    @Override
    public Object setTpslMode(PositionDataRequest positionDataRequest) {
        SetTpSlModeRequest setTpSlModeRequest = this.converter.mapToSetTpSlModeRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setTpslMode(setTpSlModeRequest));
    }

    @Override
    public Object setRiskLimit(PositionDataRequest positionDataRequest) {
        SetRiskLimitRequest setRiskLimitRequest = this.converter.mapToSetRiskLimitRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setRiskLimit(setRiskLimitRequest));
    }

    @Override
    public Object setTradingStop(PositionDataRequest positionDataRequest) {
        TradingStopRequest tradingStopRequest = this.converter.mapToTradingStopRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setTradingStop(tradingStopRequest));
    }

    @Override
    public Object setAutoAddMargin(PositionDataRequest positionDataRequest) {
        SetAutoAddMarginRequest setAutoAddMarginRequest = this.converter.mapToSetAutoAddMarginRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setAutoAddMargin(setAutoAddMarginRequest));
    }

    @Override
    public Object modifyPositionMargin(PositionDataRequest positionDataRequest) {
        ModifyMarginRequest modifyMarginRequest = this.converter.mapToModifyMarginRequest(positionDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.modifyPositionMargin(modifyMarginRequest));
    }

    @Override
    public Object getExecutionList(PositionDataRequest executionHistoryRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getExecutionList(executionHistoryRequest.getCategory().getProductTypeId(), executionHistoryRequest.getSymbol(), executionHistoryRequest.getOrderId(), executionHistoryRequest.getOrderLinkId(), executionHistoryRequest.getBaseCoin(), executionHistoryRequest.getStartTime(), executionHistoryRequest.getEndTime(), executionHistoryRequest.getExecType() == null ? null : executionHistoryRequest.getExecType().getExecTypeId(), executionHistoryRequest.getLimit(), executionHistoryRequest.getCursor()));
    }

    @Override
    public Object getClosePnlList(PositionDataRequest closePnlHistoryRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getClosePnlList(closePnlHistoryRequest.getCategory().getProductTypeId(), closePnlHistoryRequest.getSymbol(), closePnlHistoryRequest.getStartTime(), closePnlHistoryRequest.getEndTime(), closePnlHistoryRequest.getLimit(), closePnlHistoryRequest.getCursor()));
    }
}

