/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.broker;

import com.bybit.api.client.domain.broker.BusinessType;

public class BrokerDataRequest {
    private final BusinessType bizType;
    private final Long startTime;
    private final Long endTime;
    private final Integer limit;
    private final String cursor;

    BrokerDataRequest(BusinessType bizType, Long startTime, Long endTime, Integer limit, String cursor) {
        this.bizType = bizType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.limit = limit;
        this.cursor = cursor;
    }

    public static BrokerDataRequestBuilder builder() {
        return new BrokerDataRequestBuilder();
    }

    public BusinessType getBizType() {
        return this.bizType;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String toString() {
        return "BrokerDataRequest(bizType=" + this.getBizType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", limit=" + this.getLimit() + ", cursor=" + this.getCursor() + ")";
    }

    public static class BrokerDataRequestBuilder {
        private BusinessType bizType;
        private Long startTime;
        private Long endTime;
        private Integer limit;
        private String cursor;

        BrokerDataRequestBuilder() {
        }

        public BrokerDataRequestBuilder bizType(BusinessType bizType) {
            this.bizType = bizType;
            return this;
        }

        public BrokerDataRequestBuilder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public BrokerDataRequestBuilder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public BrokerDataRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public BrokerDataRequestBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public BrokerDataRequest build() {
            return new BrokerDataRequest(this.bizType, this.startTime, this.endTime, this.limit, this.cursor);
        }

        public String toString() {
            return "BrokerDataRequest.BrokerDataRequestBuilder(bizType=" + this.bizType + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", cursor=" + this.cursor + ")";
        }
    }
}

