/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.market.request;

import com.bybit.api.client.domain.ProductType;

public class FundingHistoryRequest {
    private final ProductType category;
    private final String symbol;
    private final Long startTime;
    private final Long endTime;
    private final Integer limit;

    FundingHistoryRequest(ProductType category, String symbol, Long startTime, Long endTime, Integer limit) {
        this.category = category;
        this.symbol = symbol;
        this.startTime = startTime;
        this.endTime = endTime;
        this.limit = limit;
    }

    public static FundingHistoryRequestBuilder builder() {
        return new FundingHistoryRequestBuilder();
    }

    public ProductType getCategory() {
        return this.category;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String toString() {
        return "FundingHistoryRequest(category=" + this.getCategory() + ", symbol=" + this.getSymbol() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", limit=" + this.getLimit() + ")";
    }

    public static class FundingHistoryRequestBuilder {
        private ProductType category;
        private String symbol;
        private Long startTime;
        private Long endTime;
        private Integer limit;

        FundingHistoryRequestBuilder() {
        }

        public FundingHistoryRequestBuilder category(ProductType category) {
            this.category = category;
            return this;
        }

        public FundingHistoryRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public FundingHistoryRequestBuilder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public FundingHistoryRequestBuilder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public FundingHistoryRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public FundingHistoryRequest build() {
            return new FundingHistoryRequest(this.category, this.symbol, this.startTime, this.endTime, this.limit);
        }

        public String toString() {
            return "FundingHistoryRequest.FundingHistoryRequestBuilder(category=" + this.category + ", symbol=" + this.symbol + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ")";
        }
    }
}

