/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.market.request;

import com.bybit.api.client.domain.ProductType;

public class InstrumentInfoRequest {
    private final ProductType category;
    private final String symbol;
    private final String status;
    private final String baseCoin;
    private final Integer limit;
    private final String cursor;

    InstrumentInfoRequest(ProductType category, String symbol, String status, String baseCoin, Integer limit, String cursor) {
        this.category = category;
        this.symbol = symbol;
        this.status = status;
        this.baseCoin = baseCoin;
        this.limit = limit;
        this.cursor = cursor;
    }

    public static InstrumentInfoRequestBuilder builder() {
        return new InstrumentInfoRequestBuilder();
    }

    public ProductType getCategory() {
        return this.category;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getStatus() {
        return this.status;
    }

    public String getBaseCoin() {
        return this.baseCoin;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String toString() {
        return "InstrumentInfoRequest(category=" + this.getCategory() + ", symbol=" + this.getSymbol() + ", status=" + this.getStatus() + ", baseCoin=" + this.getBaseCoin() + ", limit=" + this.getLimit() + ", cursor=" + this.getCursor() + ")";
    }

    public static class InstrumentInfoRequestBuilder {
        private ProductType category;
        private String symbol;
        private String status;
        private String baseCoin;
        private Integer limit;
        private String cursor;

        InstrumentInfoRequestBuilder() {
        }

        public InstrumentInfoRequestBuilder category(ProductType category) {
            this.category = category;
            return this;
        }

        public InstrumentInfoRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public InstrumentInfoRequestBuilder status(String status) {
            this.status = status;
            return this;
        }

        public InstrumentInfoRequestBuilder baseCoin(String baseCoin) {
            this.baseCoin = baseCoin;
            return this;
        }

        public InstrumentInfoRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public InstrumentInfoRequestBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public InstrumentInfoRequest build() {
            return new InstrumentInfoRequest(this.category, this.symbol, this.status, this.baseCoin, this.limit, this.cursor);
        }

        public String toString() {
            return "InstrumentInfoRequest.InstrumentInfoRequestBuilder(category=" + this.category + ", symbol=" + this.symbol + ", status=" + this.status + ", baseCoin=" + this.baseCoin + ", limit=" + this.limit + ", cursor=" + this.cursor + ")";
        }
    }
}

