/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.market.request;

import com.bybit.api.client.domain.ProductType;

public class MarketAccountRatioRequest {
    private final ProductType category;
    private final String symbol;
    private final String period;
    private final Integer limit;

    MarketAccountRatioRequest(ProductType category, String symbol, String period, Integer limit) {
        this.category = category;
        this.symbol = symbol;
        this.period = period;
        this.limit = limit;
    }

    public static MarketAccountRatioRequestBuilder builder() {
        return new MarketAccountRatioRequestBuilder();
    }

    public ProductType getCategory() {
        return this.category;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getPeriod() {
        return this.period;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String toString() {
        return "MarketAccountRatioRequest(category=" + this.getCategory() + ", symbol=" + this.getSymbol() + ", period=" + this.getPeriod() + ", limit=" + this.getLimit() + ")";
    }

    public static class MarketAccountRatioRequestBuilder {
        private ProductType category;
        private String symbol;
        private String period;
        private Integer limit;

        MarketAccountRatioRequestBuilder() {
        }

        public MarketAccountRatioRequestBuilder category(ProductType category) {
            this.category = category;
            return this;
        }

        public MarketAccountRatioRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public MarketAccountRatioRequestBuilder period(String period) {
            this.period = period;
            return this;
        }

        public MarketAccountRatioRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public MarketAccountRatioRequest build() {
            return new MarketAccountRatioRequest(this.category, this.symbol, this.period, this.limit);
        }

        public String toString() {
            return "MarketAccountRatioRequest.MarketAccountRatioRequestBuilder(category=" + this.category + ", symbol=" + this.symbol + ", period=" + this.period + ", limit=" + this.limit + ")";
        }
    }
}

