/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.market.request;

import com.bybit.api.client.domain.ProductType;

public class MarketDataTickerRequest {
    private final ProductType category;
    private final String symbol;
    private final String baseCoin;
    private final String expDate;

    MarketDataTickerRequest(ProductType category, String symbol, String baseCoin, String expDate) {
        this.category = category;
        this.symbol = symbol;
        this.baseCoin = baseCoin;
        this.expDate = expDate;
    }

    public static MarketDataTickerRequestBuilder builder() {
        return new MarketDataTickerRequestBuilder();
    }

    public ProductType getCategory() {
        return this.category;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getBaseCoin() {
        return this.baseCoin;
    }

    public String getExpDate() {
        return this.expDate;
    }

    public String toString() {
        return "MarketDataTickerRequest(category=" + this.getCategory() + ", symbol=" + this.getSymbol() + ", baseCoin=" + this.getBaseCoin() + ", expDate=" + this.getExpDate() + ")";
    }

    public static class MarketDataTickerRequestBuilder {
        private ProductType category;
        private String symbol;
        private String baseCoin;
        private String expDate;

        MarketDataTickerRequestBuilder() {
        }

        public MarketDataTickerRequestBuilder category(ProductType category) {
            this.category = category;
            return this;
        }

        public MarketDataTickerRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public MarketDataTickerRequestBuilder baseCoin(String baseCoin) {
            this.baseCoin = baseCoin;
            return this;
        }

        public MarketDataTickerRequestBuilder expDate(String expDate) {
            this.expDate = expDate;
            return this;
        }

        public MarketDataTickerRequest build() {
            return new MarketDataTickerRequest(this.category, this.symbol, this.baseCoin, this.expDate);
        }

        public String toString() {
            return "MarketDataTickerRequest.MarketDataTickerRequestBuilder(category=" + this.category + ", symbol=" + this.symbol + ", baseCoin=" + this.baseCoin + ", expDate=" + this.expDate + ")";
        }
    }
}

