/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.market.request;

import com.bybit.api.client.domain.ProductType;
import com.bybit.api.client.domain.market.MarketInterval;

public class MarketKlineRequest {
    private final ProductType category;
    private final String symbol;
    private final MarketInterval marketInterval;
    private final Long start;
    private final Long end;
    private final Integer limit;

    MarketKlineRequest(ProductType category, String symbol, MarketInterval marketInterval, Long start, Long end, Integer limit) {
        this.category = category;
        this.symbol = symbol;
        this.marketInterval = marketInterval;
        this.start = start;
        this.end = end;
        this.limit = limit;
    }

    public static MarketKlineRequestBuilder builder() {
        return new MarketKlineRequestBuilder();
    }

    public ProductType getCategory() {
        return this.category;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public MarketInterval getMarketInterval() {
        return this.marketInterval;
    }

    public Long getStart() {
        return this.start;
    }

    public Long getEnd() {
        return this.end;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String toString() {
        return "MarketKlineRequest(category=" + this.getCategory() + ", symbol=" + this.getSymbol() + ", marketInterval=" + this.getMarketInterval() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", limit=" + this.getLimit() + ")";
    }

    public static class MarketKlineRequestBuilder {
        private ProductType category;
        private String symbol;
        private MarketInterval marketInterval;
        private Long start;
        private Long end;
        private Integer limit;

        MarketKlineRequestBuilder() {
        }

        public MarketKlineRequestBuilder category(ProductType category) {
            this.category = category;
            return this;
        }

        public MarketKlineRequestBuilder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public MarketKlineRequestBuilder marketInterval(MarketInterval marketInterval) {
            this.marketInterval = marketInterval;
            return this;
        }

        public MarketKlineRequestBuilder start(Long start) {
            this.start = start;
            return this;
        }

        public MarketKlineRequestBuilder end(Long end) {
            this.end = end;
            return this;
        }

        public MarketKlineRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public MarketKlineRequest build() {
            return new MarketKlineRequest(this.category, this.symbol, this.marketInterval, this.start, this.end, this.limit);
        }

        public String toString() {
            return "MarketKlineRequest.MarketKlineRequestBuilder(category=" + this.category + ", symbol=" + this.symbol + ", marketInterval=" + this.marketInterval + ", start=" + this.start + ", end=" + this.end + ", limit=" + this.limit + ")";
        }
    }
}

