/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.trade;

import com.bybit.api.client.domain.ProductType;
import com.bybit.api.client.domain.trade.TradeOrderRequest;
import com.bybit.api.client.service.ProductTypeSerializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;

public class BatchOrderRequest {
    @JsonSerialize(using=ProductTypeSerializer.class)
    private ProductType category;
    private List<TradeOrderRequest> request;

    BatchOrderRequest(ProductType category, List<TradeOrderRequest> request) {
        this.category = category;
        this.request = request;
    }

    public static BatchOrderRequestBuilder builder() {
        return new BatchOrderRequestBuilder();
    }

    public ProductType getCategory() {
        return this.category;
    }

    public List<TradeOrderRequest> getRequest() {
        return this.request;
    }

    public void setCategory(ProductType category) {
        this.category = category;
    }

    public void setRequest(List<TradeOrderRequest> request) {
        this.request = request;
    }

    public String toString() {
        return "BatchOrderRequest(category=" + this.getCategory() + ", request=" + this.getRequest() + ")";
    }

    public static class BatchOrderRequestBuilder {
        private ProductType category;
        private List<TradeOrderRequest> request;

        BatchOrderRequestBuilder() {
        }

        public BatchOrderRequestBuilder category(ProductType category) {
            this.category = category;
            return this;
        }

        public BatchOrderRequestBuilder request(List<TradeOrderRequest> request) {
            this.request = request;
            return this;
        }

        public BatchOrderRequest build() {
            return new BatchOrderRequest(this.category, this.request);
        }

        public String toString() {
            return "BatchOrderRequest.BatchOrderRequestBuilder(category=" + this.category + ", request=" + this.request + ")";
        }
    }
}

