/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.spot.SpotMarginDataRequest;
import com.bybit.api.client.domain.spot.leverageToken.SpotLeverageTokenRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeBorrowRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeRePayRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.restApi.BybitApiAsyncSpotMarginRestClient;
import com.bybit.api.client.restApi.BybitApiCallback;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAsyncSpotMarginRestClientImpl
implements BybitApiAsyncSpotMarginRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAsyncSpotMarginRestClientImpl(String apiKey, String secret) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret);
    }

    @Override
    public void getSpotLeverageTokenInfo(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getSpotLeverageTokenInfo(spotMarginDataRequest.getLtCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getSpotLeverageTokenMarket(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getSpotLeverageTokenMarket(spotMarginDataRequest.getLtCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void purchaseSpotLeverageToken(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        SpotLeverageTokenRequest spotLeverageTokenRequest = this.converter.mapToSpotLeverageTokenRequest(spotMarginDataRequest);
        this.bybitApiService.purchaseSpotLeverageToken(spotLeverageTokenRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void redeemSpotLeverageToken(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        SpotLeverageTokenRequest spotLeverageTokenRequest = this.converter.mapToSpotLeverageTokenRequest(spotMarginDataRequest);
        this.bybitApiService.redeemSpotLeverageToken(spotLeverageTokenRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getSpotLeverageRecords(SpotMarginDataRequest spotLeverageOrdersRecordRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getSpotLeverageRecords(spotLeverageOrdersRecordRequest.getLtCoin(), spotLeverageOrdersRecordRequest.getOrderId(), spotLeverageOrdersRecordRequest.getStartTime(), spotLeverageOrdersRecordRequest.getEndTime(), spotLeverageOrdersRecordRequest.getLimit(), spotLeverageOrdersRecordRequest.getLtOrderType(), spotLeverageOrdersRecordRequest.getSerialNo()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getUtaVipSpotMarginTradeData(SpotMarginDataRequest utaMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getUtaVipSpotMarginTradeData(utaMarginDataRequest.getVipLevel() == null ? null : utaMarginDataRequest.getVipLevel().getLevel(), utaMarginDataRequest.getCurrency()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setUTASpotMarginTrade(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        String mode = spotMarginDataRequest.getSpotMarginMode() == null ? null : spotMarginDataRequest.getSpotMarginMode().getValue();
        this.bybitApiService.setUTASpotMarginTrade(mode).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setUTASpotMarginTradeLeverage(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        String leverage = spotMarginDataRequest.getLeverage();
        this.bybitApiService.setUTASpotMarginTradeLeverage(leverage).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getUTASpotMarginTradeLeverageState(BybitApiCallback<Object> callback) {
        this.bybitApiService.getUTASpotMarginTradeLeverageState().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getNormalVipSpotMarginTradeData(SpotMarginDataRequest normalMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalVipSpotMarginTradeData(normalMarginDataRequest.getVipLevel() == null ? null : normalMarginDataRequest.getVipLevel().getLevel(), normalMarginDataRequest.getCurrency()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getNormalSpotMarginTradeCoinInfo(SpotMarginDataRequest normalMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalSpotMarginTradeCoinInfo(normalMarginDataRequest.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getNormalSpotMarginTradeBorrowCoinInfo(SpotMarginDataRequest normalMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalSpotMarginTradeBorrowCoinInfo(normalMarginDataRequest.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getNormalSpotMarginTradeInterestQuota(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalSpotMarginTradeInterestQuota(spotMarginDataRequest.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getNormalSpotMarginTradeAccountInfo(BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalSpotMarginTradeAccountInfo().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setNormalSpotToggleMarginTrade(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        int switchStatus = spotMarginDataRequest.getSwitchStatus() == null ? 0 : spotMarginDataRequest.getSwitchStatus().getValue();
        this.bybitApiService.setNormalSpotToggleMarginTrade(switchStatus).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void loanNormalSpotMarginTrade(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        SpotMarginTradeBorrowRequest spotMarginTradeBorrowRequest = this.converter.mapToSpotMarginBorrowRequest(spotMarginDataRequest);
        this.bybitApiService.loanNormalSpotMarginTrade(spotMarginTradeBorrowRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void repayNormalSpotMarginTrade(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        SpotMarginTradeRePayRequest spotMarginTradeRePayRequest = this.converter.mapToSpotMarginRepayRequest(spotMarginDataRequest);
        this.bybitApiService.repayNormalSpotMarginTrade(spotMarginTradeRePayRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getNormalSpotMarginTradeBorrowOrders(SpotMarginDataRequest spotMarginTradeBorrowOrdersRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalMarginTradeBorrowOrders(spotMarginTradeBorrowOrdersRequest.getStartTime(), spotMarginTradeBorrowOrdersRequest.getEndTime(), spotMarginTradeBorrowOrdersRequest.getCoin(), spotMarginTradeBorrowOrdersRequest.getBorrowStatus() == null ? 0 : spotMarginTradeBorrowOrdersRequest.getBorrowStatus().getValue(), spotMarginTradeBorrowOrdersRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getNormalSpotMarginTradeRepayOrders(SpotMarginDataRequest spotMarginTradeRepayOrdersRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalMarginTradeRepayOrders(spotMarginTradeRepayOrdersRequest.getStartTime(), spotMarginTradeRepayOrdersRequest.getEndTime(), spotMarginTradeRepayOrdersRequest.getCoin(), spotMarginTradeRepayOrdersRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

