/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.service;

import com.bybit.api.client.config.BybitApiConfig;
import com.bybit.api.client.impl.BybitApBrokerRestClientImpl;
import com.bybit.api.client.impl.BybitApiAccountRestClientImpl;
import com.bybit.api.client.impl.BybitApiAssetRestClientImpl;
import com.bybit.api.client.impl.BybitApiAsyncAccountRestClientImpl;
import com.bybit.api.client.impl.BybitApiAsyncAssetRestClientImpl;
import com.bybit.api.client.impl.BybitApiAsyncBrokerRestClientImpl;
import com.bybit.api.client.impl.BybitApiAsyncLendingRestClientImpl;
import com.bybit.api.client.impl.BybitApiAsyncPositionRestClientImpl;
import com.bybit.api.client.impl.BybitApiAsyncSpotMarginRestClientImpl;
import com.bybit.api.client.impl.BybitApiAsyncUserRestClientImpl;
import com.bybit.api.client.impl.BybitApiLendingRestClientImpl;
import com.bybit.api.client.impl.BybitApiMarketAsyncRestClientImpl;
import com.bybit.api.client.impl.BybitApiMarketRestClientImpl;
import com.bybit.api.client.impl.BybitApiPositionRestClientImpl;
import com.bybit.api.client.impl.BybitApiSpotMarginRestClientImpl;
import com.bybit.api.client.impl.BybitApiTradeAsyncRestClientImpl;
import com.bybit.api.client.impl.BybitApiTradeRestClientImpl;
import com.bybit.api.client.impl.BybitApiUserRestClientImpl;
import com.bybit.api.client.restApi.BybitApiAccountRestClient;
import com.bybit.api.client.restApi.BybitApiAssetRestClient;
import com.bybit.api.client.restApi.BybitApiAsyncAccountRestClient;
import com.bybit.api.client.restApi.BybitApiAsyncAssetRestClient;
import com.bybit.api.client.restApi.BybitApiAsyncBrokerRestClient;
import com.bybit.api.client.restApi.BybitApiAsyncLendingRestClient;
import com.bybit.api.client.restApi.BybitApiAsyncMarketDataRestClient;
import com.bybit.api.client.restApi.BybitApiAsyncPositionRestClient;
import com.bybit.api.client.restApi.BybitApiAsyncSpotMarginRestClient;
import com.bybit.api.client.restApi.BybitApiAsyncTradeRestClient;
import com.bybit.api.client.restApi.BybitApiAsyncUserRestClient;
import com.bybit.api.client.restApi.BybitApiBrokerRestClient;
import com.bybit.api.client.restApi.BybitApiLendingRestClient;
import com.bybit.api.client.restApi.BybitApiMarketRestClient;
import com.bybit.api.client.restApi.BybitApiPositionRestClient;
import com.bybit.api.client.restApi.BybitApiSpotMarginRestClient;
import com.bybit.api.client.restApi.BybitApiTradeRestClient;
import com.bybit.api.client.restApi.BybitApiUserRestClient;
import com.bybit.api.client.websocket.WebsocketClient;
import com.bybit.api.client.websocket.WebsocketClientImpl;
import com.bybit.api.client.websocket.WebsocketMessageHandler;

public class BybitApiClientFactory {
    private final String apiKey;
    private final String secret;

    private BybitApiClientFactory(String apiKey, String secret) {
        this.apiKey = apiKey;
        this.secret = secret;
        BybitApiConfig.useTestnet = false;
    }

    private BybitApiClientFactory(String apiKey, String secret, boolean useTestnet) {
        this(apiKey, secret);
        BybitApiConfig.useTestnet = useTestnet;
    }

    public static BybitApiClientFactory newInstance(String apiKey, String secret) {
        return new BybitApiClientFactory(apiKey, secret);
    }

    public static BybitApiClientFactory newInstance(String apiKey, String secret, boolean useTestnet) {
        return new BybitApiClientFactory(apiKey, secret, useTestnet);
    }

    public static BybitApiClientFactory newInstance() {
        return new BybitApiClientFactory(null, null);
    }

    public static BybitApiClientFactory newInstance(boolean useTestnet) {
        return new BybitApiClientFactory(null, null, useTestnet);
    }

    public BybitApiSpotMarginRestClient newSpotMarginRestClient() {
        return new BybitApiSpotMarginRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAsyncSpotMarginRestClient newSpotMarginAsyncRestClient() {
        return new BybitApiAsyncSpotMarginRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiUserRestClient newUserRestClient() {
        return new BybitApiUserRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAsyncUserRestClient newAsyncUserRestClient() {
        return new BybitApiAsyncUserRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiMarketRestClient newMarketDataRestClient() {
        return new BybitApiMarketRestClientImpl();
    }

    public BybitApiAsyncMarketDataRestClient newAsyncMarketDataRestClient() {
        return new BybitApiMarketAsyncRestClientImpl();
    }

    public BybitApiLendingRestClient newLendingRestClient() {
        return new BybitApiLendingRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAsyncLendingRestClient newAsyncLendingRestClient() {
        return new BybitApiAsyncLendingRestClientImpl();
    }

    public BybitApiTradeRestClient newTradeRestClient() {
        return new BybitApiTradeRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAsyncTradeRestClient newAsyncTradeRestClient() {
        return new BybitApiTradeAsyncRestClientImpl(this.apiKey, this.secret);
    }

    public WebsocketClient newWebsocketClient(WebsocketMessageHandler messageHandler, Boolean debugMode) {
        return new WebsocketClientImpl(this.apiKey, this.secret, BybitApiConfig.useTestnet ? "wss://stream-testnet.bybit.com" : "wss://stream.bybit.com", messageHandler, debugMode);
    }

    public WebsocketClient newWebsocketClient(WebsocketMessageHandler messageHandler) {
        return new WebsocketClientImpl(this.apiKey, this.secret, BybitApiConfig.useTestnet ? "wss://stream-testnet.bybit.com" : "wss://stream.bybit.com", messageHandler);
    }

    public WebsocketClient newWebsocketClient(Boolean debugMode) {
        return new WebsocketClientImpl(this.apiKey, this.secret, BybitApiConfig.useTestnet ? "wss://stream-testnet.bybit.com" : "wss://stream.bybit.com", debugMode);
    }

    public WebsocketClient newWebsocketClient() {
        return new WebsocketClientImpl(this.apiKey, this.secret, BybitApiConfig.useTestnet ? "wss://stream-testnet.bybit.com" : "wss://stream.bybit.com");
    }

    public BybitApiPositionRestClient newPositionRestClient() {
        return new BybitApiPositionRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAsyncPositionRestClient newAsyncPositionRestClient() {
        return new BybitApiAsyncPositionRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAccountRestClient newAccountRestClient() {
        return new BybitApiAccountRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAsyncAccountRestClient newAsyncAccountRestClient() {
        return new BybitApiAsyncAccountRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAssetRestClient newAssetRestClient() {
        return new BybitApiAssetRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAsyncAssetRestClient newAsyncAssetRestClient() {
        return new BybitApiAsyncAssetRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiBrokerRestClient newBrokerRestClient() {
        return new BybitApBrokerRestClientImpl(this.apiKey, this.secret);
    }

    public BybitApiAsyncBrokerRestClient newAsyncBrokerRestClient() {
        return new BybitApiAsyncBrokerRestClientImpl(this.apiKey, this.secret);
    }
}

