/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.websocket;

import java.io.IOException;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class WebsocketLoggingInterceptor
implements Interceptor {
    private final Logger LOGGER;

    public WebsocketLoggingInterceptor(Logger logger) {
        this.LOGGER = logger;
    }

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        this.logHeaders(request.headers(), "--- request header ---");
        Response response = chain.proceed(request);
        this.logHeaders(response.headers(), "--- response header ---");
        return response;
    }

    private void logHeaders(Headers headers, String headerTitle) {
        this.LOGGER.info(headerTitle);
        for (String name : headers.names()) {
            this.LOGGER.info(name + ": " + headers.get(name));
        }
        this.LOGGER.info("-----------------------");
    }
}

