/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.service;

import com.bybit.api.client.constant.Util;
import com.bybit.api.client.domain.CategoryType;
import com.bybit.api.client.domain.TradeOrderType;
import com.bybit.api.client.domain.TriggerBy;
import com.bybit.api.client.domain.account.AccountDataRequest;
import com.bybit.api.client.domain.account.request.ResetMMPRequest;
import com.bybit.api.client.domain.account.request.SetCollateralCoinRequest;
import com.bybit.api.client.domain.account.request.SetMMPRequest;
import com.bybit.api.client.domain.account.request.SetMarginModeRequest;
import com.bybit.api.client.domain.asset.AssetDataRequest;
import com.bybit.api.client.domain.asset.request.AssetCancelWithdrawRequest;
import com.bybit.api.client.domain.asset.request.AssetInternalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetUniversalTransferRequest;
import com.bybit.api.client.domain.asset.request.AssetWithdrawRequest;
import com.bybit.api.client.domain.asset.request.SetAssetDepositAccountRequest;
import com.bybit.api.client.domain.institution.LendingDataRequest;
import com.bybit.api.client.domain.institution.clientLending.ClientLendingFundsRequest;
import com.bybit.api.client.domain.position.ConfirmNewRiskLimitRequest;
import com.bybit.api.client.domain.position.PositionDataRequest;
import com.bybit.api.client.domain.position.request.ModifyMarginRequest;
import com.bybit.api.client.domain.position.request.SetAutoAddMarginRequest;
import com.bybit.api.client.domain.position.request.SetLeverageRequest;
import com.bybit.api.client.domain.position.request.SetRiskLimitRequest;
import com.bybit.api.client.domain.position.request.SetTpSlModeRequest;
import com.bybit.api.client.domain.position.request.SwitchMarginRequest;
import com.bybit.api.client.domain.position.request.SwitchPositionModeRequest;
import com.bybit.api.client.domain.position.request.TradingStopRequest;
import com.bybit.api.client.domain.spot.SpotMarginDataRequest;
import com.bybit.api.client.domain.spot.leverageToken.SpotLeverageTokenRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeBorrowRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeRePayRequest;
import com.bybit.api.client.domain.trade.OrderFilter;
import com.bybit.api.client.domain.trade.PositionIdx;
import com.bybit.api.client.domain.trade.Side;
import com.bybit.api.client.domain.trade.SmpType;
import com.bybit.api.client.domain.trade.TimeInForce;
import com.bybit.api.client.domain.trade.request.AmendBatchOrderRequest;
import com.bybit.api.client.domain.trade.request.AmendOrderRequest;
import com.bybit.api.client.domain.trade.request.BatchOrderRequest;
import com.bybit.api.client.domain.trade.request.CancelAllOrdersRequest;
import com.bybit.api.client.domain.trade.request.CancelBatchOrderRequest;
import com.bybit.api.client.domain.trade.request.CancelOrderRequest;
import com.bybit.api.client.domain.trade.request.PlaceBatchOrderRequest;
import com.bybit.api.client.domain.trade.request.PlaceOrderRequest;
import com.bybit.api.client.domain.trade.request.SetDcpRequest;
import com.bybit.api.client.domain.trade.request.TradeOrderRequest;
import com.bybit.api.client.domain.user.IsUta;
import com.bybit.api.client.domain.user.MemberType;
import com.bybit.api.client.domain.user.SwitchOption;
import com.bybit.api.client.domain.user.UserDataRequest;
import com.bybit.api.client.domain.user.request.CreateApiKeyRequest;
import com.bybit.api.client.domain.user.request.FreezeSubUIDRquest;
import com.bybit.api.client.domain.user.request.ModifyApiKeyRequest;
import com.bybit.api.client.domain.user.request.UserSubMemberRequest;
import com.bybit.api.client.exception.BybitApiException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BybitJsonConverter {
    private final ObjectMapper mapper = new ObjectMapper();

    private TradeOrderRequest getTradeOrderRequest(Map<String, Object> orderMap) {
        String category;
        String string = category = orderMap.containsKey("category") ? orderMap.get("category").toString() : null;
        if (StringUtils.isEmpty((CharSequence)category)) {
            throw new BybitApiException("Please set category for your order");
        }
        return this.getTradeOrderRequest(orderMap, category);
    }

    private TradeOrderRequest getTradeOrderRequest(Map<String, Object> orderMap, String category) {
        String orderTypeValue = (String)orderMap.get("orderType");
        TradeOrderType currentOrderType = TradeOrderType.valueOf(orderTypeValue.toUpperCase());
        TimeInForce defaultTimeInForce = currentOrderType == TradeOrderType.MARKET ? TimeInForce.IMMEDIATE_OR_CANCEL : TimeInForce.GOOD_TILL_CANCEL;
        return TradeOrderRequest.builder().category(CategoryType.valueOf(category.toUpperCase())).symbol((String)orderMap.get("symbol")).side(Side.valueOf(orderMap.get("side").toString().toUpperCase())).orderType(currentOrderType).qty((String)orderMap.get("qty")).orderId(orderMap.getOrDefault("orderId", null)).orderLinkId(orderMap.getOrDefault("orderLinkId", null)).triggerDirection(orderMap.getOrDefault("triggerDirection", null)).orderFilter(orderMap.containsKey("orderFilter") ? OrderFilter.valueOf(orderMap.get("orderFilter").toString().toUpperCase()) : null).triggerPrice(orderMap.getOrDefault("triggerPrice", null)).triggerBy(orderMap.containsKey("triggerBy") ? TriggerBy.valueOf(orderMap.get("triggerBy").toString().toUpperCase()) : null).orderIv(orderMap.getOrDefault("orderIv", null)).timeInForce(TimeInForce.valueOf(orderMap.getOrDefault("timeInForce", (Object)defaultTimeInForce).toString().toUpperCase())).positionIdx(orderMap.containsKey("positionIdx") ? this.getOrderPositionIndexFromString(orderMap.get("positionIdx").toString()) : null).orderLinkId(orderMap.getOrDefault("orderLinkId", null)).takeProfit(orderMap.getOrDefault("takeProfit", null)).stopLoss(orderMap.getOrDefault("stopLoss", null)).tpTriggerBy(orderMap.containsKey("tpTriggerBy") ? TriggerBy.valueOf(orderMap.get("tpTriggerBy").toString().toUpperCase()) : TriggerBy.LAST_PRICE).slTriggerBy(orderMap.containsKey("slTriggerBy") ? TriggerBy.valueOf(orderMap.get("slTriggerBy").toString().toUpperCase()) : TriggerBy.LAST_PRICE).reduceOnly((Boolean)orderMap.getOrDefault("reduceOnly", false)).closeOnTrigger((Boolean)orderMap.getOrDefault("closeOnTrigger", false)).smpType(orderMap.containsKey("smpType") ? SmpType.valueOf(orderMap.get("smpType").toString().toUpperCase()) : null).mmp(orderMap.getOrDefault("mmp", null)).tpslMode(orderMap.getOrDefault("tpslMode", null)).tpLimitPrice(orderMap.getOrDefault("tpLimitPrice", null)).slLimitPrice(orderMap.getOrDefault("slLimitPrice", null)).tpOrderType(orderMap.containsKey("tpOrderType") ? TradeOrderType.valueOf(orderMap.get("tpOrderType").toString().toUpperCase()) : null).slOrderType(orderMap.containsKey("slOrderType") ? TradeOrderType.valueOf(orderMap.get("slOrderType").toString().toUpperCase()) : null).build();
    }

    private TradeOrderRequest getTradeOrderRequest(JsonNode requestNode) {
        String category;
        String string = category = requestNode.has("category") ? requestNode.get("category").asText() : null;
        if (StringUtils.isEmpty((CharSequence)category)) {
            throw new BybitApiException("Please set category for your order");
        }
        return this.getTradeOrderRequest(requestNode, category);
    }

    public TradeOrderRequest getTradeOrderRequest(JsonNode requestNode, String category) {
        return TradeOrderRequest.builder().category(CategoryType.valueOf(category.toUpperCase())).symbol(requestNode.get("symbol").asText()).orderType(TradeOrderType.valueOf(requestNode.get("orderType").asText().toUpperCase())).side(Side.valueOf(requestNode.get("side").asText().toUpperCase())).qty(requestNode.get("qty").asText()).price(requestNode.has("price") ? requestNode.get("price").asText() : null).triggerDirection(requestNode.has("triggerDirection") ? Integer.valueOf(requestNode.get("triggerDirection").asInt()) : null).orderId(requestNode.has("orderId") ? requestNode.get("orderId").asText() : null).orderLinkId(requestNode.has("orderLinkId") ? requestNode.get("orderLinkId").asText() : null).orderFilter(requestNode.has("orderFilter") ? OrderFilter.valueOf(requestNode.get("orderFilter").asText().toUpperCase()) : null).triggerPrice(requestNode.has("triggerPrice") ? requestNode.get("triggerPrice").asText() : null).triggerBy(requestNode.has("triggerBy") ? TriggerBy.valueOf(requestNode.get("triggerBy").asText().toUpperCase()) : null).orderIv(requestNode.has("orderIv") ? requestNode.get("orderIv").asText() : null).timeInForce(requestNode.has("timeInForce") ? TimeInForce.valueOf(requestNode.get("timeInForce").asText().toUpperCase()) : null).positionIdx(requestNode.has("positionIdx") ? PositionIdx.valueOf(requestNode.get("positionIdx").asText().toUpperCase()) : null).orderLinkId(requestNode.has("orderLinkId") ? requestNode.get("orderLinkId").asText() : null).takeProfit(requestNode.has("takeProfit") ? requestNode.get("takeProfit").asText() : null).stopLoss(requestNode.has("stopLoss") ? requestNode.get("stopLoss").asText() : null).tpTriggerBy(requestNode.has("tpTriggerBy") ? TriggerBy.valueOf(requestNode.get("tpTriggerBy").asText().toUpperCase()) : TriggerBy.LAST_PRICE).slTriggerBy(requestNode.has("slTriggerBy") ? TriggerBy.valueOf(requestNode.get("slTriggerBy").asText().toUpperCase()) : TriggerBy.LAST_PRICE).reduceOnly(requestNode.has("reduceOnly") && requestNode.get("reduceOnly").asBoolean()).closeOnTrigger(requestNode.has("closeOnTrigger") && requestNode.get("closeOnTrigger").asBoolean()).smpType(requestNode.has("smpType") ? SmpType.valueOf(requestNode.get("smpType").asText().toUpperCase()) : null).mmp(requestNode.has("mmp") ? Boolean.valueOf(requestNode.get("mmp").asBoolean()) : null).tpslMode(requestNode.has("tpslMode") ? requestNode.get("tpslMode").asText() : null).tpLimitPrice(requestNode.has("tpLimitPrice") ? requestNode.get("tpLimitPrice").asText() : null).slLimitPrice(requestNode.has("slLimitPrice") ? requestNode.get("slLimitPrice").asText() : null).tpOrderType(requestNode.has("tpOrderType") ? TradeOrderType.valueOf(requestNode.get("tpOrderType").asText().toUpperCase()) : null).slOrderType(requestNode.has("slOrderType") ? TradeOrderType.valueOf(requestNode.get("slOrderType").asText().toUpperCase()) : null).build();
    }

    public PositionIdx getOrderPositionIndexFromString(String positionIdxValue) {
        int index = Integer.parseInt(positionIdxValue);
        for (PositionIdx positionIdx : PositionIdx.values()) {
            if (positionIdx.getIndex() != index) continue;
            return positionIdx;
        }
        throw new BybitApiException("Position index invalid");
    }

    public CategoryType getCategoryTypeFromString(String category) {
        for (CategoryType type : CategoryType.values()) {
            if (!type.getCategoryTypeId().equalsIgnoreCase(category)) continue;
            return type;
        }
        throw new BybitApiException("category invalid");
    }

    public TradeOrderRequest convertMapToSingleOrderRequest(Map<String, Object> orderMap) {
        return this.getTradeOrderRequest(orderMap);
    }

    public TradeOrderRequest convertJsonToSingleOrderRequest(String json) throws IOException {
        JsonNode rootNode = this.mapper.readTree(json);
        return this.getTradeOrderRequest(rootNode);
    }

    public BatchOrderRequest jsonToBatchOrderRequest(String json) throws IOException {
        String category;
        JsonNode rootNode = this.mapper.readTree(json);
        String string = category = rootNode.has("category") ? rootNode.get("category").asText() : null;
        if (StringUtils.isEmpty((CharSequence)category)) {
            throw new BybitApiException("Please set category for your order");
        }
        CategoryType CategoryType2 = this.getCategoryTypeFromString(category);
        ArrayList<TradeOrderRequest> requestList = new ArrayList<TradeOrderRequest>();
        JsonNode requestArrayNode = rootNode.get("request");
        for (JsonNode requestNode : requestArrayNode) {
            TradeOrderRequest request = this.getTradeOrderRequest(requestNode, category);
            requestList.add(request);
        }
        return BatchOrderRequest.builder().category(CategoryType2).request(requestList).build();
    }

    public BatchOrderRequest convertMapToBatchOrderRequest(Map<String, Object> payload) {
        String category;
        String string = category = payload.containsKey("category") ? payload.get("category").toString() : null;
        if (StringUtils.isEmpty((CharSequence)category)) {
            throw new BybitApiException("Please set category for your order");
        }
        CategoryType CategoryType2 = this.getCategoryTypeFromString(category);
        List orderMaps = (List)payload.get("request");
        ArrayList<TradeOrderRequest> orders = new ArrayList<TradeOrderRequest>();
        for (Map orderMap : orderMaps) {
            TradeOrderRequest order = this.getTradeOrderRequest(orderMap, category);
            orders.add(order);
        }
        return BatchOrderRequest.builder().category(CategoryType2).request(orders).build();
    }

    public PlaceBatchOrderRequest convertToPlaceBatchOrderRequest(BatchOrderRequest batchOrderRequest) {
        ArrayList<PlaceOrderRequest> list = new ArrayList<PlaceOrderRequest>();
        for (TradeOrderRequest tradeOrderRequest : batchOrderRequest.getRequest()) {
            list.add(this.convertTradeToPlaceOrderRequest(tradeOrderRequest));
        }
        return PlaceBatchOrderRequest.builder().category(batchOrderRequest.getCategory()).request(list).build();
    }

    public AmendBatchOrderRequest convertToAmendBatchOrderRequest(BatchOrderRequest batchOrderRequest) {
        ArrayList<AmendOrderRequest> list = new ArrayList<AmendOrderRequest>();
        for (TradeOrderRequest tradeOrderRequest : batchOrderRequest.getRequest()) {
            list.add(this.convertTradeToAmendOrderRequest(tradeOrderRequest));
        }
        return AmendBatchOrderRequest.builder().category(batchOrderRequest.getCategory()).request(list).build();
    }

    public CancelBatchOrderRequest convertToCancelBatchOrderRequest(BatchOrderRequest batchOrderRequest) {
        ArrayList<CancelOrderRequest> list = new ArrayList<CancelOrderRequest>();
        for (TradeOrderRequest tradeOrderRequest : batchOrderRequest.getRequest()) {
            list.add(this.convertTradeToCancelOrderRequest(tradeOrderRequest));
        }
        return CancelBatchOrderRequest.builder().category(batchOrderRequest.getCategory()).request(list).build();
    }

    public CancelOrderRequest convertTradeToCancelOrderRequest(TradeOrderRequest tradeOrderRequest) {
        return CancelOrderRequest.builder().category(tradeOrderRequest.getCategory() == null ? null : tradeOrderRequest.getCategory().getCategoryTypeId()).symbol(tradeOrderRequest.getSymbol()).orderId(tradeOrderRequest.getOrderId()).orderLinkId(tradeOrderRequest.getOrderLinkId()).orderFilter(tradeOrderRequest.getOrderFilter() == null ? null : tradeOrderRequest.getOrderFilter().getOrderFilterType()).build();
    }

    public CancelAllOrdersRequest convertTradeToCancelAllOrdersRequest(TradeOrderRequest tradeOrderRequest) {
        return CancelAllOrdersRequest.builder().category(tradeOrderRequest.getCategory() == null ? null : tradeOrderRequest.getCategory().getCategoryTypeId()).symbol(tradeOrderRequest.getSymbol()).baseCoin(tradeOrderRequest.getBaseCoin()).settleCoin(tradeOrderRequest.getSettleCoin()).orderFilter(tradeOrderRequest.getOrderFilter() == null ? null : tradeOrderRequest.getOrderFilter().getOrderFilterType()).stopOrderType(tradeOrderRequest.getStopOrderType() == null ? null : tradeOrderRequest.getStopOrderType().getDescription()).build();
    }

    public AmendOrderRequest convertTradeToAmendOrderRequest(TradeOrderRequest tradeOrderRequest) {
        return AmendOrderRequest.builder().category(tradeOrderRequest.getCategory() == null ? null : tradeOrderRequest.getCategory().getCategoryTypeId()).symbol(tradeOrderRequest.getSymbol()).qty(tradeOrderRequest.getQty()).price(tradeOrderRequest.getPrice()).triggerPrice(tradeOrderRequest.getTriggerPrice()).triggerBy(tradeOrderRequest.getTriggerBy() == null ? null : tradeOrderRequest.getTriggerBy().getTrigger()).orderIv(tradeOrderRequest.getOrderIv()).orderId(tradeOrderRequest.getOrderId()).orderLinkId(tradeOrderRequest.getOrderLinkId()).takeProfit(tradeOrderRequest.getTakeProfit()).stopLoss(tradeOrderRequest.getStopLoss()).tpTriggerBy(tradeOrderRequest.getTpTriggerBy() == null ? null : TriggerBy.LAST_PRICE.getTrigger()).slTriggerBy(tradeOrderRequest.getSlTriggerBy() == null ? null : TriggerBy.LAST_PRICE.getTrigger()).tpslMode(tradeOrderRequest.getTpslMode()).tpLimitPrice(tradeOrderRequest.getTpLimitPrice()).slLimitPrice(tradeOrderRequest.getSlLimitPrice()).build();
    }

    public PlaceOrderRequest convertTradeToPlaceOrderRequest(TradeOrderRequest tradeOrderRequest) {
        return PlaceOrderRequest.builder().category(tradeOrderRequest.getCategory() == null ? null : tradeOrderRequest.getCategory().getCategoryTypeId()).symbol(tradeOrderRequest.getSymbol()).isLeverage(tradeOrderRequest.getIsLeverage()).side(tradeOrderRequest.getSide().getTransactionSide()).orderType(tradeOrderRequest.getOrderType().getOType()).qty(tradeOrderRequest.getQty()).triggerDirection(tradeOrderRequest.getTriggerDirection()).orderFilter(tradeOrderRequest.getOrderFilter() == null ? null : tradeOrderRequest.getOrderFilter().getOrderFilterType()).triggerPrice(tradeOrderRequest.getTriggerPrice()).triggerBy(tradeOrderRequest.getTriggerBy() == null ? null : tradeOrderRequest.getTriggerBy().getTrigger()).orderIv(tradeOrderRequest.getOrderIv()).timeInForce(tradeOrderRequest.getTimeInForce() == null ? null : tradeOrderRequest.getTimeInForce().getDescription()[0]).positionIdx(tradeOrderRequest.getPositionIdx() == null ? null : Integer.valueOf(tradeOrderRequest.getPositionIdx().getIndex())).orderLinkId(tradeOrderRequest.getOrderLinkId()).takeProfit(tradeOrderRequest.getTakeProfit()).stopLoss(tradeOrderRequest.getStopLoss()).tpTriggerBy(tradeOrderRequest.getTpTriggerBy() == null ? null : TriggerBy.LAST_PRICE.getTrigger()).slTriggerBy(tradeOrderRequest.getSlTriggerBy() == null ? null : TriggerBy.LAST_PRICE.getTrigger()).reduceOnly(tradeOrderRequest.getReduceOnly()).closeOnTrigger(tradeOrderRequest.getCloseOnTrigger()).smpType(tradeOrderRequest.getSmpType() == null ? null : tradeOrderRequest.getSmpType().getDescription()).mmp(tradeOrderRequest.getMmp()).tpslMode(tradeOrderRequest.getTpslMode()).tpLimitPrice(tradeOrderRequest.getTpLimitPrice()).slLimitPrice(tradeOrderRequest.getSlLimitPrice()).tpOrderType(tradeOrderRequest.getTpOrderType() == null ? null : tradeOrderRequest.getTpOrderType().getOType()).slOrderType(tradeOrderRequest.getSlOrderType() == null ? null : tradeOrderRequest.getSlOrderType().getOType()).build();
    }

    public SetDcpRequest convertMapToDcpRequest(TradeOrderRequest tradeOrderRequest) {
        return SetDcpRequest.builder().timeWindow(tradeOrderRequest.getTimeWindow()).build();
    }

    public SetLeverageRequest mapToSetLeverageRequest(PositionDataRequest positionDataRequest) {
        return SetLeverageRequest.builder().category(positionDataRequest.getCategory().getCategoryTypeId()).symbol(positionDataRequest.getSymbol()).buyLeverage(positionDataRequest.getBuyLeverage()).sellLeverage(positionDataRequest.getSellLeverage()).build();
    }

    public SetAutoAddMarginRequest mapToSetAutoAddMarginRequest(PositionDataRequest positionDataRequest) {
        return SetAutoAddMarginRequest.builder().category(positionDataRequest.getCategory().getCategoryTypeId()).symbol(positionDataRequest.getSymbol()).autoAddMargin(positionDataRequest.getAutoAddMargin().getValue()).positionIdx(positionDataRequest.getPositionIdx().getIndex()).build();
    }

    public ModifyMarginRequest mapToModifyMarginRequest(PositionDataRequest positionDataRequest) {
        return ModifyMarginRequest.builder().category(positionDataRequest.getCategory().getCategoryTypeId()).symbol(positionDataRequest.getSymbol()).margin(positionDataRequest.getMargin()).positionIdx(positionDataRequest.getPositionIdx().getIndex()).build();
    }

    public SetRiskLimitRequest mapToSetRiskLimitRequest(PositionDataRequest positionDataRequest) {
        return SetRiskLimitRequest.builder().category(positionDataRequest.getCategory().getCategoryTypeId()).symbol(positionDataRequest.getSymbol()).riskId(positionDataRequest.getRiskId()).positionIdx(positionDataRequest.getPositionIdx().getIndex()).build();
    }

    public SetTpSlModeRequest mapToSetTpSlModeRequest(PositionDataRequest positionDataRequest) {
        return SetTpSlModeRequest.builder().category(positionDataRequest.getCategory().getCategoryTypeId()).symbol(positionDataRequest.getSymbol()).tpSlMode(positionDataRequest.getTpslMode().getDescription()).build();
    }

    public SwitchPositionModeRequest mapToSwitchPositionModeRequest(PositionDataRequest positionDataRequest) {
        return SwitchPositionModeRequest.builder().category(positionDataRequest.getCategory().getCategoryTypeId()).symbol(positionDataRequest.getSymbol()).coin(positionDataRequest.getBaseCoin()).positionMode(positionDataRequest.getPositionMode().getValue()).build();
    }

    public TradingStopRequest mapToTradingStopRequest(PositionDataRequest positionDataRequest) {
        return TradingStopRequest.builder().category(positionDataRequest.getCategory().getCategoryTypeId()).symbol(positionDataRequest.getSymbol()).takeProfit(positionDataRequest.getTakeProfit()).stopLoss(positionDataRequest.getStopLoss()).trailingStop(positionDataRequest.getTrailingStop()).tpTriggerBy(positionDataRequest.getTpTriggerBy().getTrigger()).slTriggerBy(positionDataRequest.getSlTriggerBy().getTrigger()).activePrice(positionDataRequest.getActivePrice()).tpslMode(positionDataRequest.getTpslMode().getDescription()).tpSize(positionDataRequest.getTpSize()).slSize(positionDataRequest.getSlSize()).tpLimitPrice(positionDataRequest.getTpLimitPrice()).slLimitPrice(positionDataRequest.getSlLimitPrice()).tpOrderType(positionDataRequest.getTpOrderType() == null ? null : positionDataRequest.getTpOrderType().getOType()).slOrderType(positionDataRequest.getSlOrderType() == null ? null : positionDataRequest.getSlOrderType().getOType()).positionIdx(positionDataRequest.getPositionIdx().getIndex()).build();
    }

    public SwitchMarginRequest mapToSwitchMarginRequest(PositionDataRequest positionDataRequest) {
        return SwitchMarginRequest.builder().category(positionDataRequest.getCategory().getCategoryTypeId()).symbol(positionDataRequest.getSymbol()).tradeMode(positionDataRequest.getTradeMode().getValue()).buyLeverage(positionDataRequest.getBuyLeverage()).sellLeverage(positionDataRequest.getSellLeverage()).build();
    }

    public SetMarginModeRequest mapToSetMarginModeRequest(AccountDataRequest accountDataRequest) {
        return SetMarginModeRequest.builder().setMarginMode(accountDataRequest.getSetMarginMode() == null ? null : accountDataRequest.getSetMarginMode().getDescription()).build();
    }

    public ResetMMPRequest mapToResetMarginModeRequest(AccountDataRequest accountDataRequest) {
        return ResetMMPRequest.builder().baseCoin(accountDataRequest.getBaseCoin()).build();
    }

    public SetCollateralCoinRequest mapToSetCollateralCoinRequest(AccountDataRequest accountDataRequest) {
        return SetCollateralCoinRequest.builder().coin(accountDataRequest.getCoin()).collateralSwitch(accountDataRequest.getCollateralSwitch()).build();
    }

    public SetMMPRequest mapToSetMMPRequest(AccountDataRequest accountDataRequest) {
        return SetMMPRequest.builder().baseCoin(accountDataRequest.getBaseCoin()).window(accountDataRequest.getWindow()).frozenPeriod(accountDataRequest.getFrozenPeriod()).qtyLimit(accountDataRequest.getQtyLimit()).deltaLimit(accountDataRequest.getDeltaLimit()).build();
    }

    public AssetInternalTransferRequest mapToAssetInternalTransferRequest(AssetDataRequest assetDataRequest) {
        return AssetInternalTransferRequest.builder().transferId(assetDataRequest.getTransferId() == null ? Util.generateTransferID() : assetDataRequest.getTransferId()).coin(assetDataRequest.getCoin()).amount(assetDataRequest.getAmount()).fromAccountType(assetDataRequest.getFromAccountType().getAccountTypeValue()).toAccountType(assetDataRequest.getToAccountType().getAccountTypeValue()).build();
    }

    public AssetUniversalTransferRequest mapToAssetUniversalTransferRequest(AssetDataRequest assetDataRequest) {
        return AssetUniversalTransferRequest.builder().transferId(assetDataRequest.getTransferId() == null ? Util.generateTransferID() : assetDataRequest.getTransferId()).coin(assetDataRequest.getCoin()).amount(assetDataRequest.getAmount()).fromMemberId(assetDataRequest.getFromMemberId()).toMemberId(assetDataRequest.getToMemberId()).fromAccountType(assetDataRequest.getFromAccountType().getAccountTypeValue()).toAccountType(assetDataRequest.getToAccountType().getAccountTypeValue()).build();
    }

    public SetAssetDepositAccountRequest mapToSetDepositAccountRequest(AssetDataRequest request) {
        return SetAssetDepositAccountRequest.builder().accountType(request.getAccountType() == null ? null : request.getAccountType().getAccountTypeValue()).build();
    }

    public AssetCancelWithdrawRequest mapToAssetCancelWithdrawRequest(AssetDataRequest request) {
        return AssetCancelWithdrawRequest.builder().withdrawId(request.getWithdrawID()).build();
    }

    public AssetWithdrawRequest mapToAssetWithdrawRequest(AssetDataRequest assetDataRequest) {
        return AssetWithdrawRequest.builder().coin(assetDataRequest.getCoin()).chain(assetDataRequest.getChain()).address(assetDataRequest.getAddress()).tag(assetDataRequest.getTag()).amount(assetDataRequest.getAmount()).timestamp(assetDataRequest.getTimestamp()).forceChain(assetDataRequest.getForceChain()).accountType(assetDataRequest.getAccountType() != null ? assetDataRequest.getAccountType().name() : null).feeType(assetDataRequest.getFeeType() == null ? null : Integer.valueOf(assetDataRequest.getFeeType().getValue())).build();
    }

    public UserSubMemberRequest mapToCreateSubMemberRequest(UserDataRequest subUserRequest) {
        return UserSubMemberRequest.builder().username(subUserRequest.getUsername()).password(subUserRequest.getPassword()).memberType(subUserRequest.getMemberType() == null ? MemberType.NORMAL_SUB_ACCOUNT.getValue() : subUserRequest.getMemberType().getValue()).switchOption(subUserRequest.getSwitchOption() == null ? SwitchOption.TURN_OFF.getValue() : subUserRequest.getSwitchOption().getValue()).isUta(subUserRequest.getIsUta() == null ? IsUta.CLASSIC_ACCOUNT.isValue() : subUserRequest.getIsUta().isValue()).note(subUserRequest.getNote()).build();
    }

    public CreateApiKeyRequest mapToCreateSubApiRequest(UserDataRequest subUserRequest) {
        return CreateApiKeyRequest.builder().subuid(subUserRequest.getSubuid()).note(subUserRequest.getPassword()).readOnly(subUserRequest.getReadOnlyStatus() == null ? null : Integer.valueOf(subUserRequest.getReadOnlyStatus().getValue())).ips(subUserRequest.getIps() == null ? null : Util.listToString(subUserRequest.getIps())).permissions(subUserRequest.getUserPermissionsMap() == null ? null : subUserRequest.getUserPermissionsMap().getPermissionMap()).build();
    }

    public FreezeSubUIDRquest mapToFreezeSubApiRequest(UserDataRequest request) {
        return FreezeSubUIDRquest.builder().subuid(request.getSubuid()).frozen(request.getFrozenStatus() == null ? null : Integer.valueOf(request.getFrozenStatus().getValue())).build();
    }

    public ModifyApiKeyRequest mapToModifyApiKeyRequest(UserDataRequest userDataRequest) {
        return ModifyApiKeyRequest.builder().readOnly(userDataRequest.getReadOnlyStatus() == null ? null : Integer.valueOf(userDataRequest.getReadOnlyStatus().getValue())).ips(userDataRequest.getIps() == null ? null : Util.listToString(userDataRequest.getIps())).permissionsMap(userDataRequest.getUserPermissionsMap() == null ? null : userDataRequest.getUserPermissionsMap().getPermissionMap()).build();
    }

    public ModifyApiKeyRequest mapToDeleteSubApiKeyRequest(UserDataRequest userDataRequest) {
        return ModifyApiKeyRequest.builder().apikey(userDataRequest.getApikey()).build();
    }

    public SpotLeverageTokenRequest mapToSpotLeverageTokenRequest(SpotMarginDataRequest spotMarginDataRequest) {
        return SpotLeverageTokenRequest.builder().ltCoin(spotMarginDataRequest.getLtCoin()).quantity(spotMarginDataRequest.getQuantity()).serialNo(spotMarginDataRequest.getSerialNo()).ltAmount(spotMarginDataRequest.getLtAmount()).build();
    }

    public SpotMarginTradeBorrowRequest mapToSpotMarginBorrowRequest(SpotMarginDataRequest spotMarginDataRequest) {
        return SpotMarginTradeBorrowRequest.builder().coin(spotMarginDataRequest.getCoin()).qty(spotMarginDataRequest.getQty()).build();
    }

    public SpotMarginTradeRePayRequest mapToSpotMarginRepayRequest(SpotMarginDataRequest spotMarginDataRequest) {
        return SpotMarginTradeRePayRequest.builder().coin(spotMarginDataRequest.getCoin()).qty(spotMarginDataRequest.getQty()).completeRepayment(spotMarginDataRequest.getCompleteRepayment() == null ? 0 : spotMarginDataRequest.getCompleteRepayment().getValue()).build();
    }

    public ClientLendingFundsRequest mapToC2CLendingFundRequest(LendingDataRequest lendingDataRequest) {
        return ClientLendingFundsRequest.builder().coin(lendingDataRequest.getCoin()).orderId(lendingDataRequest.getOrderId()).quantity(lendingDataRequest.getQuantity()).serialNo(lendingDataRequest.getSerialNo()).build();
    }

    public ConfirmNewRiskLimitRequest mapToConfirmNewRiskLimitRequest(PositionDataRequest positionDataRequest) {
        return ConfirmNewRiskLimitRequest.builder().category(positionDataRequest.getCategory() == null ? null : positionDataRequest.getCategory().getCategoryTypeId()).symbol(positionDataRequest.getSymbol()).build();
    }
}

