/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.account.request.AccountDataRequest;
import com.bybit.api.client.domain.account.request.BatchSetCollateralCoinRequest;
import com.bybit.api.client.domain.account.request.ResetMMPRequest;
import com.bybit.api.client.domain.account.request.SetCollateralCoinRequest;
import com.bybit.api.client.domain.account.request.SetMMPRequest;
import com.bybit.api.client.domain.account.request.SetMarginModeRequest;
import com.bybit.api.client.domain.account.request.SetSpotHedgingRequest;
import com.bybit.api.client.restApi.BybitApiAccountRestClient;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiAccountRestClientImpl
implements BybitApiAccountRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAccountRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption);
    }

    @Override
    public Object getWalletBalance(AccountDataRequest walletBalanceRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getWalletBalance(walletBalanceRequest.getAccountType().getAccountTypeValue(), walletBalanceRequest.getCoins()));
    }

    @Override
    public Object upgradeAccountToUTA() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.upgradeAccountToUTA());
    }

    @Override
    public Object getAccountBorrowHistory(AccountDataRequest borrowHistoryRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountBorrowHistory(borrowHistoryRequest.getCurrency(), borrowHistoryRequest.getStartTime(), borrowHistoryRequest.getEndTime(), borrowHistoryRequest.getLimit(), borrowHistoryRequest.getCursor()));
    }

    @Override
    public Object setAccountCollateralCoin(AccountDataRequest setCollateralCoinRequest) {
        SetCollateralCoinRequest request = this.converter.mapToSetCollateralCoinRequest(setCollateralCoinRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setAccountCollateralCoin(request));
    }

    @Override
    public Object batchSetAccountCollateralCoin(BatchSetCollateralCoinRequest batchSetCollateralCoinRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.batchSetAccountCollateralCoin(batchSetCollateralCoinRequest));
    }

    @Override
    public Object getAccountCollateralInfo(AccountDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountCollateralInfo(request.getCurrency()));
    }

    @Override
    public Object getAccountCoinGeeks(AccountDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountCoinGeeks(request.getBaseCoin()));
    }

    @Override
    public Object getAccountFreeRate(AccountDataRequest getFeeRateRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountFreeRate(getFeeRateRequest.getCategory().getCategoryTypeId(), getFeeRateRequest.getSymbol(), getFeeRateRequest.getBaseCoin()));
    }

    @Override
    public Object getAccountInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountInfo());
    }

    @Override
    public Object getTransactionLog(AccountDataRequest getTransactionLogRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getTransactionLog(getTransactionLogRequest.getAccountType() == null ? null : getTransactionLogRequest.getAccountType().getAccountTypeValue(), getTransactionLogRequest.getCategory() == null ? null : getTransactionLogRequest.getCategory().getCategoryTypeId(), getTransactionLogRequest.getCurrency(), getTransactionLogRequest.getBaseCoin(), getTransactionLogRequest.getTransactionType() == null ? null : getTransactionLogRequest.getTransactionType().getTransactionTypeId(), getTransactionLogRequest.getStartTime(), getTransactionLogRequest.getEndTime(), getTransactionLogRequest.getLimit(), getTransactionLogRequest.getCursor()));
    }

    @Override
    public Object setAccountMarginMode(AccountDataRequest setMarginMode) {
        SetMarginModeRequest request = this.converter.mapToSetMarginModeRequest(setMarginMode);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setAccountMarginMode(request));
    }

    @Override
    public Object setAccountSpotHedging(AccountDataRequest setSpotHedging) {
        SetSpotHedgingRequest request = this.converter.mapToSetSpotHedgingModeRequest(setSpotHedging);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setAccountSpotHedging(request));
    }

    @Override
    public Object modifyAccountMMP(AccountDataRequest setMMPRequest) {
        SetMMPRequest request = this.converter.mapToSetMMPRequest(setMMPRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.modifyAccountMMP(request));
    }

    @Override
    public Object resetAccountMMP(AccountDataRequest request) {
        ResetMMPRequest resetMMPRequest = this.converter.mapToResetMarginModeRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.resetAccountMMP(resetMMPRequest));
    }

    @Override
    public Object getAccountMMPState(AccountDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAccountMMPState(request.getBaseCoin()));
    }
}

