/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.websocket;

import com.bybit.api.client.constant.Util;
import com.bybit.api.client.security.HmacSHA256Signer;
import com.bybit.api.client.websocket.WebSocketHttpClientSingleton;
import com.bybit.api.client.websocket.WebsocketClient;
import com.bybit.api.client.websocket.WebsocketMessageHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketClientImpl
implements WebsocketClient {
    private static final String THREAD_PUBLIC_PING = "thread-public-ping";
    private static final String THREAD_PRIVATE_AUTH = "thread-private-auth";
    private static final String THREAD_PRIVATE_PING = "thread-private-ping";
    private static final String PING_DATA = "{\"op\":\"ping\"}";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketClientImpl.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private WebsocketMessageHandler messageHandler;
    private final WebSocketHttpClientSingleton webSocketHttpClientSingleton;
    private final String apikey;
    private final String secret;
    private final String baseUrl;
    private final Boolean debugMode;
    private final String logOption;
    private final Integer pingInterval;
    private final String maxAliveTime;
    private List<String> argNames;
    private String path;

    public WebsocketClientImpl(String apikey, String secret, String baseUrl, Integer pingInterval, String maxAliveTime, Boolean debugMode, String logOption, WebsocketMessageHandler messageHandler) {
        this.messageHandler = messageHandler;
        this.apikey = apikey;
        this.secret = secret;
        this.baseUrl = baseUrl;
        this.pingInterval = pingInterval;
        this.debugMode = debugMode;
        this.logOption = logOption;
        this.maxAliveTime = maxAliveTime;
        this.webSocketHttpClientSingleton = WebSocketHttpClientSingleton.createInstance(this.debugMode, this.logOption);
    }

    private void setupPublicChannelStream(List<String> argNames, String path) {
        this.argNames = new ArrayList<String>(argNames);
        this.path = path;
    }

    private void sendJsonMessage(WebSocket ws, Object messageObject, String messageType) {
        try {
            String json = objectMapper.writeValueAsString(messageObject);
            ws.send(json);
            LOGGER.info("Sent {}: {}", (Object)messageType, (Object)json);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Error serializing {} message: ", (Object)messageType, (Object)e);
        }
    }

    private void sendSubscribeMessage(WebSocket ws) {
        Map<String, Object> subscribeMsg = this.createSubscribeMessage();
        this.sendJsonMessage(ws, subscribeMsg, "Subscribe");
    }

    @NotNull
    private Map<String, Object> createSubscribeMessage() {
        LinkedHashMap<String, Object> subscribeMsg = new LinkedHashMap<String, Object>();
        subscribeMsg.put("op", "subscribe");
        subscribeMsg.put("req_id", Util.generateTransferID());
        subscribeMsg.put("args", this.argNames);
        return subscribeMsg;
    }

    private boolean requiresAuthentication(String path) {
        return "/v5/private".equals(path) || "/contract/private/v3".equals(path) || "/unified/private/v3".equals(path) || "/spot/private/v3".equals(path);
    }

    @NotNull
    private Thread createPingThread(WebSocket ws) {
        return new Thread(() -> {
            try {
                while (ws != null) {
                    ws.send(PING_DATA);
                    LOGGER.info(PING_DATA);
                    TimeUnit.SECONDS.sleep(this.pingInterval.intValue());
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Ping thread was interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        });
    }

    @NotNull
    private Map<String, Object> createAuthMessage() {
        long expires = Instant.now().toEpochMilli() + 10000L;
        String val = "GET/realtime" + expires;
        String signature = HmacSHA256Signer.auth(val, this.secret);
        List<String> args = List.of(this.apikey, Long.valueOf(expires), signature);
        return Map.of("req_id", Util.generateTransferID(), "op", "auth", "args", args);
    }

    private void sendAuthMessage(WebSocket ws) {
        Map<String, Object> authMessage = this.createAuthMessage();
        this.sendJsonMessage(ws, authMessage, "Auth");
    }

    @NotNull
    private Thread createAuthThread(WebSocket ws, Runnable afterAuth) {
        return new Thread(() -> {
            try {
                this.sendAuthMessage(ws);
                if (afterAuth != null) {
                    afterAuth.run();
                }
            }
            catch (Exception e) {
                LOGGER.error("Error during authentication: ", (Throwable)e);
            }
        });
    }

    @NotNull
    private String getWssUrl() {
        String wssUrl;
        Pattern pattern = Pattern.compile("(\\d+)([sm])");
        Matcher matcher = pattern.matcher(this.maxAliveTime);
        if (matcher.matches()) {
            int timeValue = Integer.parseInt(matcher.group(1));
            String timeUnit = matcher.group(2);
            boolean isTimeValid = this.isTimeValid(timeUnit, timeValue);
            wssUrl = isTimeValid && this.requiresAuthentication(this.path) ? this.baseUrl + this.path + "?max_alive_time=" + this.maxAliveTime : this.baseUrl + this.path;
        } else {
            wssUrl = this.baseUrl + this.path;
        }
        return wssUrl;
    }

    private boolean isTimeValid(String timeUnit, int timeValue) {
        int minValue = "s".equals(timeUnit) ? 30 : 1;
        int maxValue = "s".equals(timeUnit) ? 600 : 10;
        return timeValue >= minValue && timeValue <= maxValue;
    }

    @NotNull
    private WebSocketListener createWebSocketListener() {
        return new WebSocketListener(){

            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                WebsocketClientImpl.this.onClose(code, reason);
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                WebsocketClientImpl.this.onError(t);
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                try {
                    WebsocketClientImpl.this.onMessage(text);
                }
                catch (Exception e) {
                    WebsocketClientImpl.this.onError(e);
                }
            }

            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                WebsocketClientImpl.this.onOpen(webSocket);
            }
        };
    }

    @Override
    public void setMessageHandler(WebsocketMessageHandler handler) {
        this.messageHandler = handler;
    }

    @Override
    public void onMessage(String msg) throws JsonProcessingException {
        if (this.messageHandler != null) {
            this.messageHandler.handleMessage(msg);
        } else {
            LOGGER.info(msg);
        }
    }

    @Override
    public void onError(Throwable t) {
        LOGGER.error(t.getMessage());
    }

    @Override
    public void onClose(int code, String reason) {
        LOGGER.warn("websocket connection is about to close: " + reason);
    }

    @Override
    public void onOpen(WebSocket ws) {
        Thread pingThread = this.createPingThread(ws);
        pingThread.setName(THREAD_PUBLIC_PING);
        pingThread.start();
        if (this.requiresAuthentication(this.path)) {
            Thread authThread = this.createAuthThread(ws, () -> this.sendSubscribeMessage(ws));
            authThread.start();
            pingThread.setName(THREAD_PRIVATE_PING);
        } else {
            this.sendSubscribeMessage(ws);
        }
    }

    @Override
    public void connect() {
        String wssUrl = this.getWssUrl();
        LOGGER.info(wssUrl);
        this.webSocketHttpClientSingleton.createWebSocket(wssUrl, this.createWebSocketListener());
    }

    @Override
    public void getPublicChannelStream(List<String> argNames, String path) {
        this.setupPublicChannelStream(argNames, path);
        this.connect();
    }

    @Override
    public void getPrivateChannelStream(List<String> argNames, String path) {
        this.setupPublicChannelStream(argNames, path);
        this.connect();
    }

    public WebsocketMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public WebSocketHttpClientSingleton getWebSocketHttpClientSingleton() {
        return this.webSocketHttpClientSingleton;
    }

    public String getApikey() {
        return this.apikey;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public Boolean getDebugMode() {
        return this.debugMode;
    }

    public String getLogOption() {
        return this.logOption;
    }

    public Integer getPingInterval() {
        return this.pingInterval;
    }

    public String getMaxAliveTime() {
        return this.maxAliveTime;
    }

    public List<String> getArgNames() {
        return this.argNames;
    }

    public String getPath() {
        return this.path;
    }
}

