/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.domain.institution;

import com.bybit.api.client.domain.broker.BusinessType;
import com.bybit.api.client.domain.institution.LendingOrderType;
import com.bybit.api.client.domain.institution.OperateType;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LendingDataRequest {
    private final String productId;
    private final String orderId;
    private final BusinessType bizType;
    private final Long startTime;
    private final Long endTime;
    private final Integer limit;
    private final String cursor;
    private final String coin;
    private final LendingOrderType lendingOrderType;
    private final String quantity;
    private final String serialNo;
    private final String uid;
    private final OperateType operate;

    LendingDataRequest(String productId, String orderId, BusinessType bizType, Long startTime, Long endTime, Integer limit, String cursor, String coin, LendingOrderType lendingOrderType, String quantity, String serialNo, String uid, OperateType operate) {
        this.productId = productId;
        this.orderId = orderId;
        this.bizType = bizType;
        this.startTime = startTime;
        this.endTime = endTime;
        this.limit = limit;
        this.cursor = cursor;
        this.coin = coin;
        this.lendingOrderType = lendingOrderType;
        this.quantity = quantity;
        this.serialNo = serialNo;
        this.uid = uid;
        this.operate = operate;
    }

    public static LendingDataRequestBuilder builder() {
        return new LendingDataRequestBuilder();
    }

    public String getProductId() {
        return this.productId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public BusinessType getBizType() {
        return this.bizType;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getCursor() {
        return this.cursor;
    }

    public String getCoin() {
        return this.coin;
    }

    public LendingOrderType getLendingOrderType() {
        return this.lendingOrderType;
    }

    public String getQuantity() {
        return this.quantity;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public String getUid() {
        return this.uid;
    }

    public OperateType getOperate() {
        return this.operate;
    }

    public String toString() {
        return "LendingDataRequest(productId=" + this.getProductId() + ", orderId=" + this.getOrderId() + ", bizType=" + this.getBizType() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", limit=" + this.getLimit() + ", cursor=" + this.getCursor() + ", coin=" + this.getCoin() + ", lendingOrderType=" + this.getLendingOrderType() + ", quantity=" + this.getQuantity() + ", serialNo=" + this.getSerialNo() + ", uid=" + this.getUid() + ", operate=" + this.getOperate() + ")";
    }

    public static class LendingDataRequestBuilder {
        private String productId;
        private String orderId;
        private BusinessType bizType;
        private Long startTime;
        private Long endTime;
        private Integer limit;
        private String cursor;
        private String coin;
        private LendingOrderType lendingOrderType;
        private String quantity;
        private String serialNo;
        private String uid;
        private OperateType operate;

        LendingDataRequestBuilder() {
        }

        public LendingDataRequestBuilder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public LendingDataRequestBuilder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public LendingDataRequestBuilder bizType(BusinessType bizType) {
            this.bizType = bizType;
            return this;
        }

        public LendingDataRequestBuilder startTime(Long startTime) {
            this.startTime = startTime;
            return this;
        }

        public LendingDataRequestBuilder endTime(Long endTime) {
            this.endTime = endTime;
            return this;
        }

        public LendingDataRequestBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public LendingDataRequestBuilder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public LendingDataRequestBuilder coin(String coin) {
            this.coin = coin;
            return this;
        }

        public LendingDataRequestBuilder lendingOrderType(LendingOrderType lendingOrderType) {
            this.lendingOrderType = lendingOrderType;
            return this;
        }

        public LendingDataRequestBuilder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        public LendingDataRequestBuilder serialNo(String serialNo) {
            this.serialNo = serialNo;
            return this;
        }

        public LendingDataRequestBuilder uid(String uid) {
            this.uid = uid;
            return this;
        }

        public LendingDataRequestBuilder operate(OperateType operate) {
            this.operate = operate;
            return this;
        }

        public LendingDataRequest build() {
            return new LendingDataRequest(this.productId, this.orderId, this.bizType, this.startTime, this.endTime, this.limit, this.cursor, this.coin, this.lendingOrderType, this.quantity, this.serialNo, this.uid, this.operate);
        }

        public String toString() {
            return "LendingDataRequest.LendingDataRequestBuilder(productId=" + this.productId + ", orderId=" + this.orderId + ", bizType=" + this.bizType + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", limit=" + this.limit + ", cursor=" + this.cursor + ", coin=" + this.coin + ", lendingOrderType=" + this.lendingOrderType + ", quantity=" + this.quantity + ", serialNo=" + this.serialNo + ", uid=" + this.uid + ", operate=" + this.operate + ")";
        }
    }
}

