/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.spot.SpotMarginDataRequest;
import com.bybit.api.client.domain.spot.leverageToken.SpotLeverageTokenRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeBorrowRequest;
import com.bybit.api.client.domain.spot.marginTrade.SpotMarginTradeRePayRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.restApi.BybitApiAsyncSpotMarginRestClient;
import com.bybit.api.client.restApi.BybitApiCallback;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;
import java.util.HashMap;

public class BybitApiAsyncSpotMarginRestClientImpl
implements BybitApiAsyncSpotMarginRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiAsyncSpotMarginRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public void getSpotLeverageTokenInfo(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getSpotLeverageTokenInfo(spotMarginDataRequest.getLtCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getSpotLeverageTokenMarket(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getSpotLeverageTokenMarket(spotMarginDataRequest.getLtCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void purchaseSpotLeverageToken(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        SpotLeverageTokenRequest spotLeverageTokenRequest = this.converter.mapToSpotLeverageTokenRequest(spotMarginDataRequest);
        this.bybitApiService.purchaseSpotLeverageToken(spotLeverageTokenRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void redeemSpotLeverageToken(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        SpotLeverageTokenRequest spotLeverageTokenRequest = this.converter.mapToSpotLeverageTokenRequest(spotMarginDataRequest);
        this.bybitApiService.redeemSpotLeverageToken(spotLeverageTokenRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getSpotLeverageRecords(SpotMarginDataRequest spotLeverageOrdersRecordRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getSpotLeverageRecords(spotLeverageOrdersRecordRequest.getLtCoin(), spotLeverageOrdersRecordRequest.getOrderId(), spotLeverageOrdersRecordRequest.getStartTime(), spotLeverageOrdersRecordRequest.getEndTime(), spotLeverageOrdersRecordRequest.getLimit(), spotLeverageOrdersRecordRequest.getLtOrderType(), spotLeverageOrdersRecordRequest.getSerialNo()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getUtaVipSpotMarginTradeData(SpotMarginDataRequest utaMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getUtaVipSpotMarginTradeData(utaMarginDataRequest.getVipLevel() == null ? null : utaMarginDataRequest.getVipLevel().getLevel(), utaMarginDataRequest.getCurrency()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setUTASpotMarginTrade(String mode, BybitApiCallback<Object> callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spotMarginMode", mode);
        this.bybitApiService.setUTASpotMarginTrade(map).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setUTASpotMarginTradeLeverage(String leverage, BybitApiCallback<Object> callback) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("leverage", leverage);
        this.bybitApiService.setUTASpotMarginTradeLeverage(map).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getUTASpotMarginTradeLeverageState(BybitApiCallback<Object> callback) {
        this.bybitApiService.getUTASpotMarginTradeLeverageState().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void getNormalVipSpotMarginTradeData(SpotMarginDataRequest normalMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalVipSpotMarginTradeData(normalMarginDataRequest.getVipLevel() == null ? null : normalMarginDataRequest.getVipLevel().getLevel(), normalMarginDataRequest.getCurrency()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void getNormalSpotMarginTradeCoinInfo(SpotMarginDataRequest normalMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalSpotMarginTradeCoinInfo(normalMarginDataRequest.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void getNormalSpotMarginTradeBorrowCoinInfo(SpotMarginDataRequest normalMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalSpotMarginTradeBorrowCoinInfo(normalMarginDataRequest.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void getNormalSpotMarginTradeInterestQuota(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalSpotMarginTradeInterestQuota(spotMarginDataRequest.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void getNormalSpotMarginTradeAccountInfo(BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalSpotMarginTradeAccountInfo().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void setNormalSpotToggleMarginTrade(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        int switchStatus = spotMarginDataRequest.getSwitchStatus() == null ? 0 : spotMarginDataRequest.getSwitchStatus().getValue();
        this.bybitApiService.setNormalSpotToggleMarginTrade(switchStatus).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void loanNormalSpotMarginTrade(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        SpotMarginTradeBorrowRequest spotMarginTradeBorrowRequest = this.converter.mapToSpotMarginBorrowRequest(spotMarginDataRequest);
        this.bybitApiService.loanNormalSpotMarginTrade(spotMarginTradeBorrowRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void repayNormalSpotMarginTrade(SpotMarginDataRequest spotMarginDataRequest, BybitApiCallback<Object> callback) {
        SpotMarginTradeRePayRequest spotMarginTradeRePayRequest = this.converter.mapToSpotMarginRepayRequest(spotMarginDataRequest);
        this.bybitApiService.repayNormalSpotMarginTrade(spotMarginTradeRePayRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void getNormalSpotMarginTradeBorrowOrders(SpotMarginDataRequest spotMarginTradeBorrowOrdersRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalMarginTradeBorrowOrders(spotMarginTradeBorrowOrdersRequest.getStartTime(), spotMarginTradeBorrowOrdersRequest.getEndTime(), spotMarginTradeBorrowOrdersRequest.getCoin(), spotMarginTradeBorrowOrdersRequest.getBorrowStatus() == null ? 0 : spotMarginTradeBorrowOrdersRequest.getBorrowStatus().getValue(), spotMarginTradeBorrowOrdersRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    @Deprecated
    public void getNormalSpotMarginTradeRepayOrders(SpotMarginDataRequest spotMarginTradeRepayOrdersRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getNormalMarginTradeRepayOrders(spotMarginTradeRepayOrdersRequest.getStartTime(), spotMarginTradeRepayOrdersRequest.getEndTime(), spotMarginTradeRepayOrdersRequest.getCoin(), spotMarginTradeRepayOrdersRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

