/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.utils;

import io.github.zero88.utils.Strings;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.TimeZone;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTimes {
    private static final Logger logger = LoggerFactory.getLogger(DateTimes.class);

    public static boolean isRelatedToDateTime(@NonNull Class cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return TemporalAccessor.class.isAssignableFrom(cls) || java.util.Date.class.isAssignableFrom(cls) || Calendar.class.isAssignableFrom(cls) || TimeZone.class.isAssignableFrom(cls);
    }

    public static LocalDateTime nowUTC() {
        return DateTimes.fromUTC(Instant.now());
    }

    public static LocalDateTime fromUTC(@NonNull Instant instant) {
        if (instant == null) {
            throw new NullPointerException("instant is marked non-null but is null");
        }
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public static ZonedDateTime toUTC(@NonNull java.util.Date date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return DateTimes.toUTC(date.toInstant());
    }

    public static ZonedDateTime toUTC(@NonNull Instant date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return DateTimes.toUTC(date.atZone(ZoneId.systemDefault()));
    }

    public static ZonedDateTime toUTC(@NonNull LocalDateTime time) {
        if (time == null) {
            throw new NullPointerException("time is marked non-null but is null");
        }
        return DateTimes.toUTC(time, ZoneId.systemDefault());
    }

    public static ZonedDateTime toUTC(@NonNull LocalDateTime time, @NonNull ZoneId zoneId) {
        if (time == null) {
            throw new NullPointerException("time is marked non-null but is null");
        }
        if (zoneId == null) {
            throw new NullPointerException("zoneId is marked non-null but is null");
        }
        return DateTimes.toUTC(time.atZone(zoneId));
    }

    public static ZonedDateTime toUTC(@NonNull ZonedDateTime dateTime) {
        if (dateTime == null) {
            throw new NullPointerException("dateTime is marked non-null but is null");
        }
        return DateTimes.toZone(dateTime, ZoneOffset.UTC);
    }

    public static ZonedDateTime toZone(@NonNull ZonedDateTime dateTime, @NonNull ZoneId toZone) {
        if (dateTime == null) {
            throw new NullPointerException("dateTime is marked non-null but is null");
        }
        if (toZone == null) {
            throw new NullPointerException("toZone is marked non-null but is null");
        }
        return dateTime.withZoneSameInstant(toZone);
    }

    public static OffsetDateTime now() {
        return DateTimes.from(Instant.now());
    }

    public static long nowMilli() {
        return Instant.now().toEpochMilli();
    }

    public static OffsetDateTime from(@NonNull Instant instant) {
        if (instant == null) {
            throw new NullPointerException("instant is marked non-null but is null");
        }
        return OffsetDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    private DateTimes() {
    }

    public static class Iso8601Formatter {
        public static String formatDate(@NonNull ZonedDateTime zonedDate) {
            if (zonedDate == null) {
                throw new NullPointerException("zonedDate is marked non-null but is null");
            }
            return zonedDate.format(DateTimeFormatter.ISO_OFFSET_DATE);
        }

        public static String formatDate(@NonNull OffsetDateTime offsetDate) {
            if (offsetDate == null) {
                throw new NullPointerException("offsetDate is marked non-null but is null");
            }
            return offsetDate.format(DateTimeFormatter.ISO_OFFSET_DATE);
        }

        public static String formatTime(@NonNull OffsetTime value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return DateTimeFormatter.ISO_TIME.format(value);
        }

        public static String format(@NonNull ZonedDateTime zonedDateTime) {
            if (zonedDateTime == null) {
                throw new NullPointerException("zonedDateTime is marked non-null but is null");
            }
            return zonedDateTime.format(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }

        public static String format(@NonNull OffsetDateTime offsetDateTime) {
            if (offsetDateTime == null) {
                throw new NullPointerException("offsetDateTime is marked non-null but is null");
            }
            return offsetDateTime.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
    }

    public static class Iso8601Parser {
        public static Instant parse(@NonNull String datetime) {
            if (datetime == null) {
                throw new NullPointerException("datetime is marked non-null but is null");
            }
            return Instant.from(Iso8601Parser.parseFromISO8601(datetime, DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }

        public static ZonedDateTime parseZonedDateTime(@NonNull String datetime) {
            if (datetime == null) {
                throw new NullPointerException("datetime is marked non-null but is null");
            }
            return ZonedDateTime.from(Iso8601Parser.parseFromISO8601(datetime, DateTimeFormatter.ISO_ZONED_DATE_TIME));
        }

        public static OffsetDateTime parseDateTime(@NonNull String datetime) {
            if (datetime == null) {
                throw new NullPointerException("datetime is marked non-null but is null");
            }
            return OffsetDateTime.from(Iso8601Parser.parseFromISO8601(datetime, DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }

        public static OffsetDateTime parseDate(@NonNull String date) {
            if (date == null) {
                throw new NullPointerException("date is marked non-null but is null");
            }
            return OffsetDateTime.from(Iso8601Parser.parseFromISO8601(date, DateTimeFormatter.ISO_OFFSET_DATE));
        }

        public static OffsetTime parseTime(@NonNull String time) {
            if (time == null) {
                throw new NullPointerException("time is marked non-null but is null");
            }
            return OffsetTime.from(Iso8601Parser.parseFromISO8601(time, DateTimeFormatter.ISO_TIME));
        }

        private static TemporalAccessor parseFromISO8601(String datetime, @NonNull DateTimeFormatter formatter) {
            if (formatter == null) {
                throw new NullPointerException("formatter is marked non-null but is null");
            }
            try {
                return formatter.parse(Strings.requireNotBlank(datetime));
            }
            catch (DateTimeParseException e) {
                logger.debug("Invalid date: " + datetime, (Throwable)e);
                throw new IllegalArgumentException("Invalid date", e);
            }
        }

        public static Object parse(@NonNull Class<?> cls, String value) {
            if (cls == null) {
                throw new NullPointerException("cls is marked non-null but is null");
            }
            if (Strings.isBlank(value)) {
                return null;
            }
            if (!DateTimes.isRelatedToDateTime(cls)) {
                return value;
            }
            if (Instant.class.isAssignableFrom(cls)) {
                return Iso8601Parser.parse(value);
            }
            if (OffsetDateTime.class.isAssignableFrom(cls)) {
                return Iso8601Parser.parseDateTime(value);
            }
            if (ZonedDateTime.class.isAssignableFrom(cls)) {
                return Iso8601Parser.parseZonedDateTime(value);
            }
            if (OffsetTime.class.isAssignableFrom(cls)) {
                return Iso8601Parser.parseZonedDateTime(value);
            }
            if (Date.class.isAssignableFrom(cls)) {
                return new Date(Iso8601Parser.parse(value).toEpochMilli());
            }
            if (Time.class.isAssignableFrom(cls)) {
                return Time.valueOf(value);
            }
            if (Timestamp.class.isAssignableFrom(cls)) {
                return new Timestamp(Iso8601Parser.parse(value).toEpochMilli());
            }
            if (java.util.Date.class.isAssignableFrom(cls)) {
                return java.util.Date.from(Iso8601Parser.parse(value));
            }
            return value;
        }
    }
}

