/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.utils;

import java.nio.file.Path;
import java.nio.file.Paths;

public interface OSHelper {
    public static final String OS = System.getProperty("os.name").toLowerCase();

    public static boolean isWin() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static Path getAbsolutePathByOs(String path) {
        if (OSHelper.isWin()) {
            return Paths.get("C:", path);
        }
        return Paths.get(path, new String[0]);
    }
}

