/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.utils;

import io.github.zero88.repl.Reflections;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ServiceHelper {
    private ServiceHelper() {
    }

    @Nullable
    public static <T> T loadFactory(@NotNull Class<T> clazz) {
        return (T)Optional.ofNullable(ServiceHelper.loadFactory(clazz, Reflections.contextClassLoader())).orElseGet(() -> ServiceHelper.loadFactory(clazz, Reflections.staticClassLoader()));
    }

    @Nullable
    public static <T> T loadFactory(@NotNull Class<T> clazz, @NotNull ClassLoader classLoader) {
        ServiceLoader<T> factories = ServiceLoader.load(clazz, classLoader);
        return factories.iterator().hasNext() ? (T)factories.iterator().next() : null;
    }

    public static <T> T loadFactoryOrThrow(@NotNull Class<T> clazz) {
        T factory = ServiceHelper.loadFactory(clazz);
        if (factory == null) {
            throw new IllegalStateException("Cannot find META-INF/services/" + clazz.getName() + " on classpath");
        }
        return factory;
    }

    public static <T> Collection<T> loadFactories(Class<T> clazz) {
        return ServiceHelper.loadFactories(clazz, null);
    }

    public static <T> Collection<T> loadFactories(Class<T> clazz, ClassLoader classLoader) {
        ServiceLoader<T> factories;
        ServiceLoader<T> serviceLoader = factories = classLoader != null ? ServiceLoader.load(clazz, classLoader) : ServiceLoader.load(clazz);
        if (factories.iterator().hasNext()) {
            return ServiceHelper.collect(factories);
        }
        factories = ServiceLoader.load(clazz, Reflections.staticClassLoader());
        if (factories.iterator().hasNext()) {
            return ServiceHelper.collect(factories);
        }
        return Collections.emptyList();
    }

    private static <T> Collection<T> collect(ServiceLoader<T> factories) {
        ArrayList list = new ArrayList();
        factories.iterator().forEachRemaining(list::add);
        return Collections.unmodifiableList(list);
    }
}

