/*
 * Decompiled with CFR 0.152.
 */
package com.zoowayss.requests;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.zoowayss.requests.ProxyConfig;
import com.zoowayss.requests.RequestBuilder;
import com.zoowayss.requests.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class Requests {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static Response get(String url) throws IOException {
        return Requests.builder(url).method("GET").execute();
    }

    public static RequestBuilder builder(String url) {
        return new RequestBuilder(url);
    }

    public static Response get(String url, Map<String, String> headers) throws IOException {
        return Requests.builder(url).method("GET").headers(headers).execute();
    }

    public static Response get(String url, Map<String, String> headers, ProxyConfig proxy) throws IOException {
        return Requests.builder(url).method("GET").headers(headers).proxy(proxy).execute();
    }

    public static Response get(String url, Map<String, String> headers, int connectTimeout, int readTimeout) throws IOException {
        return Requests.builder(url).method("GET").headers(headers).connectTimeout(connectTimeout).readTimeout(readTimeout).execute();
    }

    public static Response getStream(String url) throws IOException {
        return Requests.builder(url).method("GET").stream().execute();
    }

    public static Response getStream(String url, Map<String, String> headers) throws IOException {
        return Requests.builder(url).method("GET").headers(headers).stream().execute();
    }

    public static Response getStream(String url, Map<String, String> headers, ProxyConfig proxy) throws IOException {
        return Requests.builder(url).method("GET").headers(headers).proxy(proxy).stream().execute();
    }

    public static Response getStream(String url, Map<String, String> headers, int connectTimeout, int readTimeout) throws IOException {
        return Requests.builder(url).method("GET").headers(headers).connectTimeout(connectTimeout).readTimeout(readTimeout).stream().execute();
    }

    public static Response post(String url, Object data) throws IOException {
        return Requests.builder(url).method("POST").data(data).execute();
    }

    public static Response post(String url, Map<String, String> headers) throws IOException {
        return Requests.builder(url).method("POST").headers(headers).execute();
    }

    public static Response post(String url, Map<String, String> headers, Object data, Object json) throws IOException {
        return Requests.builder(url).method("POST").headers(headers).data(data).json(json).execute();
    }

    public static Response post(String url, Map<String, String> headers, Object data, Object json, ProxyConfig proxy) throws IOException {
        return Requests.builder(url).method("POST").headers(headers).data(data).json(json).proxy(proxy).execute();
    }

    public static Response post(String url, Map<String, String> headers, Object data, Object json, int connectTimeout, int readTimeout) throws IOException {
        return Requests.builder(url).method("POST").headers(headers).data(data).json(json).connectTimeout(connectTimeout).readTimeout(readTimeout).execute();
    }

    public static Response postStream(String url) throws IOException {
        return Requests.builder(url).method("POST").stream().execute();
    }

    public static Response postStream(String url, Map<String, String> headers) throws IOException {
        return Requests.builder(url).method("POST").headers(headers).stream().execute();
    }

    public static Response postStream(String url, Map<String, String> headers, Object data, Object json) throws IOException {
        return Requests.builder(url).method("POST").headers(headers).data(data).json(json).stream().execute();
    }

    public static Response postStream(String url, Map<String, String> headers, Object data, Object json, ProxyConfig proxy) throws IOException {
        return Requests.builder(url).method("POST").headers(headers).data(data).json(json).proxy(proxy).stream().execute();
    }

    public static Response postStream(String url, Map<String, String> headers, Object data, Object json, int connectTimeout, int readTimeout) throws IOException {
        return Requests.builder(url).method("POST").headers(headers).data(data).json(json).connectTimeout(connectTimeout).readTimeout(readTimeout).stream().execute();
    }

    public static Response put(String url, Object data) throws IOException {
        return Requests.builder(url).method("PUT").data(data).execute();
    }

    public static Response put(String url, Map<String, String> headers, Object data, Object json) throws IOException {
        return Requests.builder(url).method("PUT").headers(headers).data(data).json(json).execute();
    }

    public static Response put(String url, Map<String, String> headers, Object data, Object json, ProxyConfig proxy) throws IOException {
        return Requests.builder(url).method("PUT").headers(headers).data(data).json(json).proxy(proxy).execute();
    }

    public static Response delete(String url) throws IOException {
        return Requests.builder(url).method("DELETE").execute();
    }

    public static Response delete(String url, Map<String, String> headers) throws IOException {
        return Requests.builder(url).method("DELETE").headers(headers).execute();
    }

    public static Response delete(String url, Map<String, String> headers, ProxyConfig proxy) throws IOException {
        return Requests.builder(url).method("DELETE").headers(headers).proxy(proxy).execute();
    }

    public static RequestBody buildRequestBody(Object data, Object json) throws IOException {
        if (json != null) {
            return new RequestBody(objectMapper.writeValueAsString(json), "application/json");
        }
        if (data != null) {
            if (data instanceof Map) {
                Map dataMap = (Map)data;
                String formData = dataMap.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining("&"));
                return new RequestBody(formData, "application/x-www-form-urlencoded");
            }
            return new RequestBody(objectMapper.writeValueAsString(data), "application/json");
        }
        return null;
    }

    static Response request(String url, String method, Map<String, String> headers, RequestBody body, ProxyConfig proxyConfig, boolean streamMode, int connectTimeout, int readTimeout) throws IOException {
        int statusCode;
        HttpURLConnection conn;
        URL urlObj = new URL(url);
        if (proxyConfig != null) {
            conn = (HttpURLConnection)urlObj.openConnection(proxyConfig.toProxy());
            if (proxyConfig.hasCredentials()) {
                String auth = proxyConfig.getUsername() + ":" + proxyConfig.getPassword();
                String string = Base64.getEncoder().encodeToString(auth.getBytes(StandardCharsets.UTF_8));
                conn.setRequestProperty("Proxy-Authorization", "Basic " + string);
            }
        } else {
            conn = (HttpURLConnection)urlObj.openConnection();
        }
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Connection", "keep-alive");
        conn.setRequestProperty("User-Agent", "Java-Requests/1.0.0");
        if (headers != null) {
            for (Map.Entry entry : headers.entrySet()) {
                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (body != null) {
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", body.contentType);
            try (OutputStream os = conn.getOutputStream();){
                byte[] byArray = body.content.getBytes(StandardCharsets.UTF_8);
                os.write(byArray, 0, byArray.length);
            }
        }
        InputStream inputStream = (statusCode = conn.getResponseCode()) >= 400 ? conn.getErrorStream() : conn.getInputStream();
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        conn.getHeaderFields().forEach((key, value) -> {
            if (key != null) {
                responseHeaders.put((String)key, String.join((CharSequence)", ", value));
            }
        });
        if (streamMode) {
            return new Response(statusCode, null, responseHeaders, inputStream);
        }
        String responseBody = new BufferedReader(new InputStreamReader(inputStream)).lines().collect(Collectors.joining("\n"));
        inputStream.close();
        conn.disconnect();
        return new Response(statusCode, responseBody, responseHeaders);
    }

    static class RequestBody {
        String content;
        String contentType;

        RequestBody(String content, String contentType) {
            this.content = content;
            this.contentType = contentType;
        }
    }
}

