/*
 * Decompiled with CFR 0.152.
 */
package com.zoowayss.requests;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Response
implements Closeable {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final int statusCode;
    private final String text;
    private final Map<String, String> headers;
    private final InputStream inputStream;
    private boolean streamMode;

    public Response(int statusCode, String text, Map<String, String> headers) {
        this(statusCode, text, headers, null);
    }

    public Response(int statusCode, String text, Map<String, String> headers, InputStream inputStream) {
        this.statusCode = statusCode;
        this.text = text;
        this.headers = headers;
        this.inputStream = inputStream;
        this.streamMode = inputStream != null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getText() {
        return this.text;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public <T> T getJson(Class<T> clazz) throws IOException {
        return (T)objectMapper.readValue(this.text, clazz);
    }

    public Map<String, Object> getJson() throws IOException {
        return (Map)objectMapper.readValue(this.text, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public <T> List<T> jsonList(Class<T> elementClass) throws IOException {
        CollectionType type = TypeFactory.defaultInstance().constructCollectionType(List.class, elementClass);
        return (List)objectMapper.readValue(this.text, (JavaType)type);
    }

    public <T> T getJson(TypeReference<T> typeReference) throws IOException {
        return (T)objectMapper.readValue(this.text, typeReference);
    }

    public boolean hasContent() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean isOk() {
        return this.statusCode >= 200 && this.statusCode < 300;
    }

    public void stream(Consumer<byte[]> consumer) throws IOException {
        int bytesRead;
        if (!this.streamMode || this.inputStream == null) {
            throw new IllegalStateException("Response is not in stream mode");
        }
        byte[] buffer = new byte[8192];
        while ((bytesRead = this.inputStream.read(buffer)) != -1) {
            byte[] data = new byte[bytesRead];
            System.arraycopy(buffer, 0, data, 0, bytesRead);
            consumer.accept(data);
        }
    }

    public void streamLines(Consumer<String> consumer) throws IOException {
        if (!this.streamMode || this.inputStream == null) {
            throw new IllegalStateException("Response is not in stream mode");
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                consumer.accept(line);
            }
        }
    }

    public void saveToFile(String filePath) throws IOException {
        if (!this.streamMode || this.inputStream == null) {
            throw new IllegalStateException("Response is not in stream mode");
        }
        try (FileOutputStream outputStream = new FileOutputStream(filePath);){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = this.inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
        }
    }

    public InputStream getInputStream() {
        if (!this.streamMode || this.inputStream == null) {
            throw new IllegalStateException("Response is not in stream mode");
        }
        return this.inputStream;
    }

    public boolean isStreamMode() {
        return this.streamMode;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    public String toString() {
        return String.format("<Response [%d]>", this.statusCode);
    }
}

