/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.intercom.api.AdminCollection;
import io.intercom.api.AuthorizationException;
import io.intercom.api.ClientException;
import io.intercom.api.DataResource;
import io.intercom.api.InvalidException;
import io.intercom.api.RateLimitException;
import io.intercom.api.Replier;
import io.intercom.api.ServerException;
import io.intercom.api.TypedData;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Admin
extends TypedData
implements Replier {
    private static final Map<String, String> SENTINEL = Maps.newHashMap();
    public static final String TYPE_NOBODY = "nobody_admin";
    @JsonProperty(value="type")
    private final String type = "admin";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="updated_at")
    private long updatedAt;
    @JsonProperty(value="open")
    private long open;
    @JsonProperty(value="closed")
    private long closed;

    static AdminCollection list(Map<String, String> params) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.list(params, "admins", AdminCollection.class);
    }

    public static AdminCollection list() throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return DataResource.list(SENTINEL, "admins", AdminCollection.class);
    }

    @Override
    public String getReplyType() {
        return this.getType() + "_reply";
    }

    public String getType() {
        return "admin";
    }

    @JsonIgnore
    public boolean isNobody() {
        return TYPE_NOBODY.equalsIgnoreCase(this.getType());
    }

    @JsonIgnore
    public boolean isSomebody() {
        return !this.isNobody() && this.getId() != null;
    }

    public String getId() {
        return this.id;
    }

    public Admin setId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public long getOpen() {
        return this.open;
    }

    public long getClosed() {
        return this.closed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Admin admin = (Admin)o;
        if (this.closed != admin.closed) {
            return false;
        }
        if (this.createdAt != admin.createdAt) {
            return false;
        }
        if (this.open != admin.open) {
            return false;
        }
        if (this.updatedAt != admin.updatedAt) {
            return false;
        }
        if (this.email != null ? !this.email.equals(admin.email) : admin.email != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(admin.id) : admin.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(admin.name) : admin.name != null) {
            return false;
        }
        return "admin".equals(admin.type);
    }

    public int hashCode() {
        int result = "admin".hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (int)(this.open ^ this.open >>> 32);
        result = 31 * result + (int)(this.closed ^ this.closed >>> 32);
        return result;
    }

    public String toString() {
        return "Admin{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + "} " + super.toString();
    }
}

