/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.google.common.collect.Lists;
import io.intercom.api.InvalidException;
import java.io.Serializable;
import java.util.ArrayList;

public class CustomAttribute<T> {
    private static final ArrayList<? extends Class<? extends Serializable>> CLASSES = Lists.newArrayList((Object[])new Class[]{String.class, Long.class, Float.class, Double.class, Boolean.class, Integer.class});
    private String name;
    private T value;
    private Class<T> clazz;

    public static StringAttribute newStringAttribute(String name, String value) {
        return new StringAttribute(name, value);
    }

    public static BooleanAttribute newBooleanAttribute(String name, boolean value) {
        return new BooleanAttribute(name, value);
    }

    public static DoubleAttribute newDoubleAttribute(String name, double value) {
        return new DoubleAttribute(name, value);
    }

    public static LongAttribute newLongAttribute(String name, long value) {
        return new LongAttribute(name, value);
    }

    public static IntegerAttribute newIntegerAttribute(String name, int value) {
        return new IntegerAttribute(name, value);
    }

    public static FloatAttribute newFloatAttribute(String name, float value) {
        return new FloatAttribute(name, value);
    }

    public CustomAttribute(String name, T value, Class<T> clazz) {
        if (!CLASSES.contains(clazz)) {
            throw new InvalidException(String.format("cannot accept class type [%s] for custom attribute", clazz.getName()));
        }
        this.name = name;
        this.value = value;
        this.clazz = clazz;
    }

    public Class<T> getValueClass() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public <C> C as(Class<C> c) {
        return (C)this.getValue();
    }

    public long longValue() {
        return this.as(Long.class);
    }

    public String textValue() {
        return this.as(String.class);
    }

    public boolean booleanValue() {
        return this.as(Boolean.class);
    }

    public float floatValue() {
        return this.as(Float.class).floatValue();
    }

    public double doubleValue() {
        return this.as(Double.class);
    }

    public int integerValue() {
        return this.as(Integer.class);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomAttribute that = (CustomAttribute)o;
        if (this.clazz != null ? !this.clazz.equals(that.clazz) : that.clazz != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public String toString() {
        return "CustomAttribute{name='" + this.name + '\'' + ", value=" + this.value + ", clazz=" + this.clazz + '}';
    }

    public static class LongAttribute
    extends CustomAttribute<Long> {
        public LongAttribute(String name, long value, Class<Long> clazz) {
            super(name, value, clazz);
        }

        public LongAttribute(String name, long value) {
            super(name, value, Long.class);
        }
    }

    public static class IntegerAttribute
    extends CustomAttribute<Integer> {
        private IntegerAttribute(String name, int value) {
            super(name, value, Integer.class);
        }

        private IntegerAttribute(String name, int value, Class<Integer> clazz) {
            super(name, value, clazz);
        }
    }

    public static class FloatAttribute
    extends CustomAttribute<Float> {
        private FloatAttribute(String name, float value, Class<Float> clazz) {
            super(name, Float.valueOf(value), clazz);
        }

        private FloatAttribute(String name, float value) {
            super(name, Float.valueOf(value), Float.class);
        }
    }

    public static class DoubleAttribute
    extends CustomAttribute<Double> {
        private DoubleAttribute(String name, double value, Class<Double> clazz) {
            super(name, value, clazz);
        }

        private DoubleAttribute(String name, double value) {
            super(name, value, Double.class);
        }
    }

    public static class BooleanAttribute
    extends CustomAttribute<Boolean> {
        private BooleanAttribute(String name, boolean value) {
            super(name, value, Boolean.class);
        }

        private BooleanAttribute(String name, boolean value, Class<Boolean> clazz) {
            super(name, value, clazz);
        }
    }

    public static class StringAttribute
    extends CustomAttribute<String> {
        private StringAttribute(String name, String value) {
            super(name, value, String.class);
        }

        private StringAttribute(String name, String value, Class<String> clazz) {
            super(name, value, clazz);
        }
    }
}

