/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.google.common.collect.Lists;
import io.intercom.api.Company;
import io.intercom.api.CompanyCollection;
import io.intercom.api.CompanyWithStringPlan;
import java.util.ArrayList;
import java.util.List;

class CompanyUpdateBuilder {
    CompanyUpdateBuilder() {
    }

    static List<CompanyWithStringPlan> buildUserUpdateCompanies(CompanyCollection add, CompanyCollection remove) {
        List<Company> companies;
        ArrayList updatableCompanies = Lists.newArrayList();
        if (add != null) {
            companies = add.getPage();
            for (Company company : companies) {
                updatableCompanies.add(CompanyUpdateBuilder.prepareUpdatableCompany(company));
            }
        }
        if (remove != null) {
            companies = remove.getPage();
            for (Company company : companies) {
                updatableCompanies.add(CompanyUpdateBuilder.prepareUpdatableCompany(company).setRemove(Boolean.TRUE));
            }
        }
        return updatableCompanies;
    }

    private static CompanyWithStringPlan prepareUpdatableCompany(Company company) {
        CompanyWithStringPlan updatableCompany = new CompanyWithStringPlan();
        updatableCompany.setCompanyID(company.getCompanyID());
        updatableCompany.setName(company.getName());
        updatableCompany.setSessionCount(company.getSessionCount());
        updatableCompany.setMonthlySpend(company.getMonthlySpend());
        updatableCompany.setRemoteCreatedAt(company.getRemoteCreatedAt());
        if (company.getPlan() != null) {
            updatableCompany.setPlan(company.getPlan().getName());
        }
        return updatableCompany;
    }
}

