/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.intercom.api.AuthorizationException;
import io.intercom.api.ClientException;
import io.intercom.api.DataResource;
import io.intercom.api.Error;
import io.intercom.api.ErrorCollection;
import io.intercom.api.EventCollection;
import io.intercom.api.InvalidException;
import io.intercom.api.Job;
import io.intercom.api.JobItem;
import io.intercom.api.JobItemCollection;
import io.intercom.api.JobSupport;
import io.intercom.api.RateLimitException;
import io.intercom.api.ServerException;
import io.intercom.api.TypedData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Event
extends TypedData {
    private static final List<String> BULK_METHODS = Lists.newArrayList((Object[])new String[]{"post"});
    private static final ArrayList<String> BULK_PATHS = Lists.newArrayListWithExpectedSize((int)2);
    private static final ErrorCollection INVALID_NAME;
    private static final ErrorCollection INVALID_USER;
    @JsonProperty(value="type")
    private final String type = "event";
    @JsonProperty(value="event_name")
    private String eventName;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="email")
    private String email;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="user_id")
    private String userID;
    @JsonProperty(value="intercom_user_id")
    private String intercomUserID;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata = Maps.newHashMap();

    public static void create(Event event) throws InvalidException, AuthorizationException {
        Event.validateCreateEvent(event);
        if (event.getCreatedAt() == 0L) {
            event.setCreatedAt(System.currentTimeMillis() / 1000L);
        }
        DataResource.create(event, "events", Void.class);
    }

    public static Job submit(List<JobItem<Event>> items) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return Event.submit(items, null);
    }

    public static Job submit(List<JobItem<Event>> items, Job job) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return Job.submit(Event.validateJobItems(items), job, BULK_PATHS);
    }

    public static JobItemCollection<Event> listJobErrorFeed(String jobID) throws AuthorizationException, ClientException, ServerException, InvalidException, RateLimitException {
        return Job.listJobErrorFeed(jobID, Event.class);
    }

    public static EventCollection list(Map<String, String> params) throws InvalidException, AuthorizationException {
        if (!(params.containsKey("email") || params.containsKey("user_id") || params.containsKey("intercom_user_id"))) {
            throw new InvalidException("an event query must include an email, user_id or intercom_user_id parameter");
        }
        return DataResource.list(params, "events", EventCollection.class);
    }

    @VisibleForTesting
    static List<JobItem<Event>> validateJobItems(List<JobItem<Event>> items) {
        JobSupport jobSupport = new JobSupport();
        for (JobItem<Event> item : items) {
            jobSupport.validateJobItem(item, BULK_METHODS);
            Event.validateCreateEvent(item.getData());
        }
        return items;
    }

    @VisibleForTesting
    static void validateCreateEvent(Event event) {
        if (Strings.isNullOrEmpty((String)event.getEventName())) {
            throw new InvalidException(INVALID_NAME);
        }
        if (Strings.isNullOrEmpty((String)event.getUserID()) && Strings.isNullOrEmpty((String)event.getId()) && Strings.isNullOrEmpty((String)event.getEmail())) {
            throw new InvalidException(INVALID_USER);
        }
    }

    @Override
    public String getType() {
        return "event";
    }

    public String getEventName() {
        return this.eventName;
    }

    public Event setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public Event setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public Event setEmail(String email) {
        this.email = email;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Event setId(String id) {
        this.id = id;
        return this;
    }

    public String getUserID() {
        return this.userID;
    }

    public Event setUserID(String userID) {
        this.userID = userID;
        return this;
    }

    public String getIntercomUserID() {
        return this.intercomUserID;
    }

    public Event setIntercomUserID(String intercomUserID) {
        this.intercomUserID = intercomUserID;
        return this;
    }

    public Event putMetadata(String name, String value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, boolean value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, int value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, double value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, long value) {
        this.metadata.put(name, value);
        return this;
    }

    public Event putMetadata(String name, float value) {
        this.metadata.put(name, Float.valueOf(value));
        return this;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public Event setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        if (this.createdAt != event.createdAt) {
            return false;
        }
        if (this.email != null ? !this.email.equals(event.email) : event.email != null) {
            return false;
        }
        if (this.eventName != null ? !this.eventName.equals(event.eventName) : event.eventName != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(event.metadata) : event.metadata != null) {
            return false;
        }
        if (!"event".equals(event.type)) {
            return false;
        }
        if (this.userID != null ? !this.userID.equals(event.userID) : event.userID != null) {
            return false;
        }
        return !(this.id != null ? !this.id.equals(event.id) : event.id != null);
    }

    public int hashCode() {
        int result = "event".hashCode();
        result = 31 * result + (this.eventName != null ? this.eventName.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.userID != null ? this.userID.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Event{type='event', eventName='" + this.eventName + '\'' + ", createdAt=" + this.createdAt + ", email='" + this.email + '\'' + ", id='" + this.id + '\'' + ", userID='" + this.userID + '\'' + ", metadata=" + this.metadata + "} " + super.toString();
    }

    static {
        BULK_PATHS.add("bulk");
        BULK_PATHS.add("events");
        INVALID_NAME = new ErrorCollection(Lists.newArrayList((Object[])new Error[]{new Error("invalid", "an event must supply an event name")}));
        INVALID_USER = new ErrorCollection(Lists.newArrayList((Object[])new Error[]{new Error("invalid", "an event must supply either an email or a user id")}));
    }
}

