/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.admins.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConfigureAwayAdminRequest.Builder.class)
public final class ConfigureAwayAdminRequest {
    private final String adminId;

    private final boolean awayModeEnabled;

    private final boolean awayModeReassign;

    private final Map<String, Object> additionalProperties;

    private ConfigureAwayAdminRequest(
            String adminId,
            boolean awayModeEnabled,
            boolean awayModeReassign,
            Map<String, Object> additionalProperties) {
        this.adminId = adminId;
        this.awayModeEnabled = awayModeEnabled;
        this.awayModeReassign = awayModeReassign;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of a given admin
     */
    @JsonProperty("admin_id")
    public String getAdminId() {
        return adminId;
    }

    /**
     * @return Set to &quot;true&quot; to change the status of the admin to away.
     */
    @JsonProperty("away_mode_enabled")
    public boolean getAwayModeEnabled() {
        return awayModeEnabled;
    }

    /**
     * @return Set to &quot;true&quot; to assign any new conversation replies to your default inbox.
     */
    @JsonProperty("away_mode_reassign")
    public boolean getAwayModeReassign() {
        return awayModeReassign;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConfigureAwayAdminRequest && equalTo((ConfigureAwayAdminRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConfigureAwayAdminRequest other) {
        return adminId.equals(other.adminId)
                && awayModeEnabled == other.awayModeEnabled
                && awayModeReassign == other.awayModeReassign;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.adminId, this.awayModeEnabled, this.awayModeReassign);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AdminIdStage builder() {
        return new Builder();
    }

    public interface AdminIdStage {
        /**
         * The unique identifier of a given admin
         */
        AwayModeEnabledStage adminId(@NotNull String adminId);

        Builder from(ConfigureAwayAdminRequest other);
    }

    public interface AwayModeEnabledStage {
        /**
         * Set to "true" to change the status of the admin to away.
         */
        AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled);
    }

    public interface AwayModeReassignStage {
        /**
         * Set to "true" to assign any new conversation replies to your default inbox.
         */
        _FinalStage awayModeReassign(boolean awayModeReassign);
    }

    public interface _FinalStage {
        ConfigureAwayAdminRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AdminIdStage, AwayModeEnabledStage, AwayModeReassignStage, _FinalStage {
        private String adminId;

        private boolean awayModeEnabled;

        private boolean awayModeReassign;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConfigureAwayAdminRequest other) {
            adminId(other.getAdminId());
            awayModeEnabled(other.getAwayModeEnabled());
            awayModeReassign(other.getAwayModeReassign());
            return this;
        }

        /**
         * The unique identifier of a given admin<p>The unique identifier of a given admin</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("admin_id")
        public AwayModeEnabledStage adminId(@NotNull String adminId) {
            this.adminId = Objects.requireNonNull(adminId, "adminId must not be null");
            return this;
        }

        /**
         * Set to "true" to change the status of the admin to away.<p>Set to &quot;true&quot; to change the status of the admin to away.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("away_mode_enabled")
        public AwayModeReassignStage awayModeEnabled(boolean awayModeEnabled) {
            this.awayModeEnabled = awayModeEnabled;
            return this;
        }

        /**
         * Set to "true" to assign any new conversation replies to your default inbox.<p>Set to &quot;true&quot; to assign any new conversation replies to your default inbox.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("away_mode_reassign")
        public _FinalStage awayModeReassign(boolean awayModeReassign) {
            this.awayModeReassign = awayModeReassign;
            return this;
        }

        @java.lang.Override
        public ConfigureAwayAdminRequest build() {
            return new ConfigureAwayAdminRequest(adminId, awayModeEnabled, awayModeReassign, additionalProperties);
        }
    }
}
