/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.articles.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ArticleSearchHighlights.Builder.class)
public final class ArticleSearchHighlights {
    private final String articleId;

    private final List<HighlightedTitleItem> highlightedTitle;

    private final List<List<HighlightedSummaryItemItem>> highlightedSummary;

    private final Map<String, Object> additionalProperties;

    private ArticleSearchHighlights(
            String articleId,
            List<HighlightedTitleItem> highlightedTitle,
            List<List<HighlightedSummaryItemItem>> highlightedSummary,
            Map<String, Object> additionalProperties) {
        this.articleId = articleId;
        this.highlightedTitle = highlightedTitle;
        this.highlightedSummary = highlightedSummary;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The ID of the corresponding article.
     */
    @JsonProperty("article_id")
    public String getArticleId() {
        return articleId;
    }

    /**
     * @return An Article title highlighted.
     */
    @JsonProperty("highlighted_title")
    public List<HighlightedTitleItem> getHighlightedTitle() {
        return highlightedTitle;
    }

    /**
     * @return An Article description and body text highlighted.
     */
    @JsonProperty("highlighted_summary")
    public List<List<HighlightedSummaryItemItem>> getHighlightedSummary() {
        return highlightedSummary;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ArticleSearchHighlights && equalTo((ArticleSearchHighlights) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ArticleSearchHighlights other) {
        return articleId.equals(other.articleId)
                && highlightedTitle.equals(other.highlightedTitle)
                && highlightedSummary.equals(other.highlightedSummary);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.articleId, this.highlightedTitle, this.highlightedSummary);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ArticleIdStage builder() {
        return new Builder();
    }

    public interface ArticleIdStage {
        /**
         * The ID of the corresponding article.
         */
        _FinalStage articleId(@NotNull String articleId);

        Builder from(ArticleSearchHighlights other);
    }

    public interface _FinalStage {
        ArticleSearchHighlights build();

        /**
         * <p>An Article title highlighted.</p>
         */
        _FinalStage highlightedTitle(List<HighlightedTitleItem> highlightedTitle);

        _FinalStage addHighlightedTitle(HighlightedTitleItem highlightedTitle);

        _FinalStage addAllHighlightedTitle(List<HighlightedTitleItem> highlightedTitle);

        /**
         * <p>An Article description and body text highlighted.</p>
         */
        _FinalStage highlightedSummary(List<List<HighlightedSummaryItemItem>> highlightedSummary);

        _FinalStage addHighlightedSummary(List<HighlightedSummaryItemItem> highlightedSummary);

        _FinalStage addAllHighlightedSummary(List<List<HighlightedSummaryItemItem>> highlightedSummary);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ArticleIdStage, _FinalStage {
        private String articleId;

        private List<List<HighlightedSummaryItemItem>> highlightedSummary = new ArrayList<>();

        private List<HighlightedTitleItem> highlightedTitle = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ArticleSearchHighlights other) {
            articleId(other.getArticleId());
            highlightedTitle(other.getHighlightedTitle());
            highlightedSummary(other.getHighlightedSummary());
            return this;
        }

        /**
         * The ID of the corresponding article.<p>The ID of the corresponding article.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("article_id")
        public _FinalStage articleId(@NotNull String articleId) {
            this.articleId = Objects.requireNonNull(articleId, "articleId must not be null");
            return this;
        }

        /**
         * <p>An Article description and body text highlighted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllHighlightedSummary(List<List<HighlightedSummaryItemItem>> highlightedSummary) {
            this.highlightedSummary.addAll(highlightedSummary);
            return this;
        }

        /**
         * <p>An Article description and body text highlighted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addHighlightedSummary(List<HighlightedSummaryItemItem> highlightedSummary) {
            this.highlightedSummary.add(highlightedSummary);
            return this;
        }

        /**
         * <p>An Article description and body text highlighted.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "highlighted_summary", nulls = Nulls.SKIP)
        public _FinalStage highlightedSummary(List<List<HighlightedSummaryItemItem>> highlightedSummary) {
            this.highlightedSummary.clear();
            this.highlightedSummary.addAll(highlightedSummary);
            return this;
        }

        /**
         * <p>An Article title highlighted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addAllHighlightedTitle(List<HighlightedTitleItem> highlightedTitle) {
            this.highlightedTitle.addAll(highlightedTitle);
            return this;
        }

        /**
         * <p>An Article title highlighted.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage addHighlightedTitle(HighlightedTitleItem highlightedTitle) {
            this.highlightedTitle.add(highlightedTitle);
            return this;
        }

        /**
         * <p>An Article title highlighted.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "highlighted_title", nulls = Nulls.SKIP)
        public _FinalStage highlightedTitle(List<HighlightedTitleItem> highlightedTitle) {
            this.highlightedTitle.clear();
            this.highlightedTitle.addAll(highlightedTitle);
            return this;
        }

        @java.lang.Override
        public ArticleSearchHighlights build() {
            return new ArticleSearchHighlights(articleId, highlightedTitle, highlightedSummary, additionalProperties);
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = HighlightedTitleItem.Builder.class)
    public static final class HighlightedTitleItem {
        private final Optional<Type> type;

        private final Optional<String> text;

        private final Map<String, Object> additionalProperties;

        private HighlightedTitleItem(
                Optional<Type> type, Optional<String> text, Map<String, Object> additionalProperties) {
            this.type = type;
            this.text = text;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of text - <code>highlight</code> or <code>plain</code>.
         */
        @JsonProperty("type")
        public Optional<Type> getType() {
            return type;
        }

        /**
         * @return The text of the title.
         */
        @JsonProperty("text")
        public Optional<String> getText() {
            return text;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof HighlightedTitleItem && equalTo((HighlightedTitleItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(HighlightedTitleItem other) {
            return type.equals(other.type) && text.equals(other.text);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.text);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<Type> type = Optional.empty();

            private Optional<String> text = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(HighlightedTitleItem other) {
                type(other.getType());
                text(other.getText());
                return this;
            }

            /**
             * <p>The type of text - <code>highlight</code> or <code>plain</code>.</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<Type> type) {
                this.type = type;
                return this;
            }

            public Builder type(Type type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>The text of the title.</p>
             */
            @JsonSetter(value = "text", nulls = Nulls.SKIP)
            public Builder text(Optional<String> text) {
                this.text = text;
                return this;
            }

            public Builder text(String text) {
                this.text = Optional.ofNullable(text);
                return this;
            }

            public HighlightedTitleItem build() {
                return new HighlightedTitleItem(type, text, additionalProperties);
            }
        }

        public static final class Type {
            public static final Type PLAIN = new Type(Value.PLAIN, "plain");

            public static final Type HIGHLIGHT = new Type(Value.HIGHLIGHT, "highlight");

            private final Value value;

            private final String string;

            Type(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return value;
            }

            @java.lang.Override
            @JsonValue
            public String toString() {
                return this.string;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
            }

            @java.lang.Override
            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (value) {
                    case PLAIN:
                        return visitor.visitPlain();
                    case HIGHLIGHT:
                        return visitor.visitHighlight();
                    case UNKNOWN:
                    default:
                        return visitor.visitUnknown(string);
                }
            }

            @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
            public static Type valueOf(String value) {
                switch (value) {
                    case "plain":
                        return PLAIN;
                    case "highlight":
                        return HIGHLIGHT;
                    default:
                        return new Type(Value.UNKNOWN, value);
                }
            }

            public enum Value {
                HIGHLIGHT,

                PLAIN,

                UNKNOWN
            }

            public interface Visitor<T> {
                T visitHighlight();

                T visitPlain();

                T visitUnknown(String unknownType);
            }
        }
    }

    @JsonInclude(JsonInclude.Include.NON_ABSENT)
    @JsonDeserialize(builder = HighlightedSummaryItemItem.Builder.class)
    public static final class HighlightedSummaryItemItem {
        private final Optional<Type> type;

        private final Optional<String> text;

        private final Map<String, Object> additionalProperties;

        private HighlightedSummaryItemItem(
                Optional<Type> type, Optional<String> text, Map<String, Object> additionalProperties) {
            this.type = type;
            this.text = text;
            this.additionalProperties = additionalProperties;
        }

        /**
         * @return The type of text - <code>highlight</code> or <code>plain</code>.
         */
        @JsonProperty("type")
        public Optional<Type> getType() {
            return type;
        }

        /**
         * @return The text of the title.
         */
        @JsonProperty("text")
        public Optional<String> getText() {
            return text;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            if (this == other) return true;
            return other instanceof HighlightedSummaryItemItem && equalTo((HighlightedSummaryItemItem) other);
        }

        @JsonAnyGetter
        public Map<String, Object> getAdditionalProperties() {
            return this.additionalProperties;
        }

        private boolean equalTo(HighlightedSummaryItemItem other) {
            return type.equals(other.type) && text.equals(other.text);
        }

        @java.lang.Override
        public int hashCode() {
            return Objects.hash(this.type, this.text);
        }

        @java.lang.Override
        public String toString() {
            return ObjectMappers.stringify(this);
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonIgnoreProperties(ignoreUnknown = true)
        public static final class Builder {
            private Optional<Type> type = Optional.empty();

            private Optional<String> text = Optional.empty();

            @JsonAnySetter
            private Map<String, Object> additionalProperties = new HashMap<>();

            private Builder() {}

            public Builder from(HighlightedSummaryItemItem other) {
                type(other.getType());
                text(other.getText());
                return this;
            }

            /**
             * <p>The type of text - <code>highlight</code> or <code>plain</code>.</p>
             */
            @JsonSetter(value = "type", nulls = Nulls.SKIP)
            public Builder type(Optional<Type> type) {
                this.type = type;
                return this;
            }

            public Builder type(Type type) {
                this.type = Optional.ofNullable(type);
                return this;
            }

            /**
             * <p>The text of the title.</p>
             */
            @JsonSetter(value = "text", nulls = Nulls.SKIP)
            public Builder text(Optional<String> text) {
                this.text = text;
                return this;
            }

            public Builder text(String text) {
                this.text = Optional.ofNullable(text);
                return this;
            }

            public HighlightedSummaryItemItem build() {
                return new HighlightedSummaryItemItem(type, text, additionalProperties);
            }
        }

        public static final class Type {
            public static final Type PLAIN = new Type(Value.PLAIN, "plain");

            public static final Type HIGHLIGHT = new Type(Value.HIGHLIGHT, "highlight");

            private final Value value;

            private final String string;

            Type(Value value, String string) {
                this.value = value;
                this.string = string;
            }

            public Value getEnumValue() {
                return value;
            }

            @java.lang.Override
            @JsonValue
            public String toString() {
                return this.string;
            }

            @java.lang.Override
            public boolean equals(Object other) {
                return (this == other) || (other instanceof Type && this.string.equals(((Type) other).string));
            }

            @java.lang.Override
            public int hashCode() {
                return this.string.hashCode();
            }

            public <T> T visit(Visitor<T> visitor) {
                switch (value) {
                    case PLAIN:
                        return visitor.visitPlain();
                    case HIGHLIGHT:
                        return visitor.visitHighlight();
                    case UNKNOWN:
                    default:
                        return visitor.visitUnknown(string);
                }
            }

            @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
            public static Type valueOf(String value) {
                switch (value) {
                    case "plain":
                        return PLAIN;
                    case "highlight":
                        return HIGHLIGHT;
                    default:
                        return new Type(Value.UNKNOWN, value);
                }
            }

            public enum Value {
                HIGHLIGHT,

                PLAIN,

                UNKNOWN
            }

            public interface Visitor<T> {
                T visitHighlight();

                T visitPlain();

                T visitUnknown(String unknownType);
            }
        }
    }
}
