/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ConvertConversationToTicketRequest.Builder.class)
public final class ConvertConversationToTicketRequest {
    private final String conversationId;

    private final String ticketTypeId;

    private final Optional<Map<String, Object>> attributes;

    private final Map<String, Object> additionalProperties;

    private ConvertConversationToTicketRequest(
            String conversationId,
            String ticketTypeId,
            Optional<Map<String, Object>> attributes,
            Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.ticketTypeId = ticketTypeId;
        this.attributes = attributes;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The id of the conversation to target
     */
    @JsonProperty("conversation_id")
    public String getConversationId() {
        return conversationId;
    }

    /**
     * @return The ID of the type of ticket you want to convert the conversation to
     */
    @JsonProperty("ticket_type_id")
    public String getTicketTypeId() {
        return ticketTypeId;
    }

    @JsonProperty("attributes")
    public Optional<Map<String, Object>> getAttributes() {
        return attributes;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ConvertConversationToTicketRequest
                && equalTo((ConvertConversationToTicketRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ConvertConversationToTicketRequest other) {
        return conversationId.equals(other.conversationId)
                && ticketTypeId.equals(other.ticketTypeId)
                && attributes.equals(other.attributes);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conversationId, this.ticketTypeId, this.attributes);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    public interface ConversationIdStage {
        /**
         * The id of the conversation to target
         */
        TicketTypeIdStage conversationId(@NotNull String conversationId);

        Builder from(ConvertConversationToTicketRequest other);
    }

    public interface TicketTypeIdStage {
        /**
         * The ID of the type of ticket you want to convert the conversation to
         */
        _FinalStage ticketTypeId(@NotNull String ticketTypeId);
    }

    public interface _FinalStage {
        ConvertConversationToTicketRequest build();

        _FinalStage attributes(Optional<Map<String, Object>> attributes);

        _FinalStage attributes(Map<String, Object> attributes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ConversationIdStage, TicketTypeIdStage, _FinalStage {
        private String conversationId;

        private String ticketTypeId;

        private Optional<Map<String, Object>> attributes = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ConvertConversationToTicketRequest other) {
            conversationId(other.getConversationId());
            ticketTypeId(other.getTicketTypeId());
            attributes(other.getAttributes());
            return this;
        }

        /**
         * The id of the conversation to target<p>The id of the conversation to target</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation_id")
        public TicketTypeIdStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        /**
         * The ID of the type of ticket you want to convert the conversation to<p>The ID of the type of ticket you want to convert the conversation to</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("ticket_type_id")
        public _FinalStage ticketTypeId(@NotNull String ticketTypeId) {
            this.ticketTypeId = Objects.requireNonNull(ticketTypeId, "ticketTypeId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage attributes(Map<String, Object> attributes) {
            this.attributes = Optional.ofNullable(attributes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "attributes", nulls = Nulls.SKIP)
        public _FinalStage attributes(Optional<Map<String, Object>> attributes) {
            this.attributes = attributes;
            return this;
        }

        @java.lang.Override
        public ConvertConversationToTicketRequest build() {
            return new ConvertConversationToTicketRequest(
                    conversationId, ticketTypeId, attributes, additionalProperties);
        }
    }
}
