/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.conversations.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ReplyConversationRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ReplyToConversationRequest.Builder.class)
public final class ReplyToConversationRequest {
    private final String conversationId;

    private final ReplyConversationRequest body;

    private final Map<String, Object> additionalProperties;

    private ReplyToConversationRequest(
            String conversationId, ReplyConversationRequest body, Map<String, Object> additionalProperties) {
        this.conversationId = conversationId;
        this.body = body;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The Intercom provisioned identifier for the conversation or the string &quot;last&quot; to reply to the last part of the conversation
     */
    @JsonProperty("conversation_id")
    public String getConversationId() {
        return conversationId;
    }

    @JsonProperty("body")
    public ReplyConversationRequest getBody() {
        return body;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ReplyToConversationRequest && equalTo((ReplyToConversationRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ReplyToConversationRequest other) {
        return conversationId.equals(other.conversationId) && body.equals(other.body);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conversationId, this.body);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ConversationIdStage builder() {
        return new Builder();
    }

    public interface ConversationIdStage {
        /**
         * The Intercom provisioned identifier for the conversation or the string "last" to reply to the last part of the conversation
         */
        BodyStage conversationId(@NotNull String conversationId);

        Builder from(ReplyToConversationRequest other);
    }

    public interface BodyStage {
        _FinalStage body(@NotNull ReplyConversationRequest body);
    }

    public interface _FinalStage {
        ReplyToConversationRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ConversationIdStage, BodyStage, _FinalStage {
        private String conversationId;

        private ReplyConversationRequest body;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ReplyToConversationRequest other) {
            conversationId(other.getConversationId());
            body(other.getBody());
            return this;
        }

        /**
         * The Intercom provisioned identifier for the conversation or the string "last" to reply to the last part of the conversation<p>The Intercom provisioned identifier for the conversation or the string &quot;last&quot; to reply to the last part of the conversation</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("conversation_id")
        public BodyStage conversationId(@NotNull String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("body")
        public _FinalStage body(@NotNull ReplyConversationRequest body) {
            this.body = Objects.requireNonNull(body, "body must not be null");
            return this;
        }

        @java.lang.Override
        public ReplyToConversationRequest build() {
            return new ReplyToConversationRequest(conversationId, body, additionalProperties);
        }
    }
}
