/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.conversations.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.resources.aiagent.types.AiAgent;
import com.intercom.api.types.ConversationContacts;
import com.intercom.api.types.ConversationFirstContactReply;
import com.intercom.api.types.ConversationParts;
import com.intercom.api.types.ConversationRating;
import com.intercom.api.types.ConversationSource;
import com.intercom.api.types.ConversationStatistics;
import com.intercom.api.types.ConversationTeammates;
import com.intercom.api.types.LinkedObjectList;
import com.intercom.api.types.SlaApplied;
import com.intercom.api.types.Tags;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Conversation.Builder.class)
public final class Conversation {
    private final Optional<String> type;

    private final String id;

    private final Optional<String> title;

    private final int createdAt;

    private final int updatedAt;

    private final Optional<Integer> waitingSince;

    private final Optional<Integer> snoozedUntil;

    private final boolean open;

    private final State state;

    private final boolean read;

    private final Optional<Priority> priority;

    private final Optional<Integer> adminAssigneeId;

    private final Optional<String> teamAssigneeId;

    private final Optional<Tags> tags;

    private final Optional<ConversationRating> conversationRating;

    private final ConversationSource source;

    private final ConversationContacts contacts;

    private final ConversationTeammates teammates;

    private final Map<String, Object> customAttributes;

    private final Optional<ConversationFirstContactReply> firstContactReply;

    private final Optional<SlaApplied> slaApplied;

    private final Optional<ConversationStatistics> statistics;

    private final Optional<ConversationParts> conversationParts;

    private final Optional<LinkedObjectList> linkedObjects;

    private final Optional<Boolean> aiAgentParticipated;

    private final Optional<AiAgent> aiAgent;

    private final Map<String, Object> additionalProperties;

    private Conversation(
            Optional<String> type,
            String id,
            Optional<String> title,
            int createdAt,
            int updatedAt,
            Optional<Integer> waitingSince,
            Optional<Integer> snoozedUntil,
            boolean open,
            State state,
            boolean read,
            Optional<Priority> priority,
            Optional<Integer> adminAssigneeId,
            Optional<String> teamAssigneeId,
            Optional<Tags> tags,
            Optional<ConversationRating> conversationRating,
            ConversationSource source,
            ConversationContacts contacts,
            ConversationTeammates teammates,
            Map<String, Object> customAttributes,
            Optional<ConversationFirstContactReply> firstContactReply,
            Optional<SlaApplied> slaApplied,
            Optional<ConversationStatistics> statistics,
            Optional<ConversationParts> conversationParts,
            Optional<LinkedObjectList> linkedObjects,
            Optional<Boolean> aiAgentParticipated,
            Optional<AiAgent> aiAgent,
            Map<String, Object> additionalProperties) {
        this.type = type;
        this.id = id;
        this.title = title;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.waitingSince = waitingSince;
        this.snoozedUntil = snoozedUntil;
        this.open = open;
        this.state = state;
        this.read = read;
        this.priority = priority;
        this.adminAssigneeId = adminAssigneeId;
        this.teamAssigneeId = teamAssigneeId;
        this.tags = tags;
        this.conversationRating = conversationRating;
        this.source = source;
        this.contacts = contacts;
        this.teammates = teammates;
        this.customAttributes = customAttributes;
        this.firstContactReply = firstContactReply;
        this.slaApplied = slaApplied;
        this.statistics = statistics;
        this.conversationParts = conversationParts;
        this.linkedObjects = linkedObjects;
        this.aiAgentParticipated = aiAgentParticipated;
        this.aiAgent = aiAgent;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Always conversation.
     */
    @JsonProperty("type")
    public Optional<String> getType() {
        return type;
    }

    /**
     * @return The id representing the conversation.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The title given to the conversation.
     */
    @JsonProperty("title")
    public Optional<String> getTitle() {
        return title;
    }

    /**
     * @return The time the conversation was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return The last time the conversation was updated.
     */
    @JsonProperty("updated_at")
    public int getUpdatedAt() {
        return updatedAt;
    }

    /**
     * @return The last time a Contact responded to an Admin. In other words, the time a customer started waiting for a response. Set to null if last reply is from an Admin.
     */
    @JsonProperty("waiting_since")
    public Optional<Integer> getWaitingSince() {
        return waitingSince;
    }

    /**
     * @return If set this is the time in the future when this conversation will be marked as open. i.e. it will be in a snoozed state until this time. i.e. it will be in a snoozed state until this time.
     */
    @JsonProperty("snoozed_until")
    public Optional<Integer> getSnoozedUntil() {
        return snoozedUntil;
    }

    /**
     * @return Indicates whether a conversation is open (true) or closed (false).
     */
    @JsonProperty("open")
    public boolean getOpen() {
        return open;
    }

    /**
     * @return Can be set to &quot;open&quot;, &quot;closed&quot; or &quot;snoozed&quot;.
     */
    @JsonProperty("state")
    public State getState() {
        return state;
    }

    /**
     * @return Indicates whether a conversation has been read.
     */
    @JsonProperty("read")
    public boolean getRead() {
        return read;
    }

    /**
     * @return If marked as priority, it will return priority or else not_priority.
     */
    @JsonProperty("priority")
    public Optional<Priority> getPriority() {
        return priority;
    }

    /**
     * @return The id of the admin assigned to the conversation. If it's not assigned to an admin it will return null.
     */
    @JsonProperty("admin_assignee_id")
    public Optional<Integer> getAdminAssigneeId() {
        return adminAssigneeId;
    }

    /**
     * @return The id of the team assigned to the conversation. If it's not assigned to a team it will return null.
     */
    @JsonProperty("team_assignee_id")
    public Optional<String> getTeamAssigneeId() {
        return teamAssigneeId;
    }

    @JsonProperty("tags")
    public Optional<Tags> getTags() {
        return tags;
    }

    @JsonProperty("conversation_rating")
    public Optional<ConversationRating> getConversationRating() {
        return conversationRating;
    }

    @JsonProperty("source")
    public ConversationSource getSource() {
        return source;
    }

    @JsonProperty("contacts")
    public ConversationContacts getContacts() {
        return contacts;
    }

    @JsonProperty("teammates")
    public ConversationTeammates getTeammates() {
        return teammates;
    }

    @JsonProperty("custom_attributes")
    public Map<String, Object> getCustomAttributes() {
        return customAttributes;
    }

    @JsonProperty("first_contact_reply")
    public Optional<ConversationFirstContactReply> getFirstContactReply() {
        return firstContactReply;
    }

    @JsonProperty("sla_applied")
    public Optional<SlaApplied> getSlaApplied() {
        return slaApplied;
    }

    @JsonProperty("statistics")
    public Optional<ConversationStatistics> getStatistics() {
        return statistics;
    }

    @JsonProperty("conversation_parts")
    public Optional<ConversationParts> getConversationParts() {
        return conversationParts;
    }

    @JsonProperty("linked_objects")
    public Optional<LinkedObjectList> getLinkedObjects() {
        return linkedObjects;
    }

    /**
     * @return Indicates whether the AI Agent participated in the conversation.
     */
    @JsonProperty("ai_agent_participated")
    public Optional<Boolean> getAiAgentParticipated() {
        return aiAgentParticipated;
    }

    @JsonProperty("ai_agent")
    public Optional<AiAgent> getAiAgent() {
        return aiAgent;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Conversation && equalTo((Conversation) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Conversation other) {
        return type.equals(other.type)
                && id.equals(other.id)
                && title.equals(other.title)
                && createdAt == other.createdAt
                && updatedAt == other.updatedAt
                && waitingSince.equals(other.waitingSince)
                && snoozedUntil.equals(other.snoozedUntil)
                && open == other.open
                && state.equals(other.state)
                && read == other.read
                && priority.equals(other.priority)
                && adminAssigneeId.equals(other.adminAssigneeId)
                && teamAssigneeId.equals(other.teamAssigneeId)
                && tags.equals(other.tags)
                && conversationRating.equals(other.conversationRating)
                && source.equals(other.source)
                && contacts.equals(other.contacts)
                && teammates.equals(other.teammates)
                && customAttributes.equals(other.customAttributes)
                && firstContactReply.equals(other.firstContactReply)
                && slaApplied.equals(other.slaApplied)
                && statistics.equals(other.statistics)
                && conversationParts.equals(other.conversationParts)
                && linkedObjects.equals(other.linkedObjects)
                && aiAgentParticipated.equals(other.aiAgentParticipated)
                && aiAgent.equals(other.aiAgent);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.type,
                this.id,
                this.title,
                this.createdAt,
                this.updatedAt,
                this.waitingSince,
                this.snoozedUntil,
                this.open,
                this.state,
                this.read,
                this.priority,
                this.adminAssigneeId,
                this.teamAssigneeId,
                this.tags,
                this.conversationRating,
                this.source,
                this.contacts,
                this.teammates,
                this.customAttributes,
                this.firstContactReply,
                this.slaApplied,
                this.statistics,
                this.conversationParts,
                this.linkedObjects,
                this.aiAgentParticipated,
                this.aiAgent);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The id representing the conversation.
         */
        CreatedAtStage id(@NotNull String id);

        Builder from(Conversation other);
    }

    public interface CreatedAtStage {
        /**
         * The time the conversation was created.
         */
        UpdatedAtStage createdAt(int createdAt);
    }

    public interface UpdatedAtStage {
        /**
         * The last time the conversation was updated.
         */
        OpenStage updatedAt(int updatedAt);
    }

    public interface OpenStage {
        /**
         * Indicates whether a conversation is open (true) or closed (false).
         */
        StateStage open(boolean open);
    }

    public interface StateStage {
        /**
         * Can be set to "open", "closed" or "snoozed".
         */
        ReadStage state(@NotNull State state);
    }

    public interface ReadStage {
        /**
         * Indicates whether a conversation has been read.
         */
        SourceStage read(boolean read);
    }

    public interface SourceStage {
        ContactsStage source(@NotNull ConversationSource source);
    }

    public interface ContactsStage {
        TeammatesStage contacts(@NotNull ConversationContacts contacts);
    }

    public interface TeammatesStage {
        _FinalStage teammates(@NotNull ConversationTeammates teammates);
    }

    public interface _FinalStage {
        Conversation build();

        /**
         * <p>Always conversation.</p>
         */
        _FinalStage type(Optional<String> type);

        _FinalStage type(String type);

        /**
         * <p>The title given to the conversation.</p>
         */
        _FinalStage title(Optional<String> title);

        _FinalStage title(String title);

        /**
         * <p>The last time a Contact responded to an Admin. In other words, the time a customer started waiting for a response. Set to null if last reply is from an Admin.</p>
         */
        _FinalStage waitingSince(Optional<Integer> waitingSince);

        _FinalStage waitingSince(Integer waitingSince);

        /**
         * <p>If set this is the time in the future when this conversation will be marked as open. i.e. it will be in a snoozed state until this time. i.e. it will be in a snoozed state until this time.</p>
         */
        _FinalStage snoozedUntil(Optional<Integer> snoozedUntil);

        _FinalStage snoozedUntil(Integer snoozedUntil);

        /**
         * <p>If marked as priority, it will return priority or else not_priority.</p>
         */
        _FinalStage priority(Optional<Priority> priority);

        _FinalStage priority(Priority priority);

        /**
         * <p>The id of the admin assigned to the conversation. If it's not assigned to an admin it will return null.</p>
         */
        _FinalStage adminAssigneeId(Optional<Integer> adminAssigneeId);

        _FinalStage adminAssigneeId(Integer adminAssigneeId);

        /**
         * <p>The id of the team assigned to the conversation. If it's not assigned to a team it will return null.</p>
         */
        _FinalStage teamAssigneeId(Optional<String> teamAssigneeId);

        _FinalStage teamAssigneeId(String teamAssigneeId);

        _FinalStage tags(Optional<Tags> tags);

        _FinalStage tags(Tags tags);

        _FinalStage conversationRating(Optional<ConversationRating> conversationRating);

        _FinalStage conversationRating(ConversationRating conversationRating);

        _FinalStage customAttributes(Map<String, Object> customAttributes);

        _FinalStage putAllCustomAttributes(Map<String, Object> customAttributes);

        _FinalStage customAttributes(String key, Object value);

        _FinalStage firstContactReply(Optional<ConversationFirstContactReply> firstContactReply);

        _FinalStage firstContactReply(ConversationFirstContactReply firstContactReply);

        _FinalStage slaApplied(Optional<SlaApplied> slaApplied);

        _FinalStage slaApplied(SlaApplied slaApplied);

        _FinalStage statistics(Optional<ConversationStatistics> statistics);

        _FinalStage statistics(ConversationStatistics statistics);

        _FinalStage conversationParts(Optional<ConversationParts> conversationParts);

        _FinalStage conversationParts(ConversationParts conversationParts);

        _FinalStage linkedObjects(Optional<LinkedObjectList> linkedObjects);

        _FinalStage linkedObjects(LinkedObjectList linkedObjects);

        /**
         * <p>Indicates whether the AI Agent participated in the conversation.</p>
         */
        _FinalStage aiAgentParticipated(Optional<Boolean> aiAgentParticipated);

        _FinalStage aiAgentParticipated(Boolean aiAgentParticipated);

        _FinalStage aiAgent(Optional<AiAgent> aiAgent);

        _FinalStage aiAgent(AiAgent aiAgent);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements IdStage,
                    CreatedAtStage,
                    UpdatedAtStage,
                    OpenStage,
                    StateStage,
                    ReadStage,
                    SourceStage,
                    ContactsStage,
                    TeammatesStage,
                    _FinalStage {
        private String id;

        private int createdAt;

        private int updatedAt;

        private boolean open;

        private State state;

        private boolean read;

        private ConversationSource source;

        private ConversationContacts contacts;

        private ConversationTeammates teammates;

        private Optional<AiAgent> aiAgent = Optional.empty();

        private Optional<Boolean> aiAgentParticipated = Optional.empty();

        private Optional<LinkedObjectList> linkedObjects = Optional.empty();

        private Optional<ConversationParts> conversationParts = Optional.empty();

        private Optional<ConversationStatistics> statistics = Optional.empty();

        private Optional<SlaApplied> slaApplied = Optional.empty();

        private Optional<ConversationFirstContactReply> firstContactReply = Optional.empty();

        private Map<String, Object> customAttributes = new LinkedHashMap<>();

        private Optional<ConversationRating> conversationRating = Optional.empty();

        private Optional<Tags> tags = Optional.empty();

        private Optional<String> teamAssigneeId = Optional.empty();

        private Optional<Integer> adminAssigneeId = Optional.empty();

        private Optional<Priority> priority = Optional.empty();

        private Optional<Integer> snoozedUntil = Optional.empty();

        private Optional<Integer> waitingSince = Optional.empty();

        private Optional<String> title = Optional.empty();

        private Optional<String> type = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Conversation other) {
            type(other.getType());
            id(other.getId());
            title(other.getTitle());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            waitingSince(other.getWaitingSince());
            snoozedUntil(other.getSnoozedUntil());
            open(other.getOpen());
            state(other.getState());
            read(other.getRead());
            priority(other.getPriority());
            adminAssigneeId(other.getAdminAssigneeId());
            teamAssigneeId(other.getTeamAssigneeId());
            tags(other.getTags());
            conversationRating(other.getConversationRating());
            source(other.getSource());
            contacts(other.getContacts());
            teammates(other.getTeammates());
            customAttributes(other.getCustomAttributes());
            firstContactReply(other.getFirstContactReply());
            slaApplied(other.getSlaApplied());
            statistics(other.getStatistics());
            conversationParts(other.getConversationParts());
            linkedObjects(other.getLinkedObjects());
            aiAgentParticipated(other.getAiAgentParticipated());
            aiAgent(other.getAiAgent());
            return this;
        }

        /**
         * The id representing the conversation.<p>The id representing the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public CreatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The time the conversation was created.<p>The time the conversation was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public UpdatedAtStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * The last time the conversation was updated.<p>The last time the conversation was updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("updated_at")
        public OpenStage updatedAt(int updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        /**
         * Indicates whether a conversation is open (true) or closed (false).<p>Indicates whether a conversation is open (true) or closed (false).</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("open")
        public StateStage open(boolean open) {
            this.open = open;
            return this;
        }

        /**
         * Can be set to "open", "closed" or "snoozed".<p>Can be set to &quot;open&quot;, &quot;closed&quot; or &quot;snoozed&quot;.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("state")
        public ReadStage state(@NotNull State state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        /**
         * Indicates whether a conversation has been read.<p>Indicates whether a conversation has been read.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("read")
        public SourceStage read(boolean read) {
            this.read = read;
            return this;
        }

        @java.lang.Override
        @JsonSetter("source")
        public ContactsStage source(@NotNull ConversationSource source) {
            this.source = Objects.requireNonNull(source, "source must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("contacts")
        public TeammatesStage contacts(@NotNull ConversationContacts contacts) {
            this.contacts = Objects.requireNonNull(contacts, "contacts must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("teammates")
        public _FinalStage teammates(@NotNull ConversationTeammates teammates) {
            this.teammates = Objects.requireNonNull(teammates, "teammates must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage aiAgent(AiAgent aiAgent) {
            this.aiAgent = Optional.ofNullable(aiAgent);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "ai_agent", nulls = Nulls.SKIP)
        public _FinalStage aiAgent(Optional<AiAgent> aiAgent) {
            this.aiAgent = aiAgent;
            return this;
        }

        /**
         * <p>Indicates whether the AI Agent participated in the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage aiAgentParticipated(Boolean aiAgentParticipated) {
            this.aiAgentParticipated = Optional.ofNullable(aiAgentParticipated);
            return this;
        }

        /**
         * <p>Indicates whether the AI Agent participated in the conversation.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "ai_agent_participated", nulls = Nulls.SKIP)
        public _FinalStage aiAgentParticipated(Optional<Boolean> aiAgentParticipated) {
            this.aiAgentParticipated = aiAgentParticipated;
            return this;
        }

        @java.lang.Override
        public _FinalStage linkedObjects(LinkedObjectList linkedObjects) {
            this.linkedObjects = Optional.ofNullable(linkedObjects);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "linked_objects", nulls = Nulls.SKIP)
        public _FinalStage linkedObjects(Optional<LinkedObjectList> linkedObjects) {
            this.linkedObjects = linkedObjects;
            return this;
        }

        @java.lang.Override
        public _FinalStage conversationParts(ConversationParts conversationParts) {
            this.conversationParts = Optional.ofNullable(conversationParts);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "conversation_parts", nulls = Nulls.SKIP)
        public _FinalStage conversationParts(Optional<ConversationParts> conversationParts) {
            this.conversationParts = conversationParts;
            return this;
        }

        @java.lang.Override
        public _FinalStage statistics(ConversationStatistics statistics) {
            this.statistics = Optional.ofNullable(statistics);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "statistics", nulls = Nulls.SKIP)
        public _FinalStage statistics(Optional<ConversationStatistics> statistics) {
            this.statistics = statistics;
            return this;
        }

        @java.lang.Override
        public _FinalStage slaApplied(SlaApplied slaApplied) {
            this.slaApplied = Optional.ofNullable(slaApplied);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sla_applied", nulls = Nulls.SKIP)
        public _FinalStage slaApplied(Optional<SlaApplied> slaApplied) {
            this.slaApplied = slaApplied;
            return this;
        }

        @java.lang.Override
        public _FinalStage firstContactReply(ConversationFirstContactReply firstContactReply) {
            this.firstContactReply = Optional.ofNullable(firstContactReply);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "first_contact_reply", nulls = Nulls.SKIP)
        public _FinalStage firstContactReply(Optional<ConversationFirstContactReply> firstContactReply) {
            this.firstContactReply = firstContactReply;
            return this;
        }

        @java.lang.Override
        public _FinalStage customAttributes(String key, Object value) {
            this.customAttributes.put(key, value);
            return this;
        }

        @java.lang.Override
        public _FinalStage putAllCustomAttributes(Map<String, Object> customAttributes) {
            this.customAttributes.putAll(customAttributes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_attributes", nulls = Nulls.SKIP)
        public _FinalStage customAttributes(Map<String, Object> customAttributes) {
            this.customAttributes.clear();
            this.customAttributes.putAll(customAttributes);
            return this;
        }

        @java.lang.Override
        public _FinalStage conversationRating(ConversationRating conversationRating) {
            this.conversationRating = Optional.ofNullable(conversationRating);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "conversation_rating", nulls = Nulls.SKIP)
        public _FinalStage conversationRating(Optional<ConversationRating> conversationRating) {
            this.conversationRating = conversationRating;
            return this;
        }

        @java.lang.Override
        public _FinalStage tags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "tags", nulls = Nulls.SKIP)
        public _FinalStage tags(Optional<Tags> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * <p>The id of the team assigned to the conversation. If it's not assigned to a team it will return null.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage teamAssigneeId(String teamAssigneeId) {
            this.teamAssigneeId = Optional.ofNullable(teamAssigneeId);
            return this;
        }

        /**
         * <p>The id of the team assigned to the conversation. If it's not assigned to a team it will return null.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "team_assignee_id", nulls = Nulls.SKIP)
        public _FinalStage teamAssigneeId(Optional<String> teamAssigneeId) {
            this.teamAssigneeId = teamAssigneeId;
            return this;
        }

        /**
         * <p>The id of the admin assigned to the conversation. If it's not assigned to an admin it will return null.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage adminAssigneeId(Integer adminAssigneeId) {
            this.adminAssigneeId = Optional.ofNullable(adminAssigneeId);
            return this;
        }

        /**
         * <p>The id of the admin assigned to the conversation. If it's not assigned to an admin it will return null.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "admin_assignee_id", nulls = Nulls.SKIP)
        public _FinalStage adminAssigneeId(Optional<Integer> adminAssigneeId) {
            this.adminAssigneeId = adminAssigneeId;
            return this;
        }

        /**
         * <p>If marked as priority, it will return priority or else not_priority.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage priority(Priority priority) {
            this.priority = Optional.ofNullable(priority);
            return this;
        }

        /**
         * <p>If marked as priority, it will return priority or else not_priority.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "priority", nulls = Nulls.SKIP)
        public _FinalStage priority(Optional<Priority> priority) {
            this.priority = priority;
            return this;
        }

        /**
         * <p>If set this is the time in the future when this conversation will be marked as open. i.e. it will be in a snoozed state until this time. i.e. it will be in a snoozed state until this time.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage snoozedUntil(Integer snoozedUntil) {
            this.snoozedUntil = Optional.ofNullable(snoozedUntil);
            return this;
        }

        /**
         * <p>If set this is the time in the future when this conversation will be marked as open. i.e. it will be in a snoozed state until this time. i.e. it will be in a snoozed state until this time.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "snoozed_until", nulls = Nulls.SKIP)
        public _FinalStage snoozedUntil(Optional<Integer> snoozedUntil) {
            this.snoozedUntil = snoozedUntil;
            return this;
        }

        /**
         * <p>The last time a Contact responded to an Admin. In other words, the time a customer started waiting for a response. Set to null if last reply is from an Admin.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage waitingSince(Integer waitingSince) {
            this.waitingSince = Optional.ofNullable(waitingSince);
            return this;
        }

        /**
         * <p>The last time a Contact responded to an Admin. In other words, the time a customer started waiting for a response. Set to null if last reply is from an Admin.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "waiting_since", nulls = Nulls.SKIP)
        public _FinalStage waitingSince(Optional<Integer> waitingSince) {
            this.waitingSince = waitingSince;
            return this;
        }

        /**
         * <p>The title given to the conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage title(String title) {
            this.title = Optional.ofNullable(title);
            return this;
        }

        /**
         * <p>The title given to the conversation.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "title", nulls = Nulls.SKIP)
        public _FinalStage title(Optional<String> title) {
            this.title = title;
            return this;
        }

        /**
         * <p>Always conversation.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage type(String type) {
            this.type = Optional.ofNullable(type);
            return this;
        }

        /**
         * <p>Always conversation.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "type", nulls = Nulls.SKIP)
        public _FinalStage type(Optional<String> type) {
            this.type = type;
            return this;
        }

        @java.lang.Override
        public Conversation build() {
            return new Conversation(
                    type,
                    id,
                    title,
                    createdAt,
                    updatedAt,
                    waitingSince,
                    snoozedUntil,
                    open,
                    state,
                    read,
                    priority,
                    adminAssigneeId,
                    teamAssigneeId,
                    tags,
                    conversationRating,
                    source,
                    contacts,
                    teammates,
                    customAttributes,
                    firstContactReply,
                    slaApplied,
                    statistics,
                    conversationParts,
                    linkedObjects,
                    aiAgentParticipated,
                    aiAgent,
                    additionalProperties);
        }
    }

    public static final class Priority {
        public static final Priority PRIORITY = new Priority(Value.PRIORITY, "priority");

        public static final Priority NOT_PRIORITY = new Priority(Value.NOT_PRIORITY, "not_priority");

        private final Value value;

        private final String string;

        Priority(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof Priority && this.string.equals(((Priority) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case PRIORITY:
                    return visitor.visitPriority();
                case NOT_PRIORITY:
                    return visitor.visitNotPriority();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static Priority valueOf(String value) {
            switch (value) {
                case "priority":
                    return PRIORITY;
                case "not_priority":
                    return NOT_PRIORITY;
                default:
                    return new Priority(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            PRIORITY,

            NOT_PRIORITY,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitPriority();

            T visitNotPriority();

            T visitUnknown(String unknownType);
        }
    }

    public static final class State {
        public static final State SNOOZED = new State(Value.SNOOZED, "snoozed");

        public static final State CLOSED = new State(Value.CLOSED, "closed");

        public static final State OPEN = new State(Value.OPEN, "open");

        private final Value value;

        private final String string;

        State(Value value, String string) {
            this.value = value;
            this.string = string;
        }

        public Value getEnumValue() {
            return value;
        }

        @java.lang.Override
        @JsonValue
        public String toString() {
            return this.string;
        }

        @java.lang.Override
        public boolean equals(Object other) {
            return (this == other) || (other instanceof State && this.string.equals(((State) other).string));
        }

        @java.lang.Override
        public int hashCode() {
            return this.string.hashCode();
        }

        public <T> T visit(Visitor<T> visitor) {
            switch (value) {
                case SNOOZED:
                    return visitor.visitSnoozed();
                case CLOSED:
                    return visitor.visitClosed();
                case OPEN:
                    return visitor.visitOpen();
                case UNKNOWN:
                default:
                    return visitor.visitUnknown(string);
            }
        }

        @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
        public static State valueOf(String value) {
            switch (value) {
                case "snoozed":
                    return SNOOZED;
                case "closed":
                    return CLOSED;
                case "open":
                    return OPEN;
                default:
                    return new State(Value.UNKNOWN, value);
            }
        }

        public enum Value {
            OPEN,

            CLOSED,

            SNOOZED,

            UNKNOWN
        }

        public interface Visitor<T> {
            T visitOpen();

            T visitClosed();

            T visitSnoozed();

            T visitUnknown(String unknownType);
        }
    }
}
