/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.news.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Newsfeed.Builder.class)
public final class Newsfeed {
    private final String id;

    private final String name;

    private final int createdAt;

    private final Optional<Integer> updatedAt;

    private final Map<String, Object> additionalProperties;

    private Newsfeed(
            String id,
            String name,
            int createdAt,
            Optional<Integer> updatedAt,
            Map<String, Object> additionalProperties) {
        this.id = id;
        this.name = name;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier for the newsfeed which is given by Intercom.
     */
    @JsonProperty("id")
    public String getId() {
        return id;
    }

    /**
     * @return The type of object.
     */
    @JsonProperty("type")
    public String getType() {
        return "newsfeed";
    }

    /**
     * @return The name of the newsfeed. This name will never be visible to your users.
     */
    @JsonProperty("name")
    public String getName() {
        return name;
    }

    /**
     * @return Timestamp for when the newsfeed was created.
     */
    @JsonProperty("created_at")
    public int getCreatedAt() {
        return createdAt;
    }

    /**
     * @return Timestamp for when the newsfeed was last updated.
     */
    @JsonProperty("updated_at")
    public Optional<Integer> getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Newsfeed && equalTo((Newsfeed) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Newsfeed other) {
        return id.equals(other.id)
                && name.equals(other.name)
                && createdAt == other.createdAt
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.id, this.name, this.createdAt, this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        /**
         * The unique identifier for the newsfeed which is given by Intercom.
         */
        NameStage id(@NotNull String id);

        Builder from(Newsfeed other);
    }

    public interface NameStage {
        /**
         * The name of the newsfeed. This name will never be visible to your users.
         */
        CreatedAtStage name(@NotNull String name);
    }

    public interface CreatedAtStage {
        /**
         * Timestamp for when the newsfeed was created.
         */
        _FinalStage createdAt(int createdAt);
    }

    public interface _FinalStage {
        Newsfeed build();

        /**
         * <p>Timestamp for when the newsfeed was last updated.</p>
         */
        _FinalStage updatedAt(Optional<Integer> updatedAt);

        _FinalStage updatedAt(Integer updatedAt);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, NameStage, CreatedAtStage, _FinalStage {
        private String id;

        private String name;

        private int createdAt;

        private Optional<Integer> updatedAt = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Newsfeed other) {
            id(other.getId());
            name(other.getName());
            createdAt(other.getCreatedAt());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        /**
         * The unique identifier for the newsfeed which is given by Intercom.<p>The unique identifier for the newsfeed which is given by Intercom.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        /**
         * The name of the newsfeed. This name will never be visible to your users.<p>The name of the newsfeed. This name will never be visible to your users.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("name")
        public CreatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        /**
         * Timestamp for when the newsfeed was created.<p>Timestamp for when the newsfeed was created.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("created_at")
        public _FinalStage createdAt(int createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        /**
         * <p>Timestamp for when the newsfeed was last updated.</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage updatedAt(Integer updatedAt) {
            this.updatedAt = Optional.ofNullable(updatedAt);
            return this;
        }

        /**
         * <p>Timestamp for when the newsfeed was last updated.</p>
         */
        @java.lang.Override
        @JsonSetter(value = "updated_at", nulls = Nulls.SKIP)
        public _FinalStage updatedAt(Optional<Integer> updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @java.lang.Override
        public Newsfeed build() {
            return new Newsfeed(id, name, createdAt, updatedAt, additionalProperties);
        }
    }
}
