/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tags.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FindTagRequest.Builder.class)
public final class FindTagRequest {
    private final String tagId;

    private final Map<String, Object> additionalProperties;

    private FindTagRequest(String tagId, Map<String, Object> additionalProperties) {
        this.tagId = tagId;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return The unique identifier of a given tag
     */
    @JsonProperty("tag_id")
    public String getTagId() {
        return tagId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FindTagRequest && equalTo((FindTagRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FindTagRequest other) {
        return tagId.equals(other.tagId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.tagId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TagIdStage builder() {
        return new Builder();
    }

    public interface TagIdStage {
        /**
         * The unique identifier of a given tag
         */
        _FinalStage tagId(@NotNull String tagId);

        Builder from(FindTagRequest other);
    }

    public interface _FinalStage {
        FindTagRequest build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements TagIdStage, _FinalStage {
        private String tagId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FindTagRequest other) {
            tagId(other.getTagId());
            return this;
        }

        /**
         * The unique identifier of a given tag<p>The unique identifier of a given tag</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        @JsonSetter("tag_id")
        public _FinalStage tagId(@NotNull String tagId) {
            this.tagId = Objects.requireNonNull(tagId, "tagId must not be null");
            return this;
        }

        @java.lang.Override
        public FindTagRequest build() {
            return new FindTagRequest(tagId, additionalProperties);
        }
    }
}
