/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.intercom.api.resources.tickets.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.intercom.api.core.ObjectMappers;
import com.intercom.api.types.ContactReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TicketContacts.Builder.class)
public final class TicketContacts {
    private final List<ContactReference> contacts;

    private final Map<String, Object> additionalProperties;

    private TicketContacts(List<ContactReference> contacts, Map<String, Object> additionalProperties) {
        this.contacts = contacts;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return always contact.list
     */
    @JsonProperty("type")
    public String getType() {
        return "contact.list";
    }

    /**
     * @return The list of contacts affected by this ticket.
     */
    @JsonProperty("contacts")
    public List<ContactReference> getContacts() {
        return contacts;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TicketContacts && equalTo((TicketContacts) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TicketContacts other) {
        return contacts.equals(other.contacts);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.contacts);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<ContactReference> contacts = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(TicketContacts other) {
            contacts(other.getContacts());
            return this;
        }

        /**
         * <p>The list of contacts affected by this ticket.</p>
         */
        @JsonSetter(value = "contacts", nulls = Nulls.SKIP)
        public Builder contacts(List<ContactReference> contacts) {
            this.contacts.clear();
            this.contacts.addAll(contacts);
            return this;
        }

        public Builder addContacts(ContactReference contacts) {
            this.contacts.add(contacts);
            return this;
        }

        public Builder addAllContacts(List<ContactReference> contacts) {
            this.contacts.addAll(contacts);
            return this;
        }

        public TicketContacts build() {
            return new TicketContacts(contacts, additionalProperties);
        }
    }
}
